/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import madkit.kernel.InvalidAddressException;
import madkit.kernel.KernelAddress;

public class AgentAddress
implements Serializable {
    private static int launchNb = 0;
    private String name;
    private int localID;
    private KernelAddress kernel = null;

    public AgentAddress(String string, KernelAddress kernelAddress) {
        this.name = string;
        this.localID = ++launchNb;
        this.kernel = kernelAddress;
    }

    public AgentAddress(AgentAddress agentAddress) {
        this.localID = agentAddress.getLocalID();
        this.kernel = agentAddress.getKernel();
        this.name = agentAddress.getName();
    }

    public AgentAddress(String string) throws InvalidAddressException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":,@", true);
        try {
            stringTokenizer.nextToken();
            this.name = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            this.localID = Integer.parseInt(stringTokenizer.nextToken());
            stringTokenizer.nextToken();
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            this.kernel = new KernelAddress(stringBuffer.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new InvalidAddressException("Invalid AgentAddress !" + string);
        }
    }

    public String toString() {
        return this.name + "," + this.localID + this.kernel;
    }

    public boolean isLocal() {
        return this.kernel.isLocal();
    }

    public boolean equals(Object object) {
        try {
            AgentAddress agentAddress = (AgentAddress)object;
            return this.localID == agentAddress.localID && this.kernel.equals(agentAddress.getKernel());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public int getLocalID() {
        return this.localID;
    }

    public KernelAddress getKernel() {
        return this.kernel;
    }

    public final int hashCode() {
        return this.localID;
    }

    void update(KernelAddress kernelAddress) {
        this.localID = ++launchNb;
        this.kernel = kernelAddress;
    }

    void update(AgentAddress agentAddress) {
        this.localID = agentAddress.getLocalID();
        this.name = new String(agentAddress.getName());
        this.kernel = agentAddress.getKernel();
    }
}

