/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import madkit.TreeTools.DirIconDescriptor;
import madkit.TreeTools.FileIconDescriptor;
import madkit.TreeTools.GenericIconDescriptor;
import madkit.boot.Madkit;
import madkit.explorer.AntFileNode;
import madkit.explorer.BeanShellAgentNode;
import madkit.explorer.ConfigFileNode;
import madkit.explorer.EditableFileNode;
import madkit.explorer.Explorer;
import madkit.explorer.ExplorerActionDrag;
import madkit.explorer.FileIcon;
import madkit.explorer.FormalismNode;
import madkit.explorer.HTMLFileNode;
import madkit.explorer.IconPanel;
import madkit.explorer.JavaAgentNode;
import madkit.explorer.JessAgentNode;
import madkit.explorer.PropertyFileNode;
import madkit.explorer.PythonAgentNode;
import madkit.explorer.SEditFileNode;
import madkit.explorer.SchemeAgentNode;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Utils;
import madkit.utils.common.PropertyFile;

public class FileIconPanel
extends IconPanel {
    Explorer explorer;
    ExplorerActionDrag explorerActionDrag;

    public FileIconPanel(AbstractAgent abstractAgent, int n, Explorer explorer) {
        super(abstractAgent, n);
        this.explorer = explorer;
        this.explorerActionDrag = new ExplorerActionDrag();
    }

    public void addItem(File file) {
        FileIcon fileIcon = null;
        if (file.isDirectory()) {
            DirIconDescriptor dirIconDescriptor = file.listFiles() == null ? new DirIconDescriptor(true) : new DirIconDescriptor(false);
            fileIcon = new FileIcon(this.ag, file, (GenericIconDescriptor)dirIconDescriptor, this.iconSize, (IconPanel)this);
        } else {
            FileIconDescriptor fileIconDescriptor = new FileIconDescriptor();
            String string = FileIconDescriptor.getPathExtens((String)file.getName());
            fileIcon = string != null ? (string.equalsIgnoreCase("class") || string.equalsIgnoreCase("bak") || file.getName().endsWith("~") || file.getName().endsWith("#") ? null : (string.equalsIgnoreCase("py") ? new PythonAgentNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("bsh") ? new BeanShellAgentNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("scm") ? new SchemeAgentNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("clp") ? new JessAgentNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("fml") ? new FormalismNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("cfg") ? new ConfigFileNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("sed") ? new SEditFileNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("html") || string.equalsIgnoreCase("htm") ? new HTMLFileNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (file.getName().endsWith("build.xml") ? new AntFileNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("xml") || string.equalsIgnoreCase("txt") || string.equalsIgnoreCase("java") ? new EditableFileNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : (string.equalsIgnoreCase("properties") ? (!this.processPropertyFileNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, this) ? new PropertyFileNode(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this) : null) : new FileIcon(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this))))))))))))) : new FileIcon(this.ag, file, (GenericIconDescriptor)fileIconDescriptor, this.iconSize, (IconPanel)this);
        }
        if (fileIcon != null) {
            this.add(fileIcon);
            ++this.Nb_Icons;
            this.setPreferredSize(new Dimension(this.iconSize, this.Nb_Icons * this.iconSize));
            this.repaint();
        }
    }

    public boolean processPropertyFileNode(AbstractAgent abstractAgent, File file, GenericIconDescriptor genericIconDescriptor, int n, IconPanel iconPanel) {
        PropertyFile propertyFile = new PropertyFile();
        propertyFile.loadFrom(file);
        String string = propertyFile.getProperty("madkit.plugin.name");
        if (string != null) {
            string = string + ".jar";
            String string2 = Madkit.libDirectory + File.separator + string;
            File file2 = new File(string2);
            if (!file2.exists()) {
                return false;
            }
            String string3 = propertyFile.getProperty("madkit.plugin.agents");
            String string4 = null;
            string4 = string3 == null ? null : (string3.equalsIgnoreCase("${agents}") || string3.equalsIgnoreCase("all") ? null : (string3.equalsIgnoreCase("none") || string3.equals("") ? "" : string3));
            this.processJarFile(abstractAgent, file2, n, iconPanel, string4);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void processJarFile(AbstractAgent abstractAgent, File file, int n, IconPanel iconPanel, String string) {
        String string2 = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,:;&\t\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                int n2 = string2.lastIndexOf(".");
                String string3 = string2;
                if (n2 != -1) {
                    string3 = string2.substring(n2 + 1);
                }
                this.installAgent(string3, string2, iconPanel, n, abstractAgent);
            }
            return;
        } else {
            try {
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && manifest.getEntries().size() > 0) {
                    boolean bl = false;
                    Map<String, Attributes> map = manifest.getEntries();
                    for (String string4 : map.keySet()) {
                        Attributes attributes = map.get(string4);
                        String string5 = attributes.getValue("Agent");
                        if (string5 == null) {
                            string5 = attributes.getValue("Bean");
                        }
                        if (string5 == null || !string5.equalsIgnoreCase("true")) continue;
                        bl = true;
                        int n3 = string4.lastIndexOf(46);
                        string2 = string4.substring(0, n3).replace('/', '.');
                        int n4 = string2.lastIndexOf(".");
                        String string6 = string2;
                        if (n4 != -1) {
                            string6 = string2.substring(n4 + 1);
                        }
                        this.installAgent(string6, string2, iconPanel, n, abstractAgent);
                    }
                    if (!bl) return;
                    return;
                }
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string7 = jarEntry.getName();
                    if (jarEntry.isDirectory() || !string7.endsWith(".class")) continue;
                    int n5 = string7.lastIndexOf(46);
                    string2 = string7.substring(0, n5).replace('/', '.');
                    int n6 = string2.lastIndexOf(".");
                    String string8 = string2;
                    if (n6 != -1) {
                        string8 = string2.substring(n6 + 1);
                    }
                    this.installAgent(string8, string2, iconPanel, n, abstractAgent);
                }
                return;
            }
            catch (IOException iOException) {
                System.err.println("Not a good jar file : " + file.getName());
                return;
            }
            catch (Exception exception) {
                System.err.println("Error while loading class : " + string2 + " check its default constructor");
            }
        }
    }

    void installAgent(String string, String string2, IconPanel iconPanel, int n, AbstractAgent abstractAgent) {
        try {
            Class clazz = Utils.loadClass((String)string2);
            if (Utils.loadClass((String)"madkit.kernel.AbstractAgent").isAssignableFrom(clazz)) {
                Class[] classArray = new Class[0];
                Constructor constructor = clazz.getConstructor(classArray);
                if (constructor == null) {
                    System.err.println("WARNING: class " + string2 + " does not have default constructor");
                } else {
                    iconPanel.add(new JavaAgentNode(abstractAgent, n, iconPanel, string, string2));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Error : class not found : " + string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Error : default constructor of class " + string2 + " not found : ");
        }
        catch (Exception exception) {
            System.err.print("Error while loading class : " + string2 + " error: " + exception);
        }
        catch (Throwable throwable) {
            System.err.println("Error : class " + string2 + " contains dependencies which are not in the classpath");
        }
    }

    public void doubleClick(AWTEvent aWTEvent) {
        FileIcon fileIcon = (FileIcon)aWTEvent.getSource();
        File file = fileIcon.getFile();
        String string = fileIcon.getName();
        if (file.isDirectory()) {
            if (file.listFiles() == null) {
                return;
            }
            String string2 = this.explorer.getAbsolutePath();
            this.explorer.setAbsolutePath(string2 + File.separator + string);
            if (!this.explorer.readDown()) {
                this.explorer.setAbsolutePath(string2);
            }
        } else {
            fileIcon.execute();
        }
    }

    public void simpleClick(AWTEvent aWTEvent) {
        FileIcon fileIcon = (FileIcon)aWTEvent.getSource();
        this.explorerActionDrag.execIcon(this.explorer, fileIcon);
    }
}

