/*
 * Decompiled with CFR 0.152.
 */
package madkit.explorer;

import java.awt.Image;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import madkit.TreeTools.GenericIconDescriptor;
import madkit.explorer.ExplorerOptionPane;
import madkit.explorer.Icon;
import madkit.explorer.IconPanel;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Utils;
import madkit.utils.graphics.GraphicUtils;

public class FileIcon
extends Icon {
    File file;
    int iconSize;

    public FileIcon(AbstractAgent abstractAgent, File file, GenericIconDescriptor genericIconDescriptor, int n, IconPanel iconPanel) {
        super(abstractAgent, genericIconDescriptor, file.getName(), n, iconPanel);
        this.file = file;
        this.setDescriptor(genericIconDescriptor);
        this.iconSize = n;
    }

    public File getFile() {
        return this.file;
    }

    protected Image getImage() {
        URL uRL;
        ImageIcon imageIcon = this.desc.getImage(this.file);
        if (imageIcon == null && (uRL = this.getClass().getResource("/images/kde/document.png")) != null) {
            imageIcon = new ImageIcon(uRL);
        }
        if (imageIcon == null) {
            return null;
        }
        return imageIcon.getImage();
    }

    public void info() {
        JOptionPane.showMessageDialog(this.iconPanel, "NodeType: " + this.getClass().getName() + "\nFile: " + this.getFile(), "Properties of " + this.getName(), 1);
    }

    public void rename() {
        String string = this.file.getAbsolutePath();
        String string2 = this.file.getParent();
        String string3 = this.file.getName();
        String string4 = Utils.getFileNameFromPath((String)string3);
        String string5 = "TO";
        String string6 = "RENAME FILE ";
        String string7 = ExplorerOptionPane.askForName(string4, string5, string6);
        File file = new File(string);
        File file2 = new File(string);
        if (string7 != null && !string7.equals(string4)) {
            this.iconPanel.renameItem(this.desc, string3, string7);
            file2 = new File(string2 + File.separatorChar + string7);
            file.renameTo(file2);
            this.file = file2;
        }
    }

    public void delete() {
        String string = this.file.getAbsolutePath();
        String string2 = this.file.getParent();
        String string3 = "Do you really want to delete this file ?";
        String string4 = "DELETE FILE ";
        int n = ExplorerOptionPane.yesNo(string3, string4);
        if (n == 0) {
            File file = new File(string2);
            boolean bl = this.file.delete();
            if (bl) {
                String string5 = this.file.getName();
                this.iconPanel.renameItem(this.desc, string5, null);
                this.file = file;
            }
        }
    }

    public void execute() {
        GraphicUtils.execute((String)this.file.getAbsolutePath());
    }
}

