/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPClientModule;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.UncompressInputStream;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

class ContentEncodingModule
implements HTTPClientModule {
    ContentEncodingModule() {
    }

    public int requestHandler(Request request, Response[] responseArray) throws ModuleException {
        Vector<HttpHeaderElement> vector;
        int n;
        NVPair[] nVPairArray = request.getHeaders();
        for (n = 0; n < nVPairArray.length && !nVPairArray[n].getName().equalsIgnoreCase("Accept-Encoding"); ++n) {
        }
        if (n == nVPairArray.length) {
            nVPairArray = Util.resizeArray(nVPairArray, n + 1);
            request.setHeaders(nVPairArray);
            vector = new Vector<HttpHeaderElement>();
        } else {
            try {
                vector = Util.parseHeader(nVPairArray[n].getValue());
            }
            catch (ParseException parseException) {
                throw new ModuleException(parseException.toString());
            }
        }
        HttpHeaderElement httpHeaderElement = Util.getElement(vector, "*");
        if (httpHeaderElement != null) {
            NVPair[] nVPairArray2 = httpHeaderElement.getParams();
            for (n = 0; n < nVPairArray2.length && !nVPairArray2[n].getName().equalsIgnoreCase("q"); ++n) {
            }
            if (n == nVPairArray2.length) {
                return 0;
            }
            if (nVPairArray2[n].getValue() == null || nVPairArray2[n].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: ");
            }
            try {
                if ((double)Float.valueOf(nVPairArray2[n].getValue()).floatValue() > 0.0) {
                    return 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: " + numberFormatException.getMessage());
            }
        }
        if (!vector.contains(new HttpHeaderElement("deflate"))) {
            vector.addElement(new HttpHeaderElement("deflate"));
        }
        if (!vector.contains(new HttpHeaderElement("gzip"))) {
            vector.addElement(new HttpHeaderElement("gzip"));
        }
        if (!vector.contains(new HttpHeaderElement("x-gzip"))) {
            vector.addElement(new HttpHeaderElement("x-gzip"));
        }
        if (!vector.contains(new HttpHeaderElement("compress"))) {
            vector.addElement(new HttpHeaderElement("compress"));
        }
        if (!vector.contains(new HttpHeaderElement("x-compress"))) {
            vector.addElement(new HttpHeaderElement("x-compress"));
        }
        nVPairArray[n] = new NVPair("Accept-Encoding", Util.assembleHeader(vector));
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) {
    }

    public int responsePhase2Handler(Response response, Request request) {
        return 10;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) throws IOException, ModuleException {
        Vector vector;
        String string = response.getHeader("Content-Encoding");
        if (string == null || roRequest.getMethod().equals("HEAD") || response.getStatusCode() == 206) {
            return;
        }
        try {
            vector = Util.parseHeader(string);
        }
        catch (ParseException parseException) {
            throw new ModuleException(parseException.toString());
        }
        if (vector.size() == 0) {
            return;
        }
        String string2 = ((HttpHeaderElement)vector.firstElement()).getName();
        if (string2.equalsIgnoreCase("gzip") || string2.equalsIgnoreCase("x-gzip")) {
            Log.write(32, "CEM:   pushing gzip-input-stream");
            response.inp_stream = new GZIPInputStream(response.inp_stream);
            vector.removeElementAt(vector.size() - 1);
            response.deleteHeader("Content-length");
        } else if (string2.equalsIgnoreCase("deflate")) {
            Log.write(32, "CEM:   pushing inflater-input-stream");
            response.inp_stream = new InflaterInputStream(response.inp_stream);
            vector.removeElementAt(vector.size() - 1);
            response.deleteHeader("Content-length");
        } else if (string2.equalsIgnoreCase("compress") || string2.equalsIgnoreCase("x-compress")) {
            Log.write(32, "CEM:   pushing uncompress-input-stream");
            response.inp_stream = new UncompressInputStream(response.inp_stream);
            vector.removeElementAt(vector.size() - 1);
            response.deleteHeader("Content-length");
        } else if (string2.equalsIgnoreCase("identity")) {
            Log.write(32, "CEM:   ignoring 'identity' token");
            vector.removeElementAt(vector.size() - 1);
        } else {
            Log.write(32, "CEM:   Unknown content encoding '" + string2 + "'");
        }
        if (vector.size() > 0) {
            response.setHeader("Content-Encoding", Util.assembleHeader(vector));
        } else {
            response.deleteHeader("Content-Encoding");
        }
    }

    public void trailerHandler(Response response, RoRequest roRequest) {
    }
}

