/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.Cookie2;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.DefaultCookiePolicyHandler;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.Log;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ProtocolException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CookieModule
implements HTTPClientModule {
    private static Hashtable cookie_cntxt_list;
    private static File cookie_jar;
    private static Object cookieSaver;
    private static CookiePolicyHandler cookie_handler;

    private static void loadCookies() {
        try {
            cookie_jar = new File(CookieModule.getCookieJarName());
            if (cookie_jar.isFile() && cookie_jar.canRead()) {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(cookie_jar));
                cookie_cntxt_list.put(HTTPConnection.getDefaultContext(), (Hashtable)objectInputStream.readObject());
                objectInputStream.close();
            }
        }
        catch (Throwable throwable) {
            cookie_jar = null;
        }
    }

    private static void saveCookies() {
        if (cookie_jar != null && (!cookie_jar.exists() || cookie_jar.isFile() && cookie_jar.canWrite())) {
            Object object;
            Hashtable<Cookie, Cookie> hashtable = new Hashtable<Cookie, Cookie>();
            Enumeration enumeration = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext()).elements();
            while (enumeration.hasMoreElements()) {
                object = (Cookie)enumeration.nextElement();
                if (((Cookie)object).discard()) continue;
                hashtable.put((Cookie)object, (Cookie)object);
            }
            if (hashtable.size() > 0) {
                try {
                    object = new ObjectOutputStream(new FileOutputStream(cookie_jar));
                    ((ObjectOutputStream)object).writeObject(hashtable);
                    ((ObjectOutputStream)object).close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static String getCookieJarName() {
        String string = null;
        try {
            string = System.getProperty("HTTPClient.cookies.jar");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            String string2 = System.getProperty("os.name");
            string = string2.equalsIgnoreCase("Windows 95") || string2.equalsIgnoreCase("16-bit Windows") || string2.equalsIgnoreCase("Windows") ? System.getProperty("java.home") + File.separator + ".httpclient_cookies" : (string2.equalsIgnoreCase("Windows NT") ? System.getProperty("user.home") + File.separator + ".httpclient_cookies" : (string2.equalsIgnoreCase("OS/2") ? System.getProperty("user.home") + File.separator + ".httpclient_cookies" : (string2.equalsIgnoreCase("Mac OS") || string2.equalsIgnoreCase("MacOS") ? "System Folder" + File.separator + "Preferences" + File.separator + "HTTPClientCookies" : System.getProperty("user.home") + File.separator + ".httpclient_cookies")));
        }
        return string;
    }

    CookieModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestHandler(Request request, Response[] responseArray) {
        Hashtable hashtable;
        NVPair[] nVPairArray = request.getHeaders();
        int n = nVPairArray.length;
        for (int i = 0; i < nVPairArray.length; ++i) {
            int n2 = i;
            while (i < nVPairArray.length && nVPairArray[i].getName().equalsIgnoreCase("Cookie")) {
                ++i;
            }
            if (i - n2 <= 0) continue;
            System.arraycopy(nVPairArray, i, nVPairArray, n2, (n -= i - n2) - n2);
        }
        if (n < nVPairArray.length) {
            nVPairArray = Util.resizeArray(nVPairArray, n);
            request.setHeaders(nVPairArray);
        }
        if ((hashtable = Util.getList(cookie_cntxt_list, request.getConnection().getContext())).size() == 0) {
            return 0;
        }
        Vector<String> vector = new Vector<String>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n3 = 0;
        Serializable serializable = hashtable;
        synchronized (serializable) {
            Enumeration enumeration = hashtable.elements();
            Vector<Cookie> vector3 = null;
            while (enumeration.hasMoreElements()) {
                int n4;
                Cookie cookie = (Cookie)enumeration.nextElement();
                if (cookie.hasExpired()) {
                    Log.write(16, "CookM: cookie has expired and is being removed: " + cookie);
                    if (vector3 == null) {
                        vector3 = new Vector<Cookie>();
                    }
                    vector3.addElement(cookie);
                    continue;
                }
                if (!cookie.sendWith(request) || cookie_handler != null && !cookie_handler.sendCookie(cookie, request)) continue;
                int n5 = cookie.getPath().length();
                for (n4 = 0; n4 < vector2.size() && (Integer)vector2.elementAt(n4) >= n5; ++n4) {
                }
                vector.insertElementAt(cookie.toExternalForm(), n4);
                vector2.insertElementAt(new Integer(n5), n4);
                if (!(cookie instanceof Cookie2)) continue;
                n3 = Math.max(n3, ((Cookie2)cookie).getVersion());
            }
            if (vector3 != null) {
                for (int i = 0; i < vector3.size(); ++i) {
                    hashtable.remove(vector3.elementAt(i));
                }
            }
        }
        if (!vector.isEmpty()) {
            int n6;
            serializable = new StringBuffer();
            if (n3 > 0) {
                ((StringBuffer)serializable).append("$Version=\"" + n3 + "\"; ");
            }
            ((StringBuffer)serializable).append((String)vector.elementAt(0));
            for (n6 = 1; n6 < vector.size(); ++n6) {
                ((StringBuffer)serializable).append("; ");
                ((StringBuffer)serializable).append((String)vector.elementAt(n6));
            }
            nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
            nVPairArray[nVPairArray.length - 1] = new NVPair("Cookie", ((StringBuffer)serializable).toString());
            if (n3 != 1) {
                for (n6 = 0; n6 < nVPairArray.length && !nVPairArray[n6].getName().equalsIgnoreCase("Cookie2"); ++n6) {
                }
                if (n6 == nVPairArray.length) {
                    nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
                    nVPairArray[nVPairArray.length - 1] = new NVPair("Cookie2", "$Version=\"1\"");
                }
            }
            request.setHeaders(nVPairArray);
            Log.write(16, "CookM: Sending cookies '" + serializable + "'");
        }
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) throws IOException {
        String string = response.getHeader("Set-Cookie");
        String string2 = response.getHeader("Set-Cookie2");
        if (string == null && string2 == null) {
            return;
        }
        response.deleteHeader("Set-Cookie");
        response.deleteHeader("Set-Cookie2");
        if (string != null) {
            this.handleCookie(string, false, roRequest, response);
        }
        if (string2 != null) {
            this.handleCookie(string2, true, roRequest, response);
        }
    }

    public int responsePhase2Handler(Response response, Request request) {
        return 10;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) {
    }

    public void trailerHandler(Response response, RoRequest roRequest) throws IOException {
        String string = response.getTrailer("Set-Cookie");
        String string2 = response.getTrailer("Set-Cookie2");
        if (string == null && string2 == null) {
            return;
        }
        response.deleteTrailer("Set-Cookie");
        response.deleteTrailer("Set-Cookie2");
        if (string != null) {
            this.handleCookie(string, false, roRequest, response);
        }
        if (string2 != null) {
            this.handleCookie(string2, true, roRequest, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCookie(String string, boolean bl, RoRequest roRequest, Response response) throws ProtocolException {
        Hashtable hashtable;
        Cookie[] cookieArray = bl ? Cookie2.parse(string, roRequest) : Cookie.parse(string, roRequest);
        if (Log.isEnabled(16)) {
            Log.write(16, "CookM: Received and parsed " + cookieArray.length + " cookies:");
            for (int i = 0; i < cookieArray.length; ++i) {
                Log.write(16, "CookM: Cookie " + i + ": " + cookieArray[i]);
            }
        }
        Hashtable hashtable2 = hashtable = Util.getList(cookie_cntxt_list, roRequest.getConnection().getContext());
        synchronized (hashtable2) {
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = (Cookie)hashtable.get(cookieArray[i]);
                if (cookie != null && cookieArray[i].hasExpired()) {
                    Log.write(16, "CookM: cookie has expired and is being removed: " + cookie);
                    hashtable.remove(cookie);
                    continue;
                }
                if (cookieArray[i].hasExpired() || cookie_handler != null && !cookie_handler.acceptCookie(cookieArray[i], roRequest, response)) continue;
                hashtable.put(cookieArray[i], cookieArray[i]);
            }
        }
    }

    public static void discardAllCookies() {
        cookie_cntxt_list.clear();
    }

    public static void discardAllCookies(Object object) {
        if (object != null) {
            cookie_cntxt_list.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies() {
        Hashtable hashtable = cookie_cntxt_list;
        synchronized (hashtable) {
            Cookie[] cookieArray = new Cookie[]{};
            int n = 0;
            Enumeration enumeration = cookie_cntxt_list.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable2;
                Hashtable hashtable3 = hashtable2 = (Hashtable)enumeration.nextElement();
                synchronized (hashtable3) {
                    cookieArray = Util.resizeArray(cookieArray, n + hashtable2.size());
                    Enumeration enumeration2 = hashtable2.elements();
                    while (enumeration2.hasMoreElements()) {
                        cookieArray[n++] = (Cookie)enumeration2.nextElement();
                    }
                }
            }
            return cookieArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] listAllCookies(Object object) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = Util.getList(cookie_cntxt_list, object);
        synchronized (hashtable2) {
            Cookie[] cookieArray = new Cookie[hashtable.size()];
            int n = 0;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                cookieArray[n++] = (Cookie)enumeration.nextElement();
            }
            return cookieArray;
        }
    }

    public static void addCookie(Cookie cookie) {
        Hashtable hashtable = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        hashtable.put(cookie, cookie);
    }

    public static void addCookie(Cookie cookie, Object object) {
        Hashtable hashtable = Util.getList(cookie_cntxt_list, object);
        hashtable.put(cookie, cookie);
    }

    public static void removeCookie(Cookie cookie) {
        Hashtable hashtable = Util.getList(cookie_cntxt_list, HTTPConnection.getDefaultContext());
        hashtable.remove(cookie);
    }

    public static void removeCookie(Cookie cookie, Object object) {
        Hashtable hashtable = Util.getList(cookie_cntxt_list, object);
        hashtable.remove(cookie);
    }

    public static synchronized CookiePolicyHandler setCookiePolicyHandler(CookiePolicyHandler cookiePolicyHandler) {
        CookiePolicyHandler cookiePolicyHandler2 = cookie_handler;
        cookie_handler = cookiePolicyHandler;
        return cookiePolicyHandler2;
    }

    static {
        boolean bl;
        cookie_cntxt_list = new Hashtable();
        cookie_jar = null;
        cookieSaver = null;
        cookie_handler = new DefaultCookiePolicyHandler();
        try {
            bl = Boolean.getBoolean("HTTPClient.cookies.save");
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            CookieModule.loadCookies();
            cookieSaver = new Object(){

                public void finalize() {
                    CookieModule.saveCookies();
                }
            };
            try {
                System.runFinalizersOnExit((boolean)true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

