/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.RoRequest;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cookie2
extends Cookie {
    private static final long serialVersionUID = 2208203902820875917L;
    protected int version;
    protected boolean discard;
    protected String comment;
    protected URI comment_url;
    protected int[] port_list;
    protected String port_list_str;
    protected boolean path_set;
    protected boolean port_set;
    protected boolean domain_set;

    public Cookie2(String string, String string2, String string3, int[] nArray, String string4, Date date, boolean bl, boolean bl2, String string5, URI uRI) {
        super(string, string2, string3, string4, date, bl2);
        this.discard = bl;
        this.port_list = nArray;
        this.comment = string5;
        this.comment_url = uRI;
        this.path_set = true;
        this.domain_set = true;
        if (nArray != null && nArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nArray[0]);
            for (int i = 1; i < nArray.length; ++i) {
                stringBuffer.append(',');
                stringBuffer.append(nArray[i]);
            }
            this.port_list_str = stringBuffer.toString();
            this.port_set = true;
        }
        this.version = 1;
    }

    protected Cookie2(RoRequest roRequest) {
        super(roRequest);
        this.path = Util.getPath(roRequest.getRequestURI());
        int n = this.path.lastIndexOf(47);
        if (n != -1) {
            this.path = this.path.substring(0, n + 1);
        }
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
        this.version = -1;
        this.discard = false;
        this.comment = null;
        this.comment_url = null;
        this.port_list = null;
        this.port_list_str = null;
        this.path_set = false;
        this.port_set = false;
        this.domain_set = false;
    }

    protected static Cookie[] parse(String string, RoRequest roRequest) throws ProtocolException {
        Vector vector;
        try {
            vector = Util.parseHeader(string);
        }
        catch (ParseException parseException) {
            throw new ProtocolException(parseException.getMessage());
        }
        Cookie[] cookieArray = new Cookie[vector.size()];
        int n = 0;
        for (int i = 0; i < cookieArray.length; ++i) {
            HttpHeaderElement httpHeaderElement = (HttpHeaderElement)vector.elementAt(i);
            if (httpHeaderElement.getValue() == null) {
                throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nMissing value " + "for cookie '" + httpHeaderElement.getName() + "'");
            }
            Cookie2 cookie2 = new Cookie2(roRequest);
            cookie2.name = httpHeaderElement.getName();
            cookie2.value = httpHeaderElement.getValue();
            NVPair[] nVPairArray = httpHeaderElement.getParams();
            boolean bl = false;
            boolean bl2 = false;
            for (int j = 0; j < nVPairArray.length; ++j) {
                String string2 = nVPairArray[j].getName().toLowerCase();
                if ((string2.equals("version") || string2.equals("max-age") || string2.equals("domain") || string2.equals("path") || string2.equals("comment") || string2.equals("commenturl")) && nVPairArray[j].getValue() == null) {
                    throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nMissing value " + "for " + nVPairArray[j].getName() + " attribute in cookie '" + httpHeaderElement.getName() + "'");
                }
                if (string2.equals("version")) {
                    if (cookie2.version != -1) continue;
                    try {
                        cookie2.version = Integer.parseInt(nVPairArray[j].getValue());
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nVersion '" + nVPairArray[j].getValue() + "' not a number");
                    }
                }
                if (string2.equals("path")) {
                    if (cookie2.path_set) continue;
                    cookie2.path = nVPairArray[j].getValue();
                    cookie2.path_set = true;
                    continue;
                }
                if (string2.equals("domain")) {
                    if (cookie2.domain_set) continue;
                    String string3 = nVPairArray[j].getValue().toLowerCase();
                    cookie2.domain = string3.charAt(0) != '.' && !string3.equals(cookie2.domain) ? "." + string3 : string3;
                    cookie2.domain_set = true;
                    continue;
                }
                if (string2.equals("max-age")) {
                    int n2;
                    if (cookie2.expires != null) continue;
                    try {
                        n2 = Integer.parseInt(nVPairArray[j].getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nMax-Age '" + nVPairArray[j].getValue() + "' not a number");
                    }
                    cookie2.expires = new Date(System.currentTimeMillis() + (long)n2 * 1000L);
                    continue;
                }
                if (string2.equals("port")) {
                    if (cookie2.port_set) continue;
                    if (nVPairArray[j].getValue() == null) {
                        cookie2.port_list = new int[1];
                        cookie2.port_list[0] = roRequest.getConnection().getPort();
                        cookie2.port_set = true;
                        continue;
                    }
                    cookie2.port_list_str = nVPairArray[j].getValue();
                    StringTokenizer stringTokenizer = new StringTokenizer(nVPairArray[j].getValue(), ",");
                    cookie2.port_list = new int[stringTokenizer.countTokens()];
                    for (int k = 0; k < cookie2.port_list.length; ++k) {
                        String string4 = stringTokenizer.nextToken().trim();
                        try {
                            cookie2.port_list[k] = Integer.parseInt(string4);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nPort '" + string4 + "' not a number");
                        }
                    }
                    cookie2.port_set = true;
                    continue;
                }
                if (string2.equals("discard")) {
                    if (bl) continue;
                    cookie2.discard = true;
                    bl = true;
                    continue;
                }
                if (string2.equals("secure")) {
                    if (bl2) continue;
                    cookie2.secure = true;
                    bl2 = true;
                    continue;
                }
                if (string2.equals("comment")) {
                    if (cookie2.comment != null) continue;
                    try {
                        cookie2.comment = new String(nVPairArray[j].getValue().getBytes("8859_1"), "UTF8");
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new Error(unsupportedEncodingException.toString());
                    }
                }
                if (!string2.equals("commenturl") || cookie2.comment_url != null) continue;
                try {
                    cookie2.comment_url = new URI(nVPairArray[j].getValue());
                    continue;
                }
                catch (ParseException parseException) {
                    throw new ProtocolException("Bad Set-Cookie2 header: " + string + "\nCommentURL '" + nVPairArray[j].getValue() + "' not a valid URL");
                }
            }
            if (cookie2.version == -1) continue;
            if (cookie2.expires == null) {
                cookie2.discard = true;
            }
            if (!Util.getPath(roRequest.getRequestURI()).startsWith(cookie2.path)) {
                Log.write(16, "Cook2: Bad Set-Cookie2 header: " + string + "\n       path `" + cookie2.path + "' is not a prefix of the " + "request uri `" + roRequest.getRequestURI() + "'");
                continue;
            }
            String string5 = roRequest.getConnection().getHost();
            if (string5.indexOf(46) == -1) {
                string5 = string5 + ".local";
            }
            if (!cookie2.domain.equals(".local") && cookie2.domain.indexOf(46, 1) == -1) {
                Log.write(16, "Cook2: Bad Set-Cookie2 header: " + string + "\n       domain `" + cookie2.domain + "' is not `.local' and " + "doesn't contain two `.'s");
                continue;
            }
            if (!string5.endsWith(cookie2.domain)) {
                Log.write(16, "Cook2: Bad Set-Cookie2 header: " + string + "\n       domain `" + cookie2.domain + "' does not match current" + "host `" + string5 + "'");
                continue;
            }
            if (string5.substring(0, string5.length() - cookie2.domain.length()).indexOf(46) != -1) {
                Log.write(16, "Cook2: Bad Set-Cookie2 header: " + string + "\n       domain `" + cookie2.domain + "' is more than one `.'" + "away from host `" + string5 + "'");
                continue;
            }
            if (cookie2.port_set) {
                int n3 = 0;
                for (n3 = 0; n3 < cookie2.port_list.length && cookie2.port_list[n3] != roRequest.getConnection().getPort(); ++n3) {
                }
                if (n3 == cookie2.port_list.length) {
                    Log.write(16, "Cook2: Bad Set-Cookie2 header: " + string + "\n       port list " + "does include current port " + roRequest.getConnection().getPort());
                    continue;
                }
            }
            cookieArray[n++] = cookie2;
        }
        if (n < cookieArray.length) {
            cookieArray = Util.resizeArray(cookieArray, n);
        }
        return cookieArray;
    }

    public int getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public URI getCommentURL() {
        return this.comment_url;
    }

    public int[] getPorts() {
        return this.port_list;
    }

    public boolean discard() {
        return this.discard;
    }

    protected boolean sendWith(RoRequest roRequest) {
        String string;
        boolean bl;
        HTTPConnection hTTPConnection = roRequest.getConnection();
        boolean bl2 = bl = !this.port_set;
        if (this.port_set) {
            for (int i = 0; i < this.port_list.length; ++i) {
                if (this.port_list[i] != hTTPConnection.getPort()) continue;
                bl = true;
                break;
            }
        }
        if ((string = hTTPConnection.getHost()).indexOf(46) == -1) {
            string = string + ".local";
        }
        return (this.domain.charAt(0) == '.' && string.endsWith(this.domain) || this.domain.charAt(0) != '.' && string.equals(this.domain)) && bl && Util.getPath(roRequest.getRequestURI()).startsWith(this.path) && (!this.secure || hTTPConnection.getProtocol().equals("https") || hTTPConnection.getProtocol().equals("shttp"));
    }

    protected String toExternalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.version == 1) {
            stringBuffer.append(this.name);
            stringBuffer.append("=");
            stringBuffer.append(this.value);
            if (this.path_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Path=");
                stringBuffer.append(this.path);
            }
            if (this.domain_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Domain=");
                stringBuffer.append(this.domain);
            }
            if (this.port_set) {
                stringBuffer.append("; ");
                stringBuffer.append("$Port");
                if (this.port_list_str != null) {
                    stringBuffer.append("=\"");
                    stringBuffer.append(this.port_list_str);
                    stringBuffer.append('\"');
                }
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name.length() + this.value.length() + 50);
        stringBuffer.append(this.name).append('=').append(this.value);
        if (this.version == 1) {
            stringBuffer.append("; Version=").append(this.version);
            stringBuffer.append("; Path=").append(this.path);
            stringBuffer.append("; Domain=").append(this.domain);
            if (this.port_set) {
                stringBuffer.append("; Port=\"").append(this.port_list[0]);
                for (int i = 1; i < this.port_list.length; ++i) {
                    stringBuffer.append(',').append(this.port_list[i]);
                }
                stringBuffer.append('\"');
            }
            if (this.expires != null) {
                stringBuffer.append("; Max-Age=").append((this.expires.getTime() - System.currentTimeMillis()) / 1000L);
            }
            if (this.discard) {
                stringBuffer.append("; Discard");
            }
            if (this.secure) {
                stringBuffer.append("; Secure");
            }
            if (this.comment != null) {
                stringBuffer.append("; Comment=\"").append(this.comment).append('\"');
            }
            if (this.comment_url != null) {
                stringBuffer.append("; CommentURL=\"").append(this.comment_url).append('\"');
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return stringBuffer.toString();
    }
}

