/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpOutputStream;
import HTTPClient.Log;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;

class AuthorizationModule
implements HTTPClientModule {
    private static Hashtable proxy_cntxt_list = new Hashtable();
    private static Hashtable deferred_auth_list = new Hashtable();
    private int auth_lst_idx = 0;
    private int prxy_lst_idx = 0;
    private int auth_scm_idx = 0;
    private int prxy_scm_idx = 0;
    private AuthorizationInfo auth_sent = null;
    private AuthorizationInfo prxy_sent = null;
    private boolean auth_from_4xx = false;
    private boolean prxy_from_4xx = false;
    private int num_tries = 0;
    private Request saved_req = null;
    private Response saved_resp = null;

    AuthorizationModule() {
    }

    public int requestHandler(Request request, Response[] responseArray) throws IOException, AuthSchemeNotImplException {
        int n;
        NVPair[] nVPairArray;
        block20: {
            AuthorizationInfo authorizationInfo;
            block22: {
                AuthorizationHandler authorizationHandler;
                block19: {
                    block21: {
                        Hashtable hashtable;
                        HTTPConnection hTTPConnection = request.getConnection();
                        authorizationHandler = AuthorizationInfo.getAuthHandler();
                        nVPairArray = request.getHeaders();
                        n = -1;
                        HttpOutputStream httpOutputStream = request.getStream();
                        if (httpOutputStream != null && deferred_auth_list.get(httpOutputStream) != null) {
                            this.copyFrom((AuthorizationModule)deferred_auth_list.remove(httpOutputStream));
                            request.copyFrom(this.saved_req);
                            Log.write(8, "AuthM: Handling deferred auth challenge");
                            this.handle_auth_challenge(request, this.saved_resp);
                            if (this.auth_sent != null) {
                                Log.write(8, "AuthM: Sending request with Authorization '" + this.auth_sent + "'");
                            } else {
                                Log.write(8, "AuthM: Sending request with Proxy-Authorization '" + this.prxy_sent + "'");
                            }
                            return 1;
                        }
                        if (hTTPConnection.getProxyHost() == null || this.prxy_from_4xx) break block19;
                        for (int i = 0; i < nVPairArray.length; ++i) {
                            if (!nVPairArray[i].getName().equalsIgnoreCase("Proxy-Authorization")) continue;
                            n = i;
                            break;
                        }
                        if ((authorizationInfo = (AuthorizationInfo)(hashtable = Util.getList(proxy_cntxt_list, hTTPConnection.getContext())).get(hTTPConnection.getProxyHost() + ":" + hTTPConnection.getProxyPort())) == null) break block19;
                        if (authorizationHandler == null) break block21;
                        try {
                            authorizationInfo = authorizationHandler.fixupAuthInfo(authorizationInfo, request, null, null);
                        }
                        catch (AuthSchemeNotImplException authSchemeNotImplException) {
                            break block19;
                        }
                        if (authorizationInfo == null) break block19;
                    }
                    if (n == -1) {
                        n = nVPairArray.length;
                        nVPairArray = Util.resizeArray(nVPairArray, n + 1);
                        request.setHeaders(nVPairArray);
                    }
                    nVPairArray[n] = new NVPair("Proxy-Authorization", authorizationInfo.toString());
                    n = -1;
                    this.prxy_sent = authorizationInfo;
                    this.prxy_from_4xx = false;
                    Log.write(8, "AuthM: Preemptively sending Proxy-Authorization '" + authorizationInfo + "'");
                }
                if (n >= 0) {
                    System.arraycopy(nVPairArray, n + 1, nVPairArray, n, nVPairArray.length - n - 1);
                    nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length - 1);
                    request.setHeaders(nVPairArray);
                }
                n = -1;
                if (this.auth_from_4xx) break block20;
                for (int i = 0; i < nVPairArray.length; ++i) {
                    if (!nVPairArray[i].getName().equalsIgnoreCase("Authorization")) continue;
                    n = i;
                    break;
                }
                if ((authorizationInfo = AuthorizationInfo.findBest(request)) == null) break block20;
                if (authorizationHandler == null) break block22;
                try {
                    authorizationInfo = authorizationHandler.fixupAuthInfo(authorizationInfo, request, null, null);
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    break block20;
                }
                if (authorizationInfo == null) break block20;
            }
            if (n == -1) {
                n = nVPairArray.length;
                nVPairArray = Util.resizeArray(nVPairArray, n + 1);
                request.setHeaders(nVPairArray);
            }
            nVPairArray[n] = new NVPair("Authorization", authorizationInfo.toString());
            n = -1;
            this.auth_sent = authorizationInfo;
            this.auth_from_4xx = false;
            Log.write(8, "AuthM: Preemptively sending Authorization '" + authorizationInfo + "'");
        }
        if (n >= 0) {
            System.arraycopy(nVPairArray, n + 1, nVPairArray, n, nVPairArray.length - n - 1);
            nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length - 1);
            request.setHeaders(nVPairArray);
        }
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) throws IOException {
        if (response.getStatusCode() != 401 && response.getStatusCode() != 407) {
            if (this.auth_sent != null && this.auth_from_4xx) {
                try {
                    AuthorizationInfo.getAuthorization(this.auth_sent, roRequest, response, false).addPath(roRequest.getRequestURI());
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    // empty catch block
                }
            }
            this.num_tries = 0;
        }
        this.auth_from_4xx = false;
        this.prxy_from_4xx = false;
        if (response.getHeader("WWW-Authenticate") == null) {
            this.auth_lst_idx = 0;
            this.auth_scm_idx = 0;
        }
        if (response.getHeader("Proxy-Authenticate") == null) {
            this.prxy_lst_idx = 0;
            this.prxy_scm_idx = 0;
        }
    }

    public int responsePhase2Handler(Response response, Request request) throws IOException, AuthSchemeNotImplException {
        AuthorizationHandler authorizationHandler = AuthorizationInfo.getAuthHandler();
        if (authorizationHandler != null) {
            authorizationHandler.handleAuthHeaders(response, request, this.auth_sent, this.prxy_sent);
        }
        int n = response.getStatusCode();
        switch (n) {
            case 401: 
            case 407: {
                ++this.num_tries;
                if (this.num_tries > 10) {
                    throw new ProtocolException("Bug in authorization handling: server refused the given info 10 times");
                }
                if (request.getStream() != null) {
                    if (!HTTPConnection.deferStreamed) {
                        Log.write(8, "AuthM: status " + n + " not handled - request has " + "an output stream");
                        return 10;
                    }
                    this.saved_req = (Request)request.clone();
                    this.saved_resp = (Response)response.clone();
                    deferred_auth_list.put(request.getStream(), this);
                    request.getStream().reset();
                    response.setRetryRequest(true);
                    Log.write(8, "AuthM: Handling of status " + n + " deferred because an " + "output stream was used");
                    return 10;
                }
                Log.write(8, "AuthM: Handling status: " + n + " " + response.getReasonLine());
                this.handle_auth_challenge(request, response);
                if (this.auth_sent != null || this.prxy_sent != null) {
                    try {
                        response.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.auth_sent != null) {
                        Log.write(8, "AuthM: Resending request with Authorization '" + this.auth_sent + "'");
                    } else {
                        Log.write(8, "AuthM: Resending request with Proxy-Authorization '" + this.prxy_sent + "'");
                    }
                    return 13;
                }
                if (request.getStream() != null) {
                    Log.write(8, "AuthM: status " + n + " not " + "handled - request has an output " + "stream");
                } else {
                    Log.write(8, "AuthM: No Auth Info found - status " + n + " not handled");
                }
                return 10;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) {
    }

    public void trailerHandler(Response response, RoRequest roRequest) throws IOException {
        AuthorizationHandler authorizationHandler = AuthorizationInfo.getAuthHandler();
        if (authorizationHandler != null) {
            authorizationHandler.handleAuthTrailers(response, roRequest, this.auth_sent, this.prxy_sent);
        }
    }

    private void handle_auth_challenge(Request request, Response response) throws AuthSchemeNotImplException, IOException {
        int[] nArray = new int[]{this.auth_lst_idx, this.auth_scm_idx};
        this.auth_sent = this.setAuthHeaders(response.getHeader("WWW-Authenticate"), request, response, "Authorization", nArray, this.auth_sent);
        if (this.auth_sent != null) {
            this.auth_from_4xx = true;
            this.auth_lst_idx = nArray[0];
            this.auth_scm_idx = nArray[1];
        } else {
            this.auth_lst_idx = 0;
            this.auth_scm_idx = 0;
        }
        nArray[0] = this.prxy_lst_idx;
        nArray[1] = this.prxy_scm_idx;
        this.prxy_sent = this.setAuthHeaders(response.getHeader("Proxy-Authenticate"), request, response, "Proxy-Authorization", nArray, this.prxy_sent);
        if (this.prxy_sent != null) {
            this.prxy_from_4xx = true;
            this.prxy_lst_idx = nArray[0];
            this.prxy_scm_idx = nArray[1];
        } else {
            this.prxy_lst_idx = 0;
            this.prxy_scm_idx = 0;
        }
        if (this.prxy_sent != null) {
            HTTPConnection hTTPConnection = request.getConnection();
            Util.getList(proxy_cntxt_list, hTTPConnection.getContext()).put(hTTPConnection.getProxyHost() + ":" + hTTPConnection.getProxyPort(), this.prxy_sent);
        }
        if (this.auth_sent == null && this.prxy_sent == null && response.getHeader("WWW-Authenticate") == null && response.getHeader("Proxy-Authenticate") == null) {
            if (response.getStatusCode() == 401) {
                throw new ProtocolException("Missing WWW-Authenticate header");
            }
            throw new ProtocolException("Missing Proxy-Authenticate header");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationInfo setAuthHeaders(String string, Request request, RoResponse roResponse, String string2, int[] nArray, AuthorizationInfo authorizationInfo) throws ProtocolException, AuthSchemeNotImplException, IOException {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        AuthorizationInfo[] authorizationInfoArray = AuthorizationInfo.parseAuthString(string, request, roResponse);
        if (Log.isEnabled(8)) {
            Log.write(8, "AuthM: parsed " + authorizationInfoArray.length + " challenges:");
            for (n2 = 0; n2 < authorizationInfoArray.length; ++n2) {
                Log.write(8, "AuthM: Challenge " + authorizationInfoArray[n2]);
            }
        }
        if (authorizationInfoArray.length == 0) {
            return null;
        }
        if (authorizationInfo != null && authorizationInfo.getScheme().equalsIgnoreCase("Basic")) {
            for (n2 = 0; n2 < authorizationInfoArray.length; ++n2) {
                if (!authorizationInfo.getRealm().equals(authorizationInfoArray[n2].getRealm()) || !authorizationInfo.getScheme().equalsIgnoreCase(authorizationInfoArray[n2].getScheme())) continue;
                AuthorizationInfo.removeAuthorization(authorizationInfo, request.getConnection().getContext());
            }
        }
        AuthorizationInfo authorizationInfo2 = null;
        AuthorizationHandler authorizationHandler = AuthorizationInfo.getAuthHandler();
        while (authorizationInfo2 == null && nArray[0] != -1 && nArray[0] < authorizationInfoArray.length) {
            authorizationInfo2 = AuthorizationInfo.getAuthorization(authorizationInfoArray[nArray[0]], request, roResponse, false);
            if (authorizationHandler != null && authorizationInfo2 != null) {
                authorizationInfo2 = authorizationHandler.fixupAuthInfo(authorizationInfo2, request, authorizationInfoArray[nArray[0]], roResponse);
            }
            if ((nArray[0] = nArray[0] + 1) != authorizationInfoArray.length) continue;
            nArray[0] = -1;
        }
        if (authorizationInfo2 == null) {
            for (n = 0; n < authorizationInfoArray.length; ++n) {
                if (nArray[1] >= authorizationInfoArray.length) {
                    nArray[1] = 0;
                }
                try {
                    authorizationInfo2 = AuthorizationInfo.queryAuthHandler(authorizationInfoArray[nArray[1]], request, roResponse);
                    break;
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    if (n != authorizationInfoArray.length - 1) continue;
                    throw authSchemeNotImplException;
                }
                finally {
                    nArray[1] = nArray[1] + 1;
                }
            }
        }
        if (authorizationInfo2 == null) {
            return null;
        }
        NVPair[] nVPairArray = request.getHeaders();
        for (n = 0; n < nVPairArray.length && !nVPairArray[n].getName().equalsIgnoreCase(string2); ++n) {
        }
        if (n == nVPairArray.length) {
            nVPairArray = Util.resizeArray(nVPairArray, n + 1);
            request.setHeaders(nVPairArray);
        }
        nVPairArray[n] = new NVPair(string2, authorizationInfo2.toString());
        return authorizationInfo2;
    }

    private void copyFrom(AuthorizationModule authorizationModule) {
        this.auth_lst_idx = authorizationModule.auth_lst_idx;
        this.prxy_lst_idx = authorizationModule.prxy_lst_idx;
        this.auth_scm_idx = authorizationModule.auth_scm_idx;
        this.prxy_scm_idx = authorizationModule.prxy_scm_idx;
        this.auth_sent = authorizationModule.auth_sent;
        this.prxy_sent = authorizationModule.prxy_sent;
        this.auth_from_4xx = authorizationModule.auth_from_4xx;
        this.prxy_from_4xx = authorizationModule.prxy_from_4xx;
        this.num_tries = authorizationModule.num_tries;
        this.saved_req = authorizationModule.saved_req;
        this.saved_resp = authorizationModule.saved_resp;
    }
}

