/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import madkit.kernel.AbstractAgent;
import madkit.kernel.ReferenceableAgent;
import turtlekit.kernel.Patch;
import turtlekit.kernel.TurtleEnvironment;

public class Turtle
extends AbstractAgent
implements ReferenceableAgent {
    public static final String TURTLE_DEFAULT_ROLE = "turtle";
    private static final long serialVersionUID = -560589112217896865L;
    public static final int East = 0;
    public static final int NorthEast = 45;
    public static final int North = 90;
    public static final int NorthWest = 135;
    public static final int West = 180;
    public static final int SouthWest = 225;
    public static final int South = 270;
    public static final int SouthEast = 315;
    private double angle;
    private double x;
    private double y;
    private double angleCos = 1.0;
    private double angleSin = 0.0;
    private int who;
    boolean hidden = false;
    private TurtleEnvironment world;
    private String initMethod;
    private ArrayList<String> rolePlayed;
    Method nextAction = null;
    Color color = Color.red;
    Patch position;

    public Turtle() {
        this.initMethod = "defaultAction";
        this.randomHeading();
    }

    public Turtle(String string) {
        this.initMethod = string;
    }

    final void setNextAction(Method method) {
        if (method == null) {
            this.die();
        } else {
            this.nextAction = method;
        }
    }

    public final String defaultAction() {
        return "defaultAction";
    }

    final void initialisation(int n, int n2, TurtleEnvironment turtleEnvironment, int n3, Patch patch) {
        this.world = turtleEnvironment;
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(this.initMethod, new Class[0]);
            this.setNextAction(method);
        }
        catch (Exception exception) {
            System.err.println("Can't find method: " + this.initMethod + "\n");
            exception.printStackTrace();
        }
        this.who = n3;
        this.position = patch;
        this.x = n;
        this.y = n2;
    }

    public void activate() {
        this.requestRole("Turtlekit", this.getSimulationGroup(), TURTLE_DEFAULT_ROLE, null);
        this.setup();
    }

    public void end() {
    }

    public void setup() {
    }

    public final void die() {
        if (this.position != null) {
            this.world.removeTurtle(this);
            this.position = null;
            this.rolePlayed = null;
        }
    }

    final double normeValue(double d, int n) {
        if (this.world.wrap) {
            return (d %= (double)n) < 0.0 ? (d + (double)n) % (double)n : d;
        }
        if (d >= (double)n) {
            return (double)n - 0.01;
        }
        return d < 0.0 ? 0.0 : d;
    }

    final int normeValue(int n, int n2) {
        if (this.world.wrap) {
            return (n %= n2) < 0 ? n + n2 : n;
        }
        if (n >= n2) {
            return n2 - 1;
        }
        return n < 0 ? 0 : n;
    }

    public String toString() {
        return "turtle " + this.who + " at " + this.xcor() + " " + this.ycor() + " : heading=" + this.angle + ",color=" + this.color;
    }

    public String getSimulationGroup() {
        return this.world.simulationGroup;
    }

    public final void playRole(String string) {
        if (this.rolePlayed == null) {
            this.rolePlayed = new ArrayList();
        }
        this.rolePlayed.add(string);
        this.requestRole("Turtlekit", this.getSimulationGroup(), string, null);
    }

    public final boolean isPlayingRole(String string) {
        return this.rolePlayed != null && this.rolePlayed.contains(string);
    }

    public final void giveUpRole(String string) {
        this.leaveRole(this.getSimulationGroup(), string);
        if (this.rolePlayed != null) {
            this.rolePlayed.remove(string);
        }
    }

    public final double getHeading() {
        return this.angle;
    }

    public final void setHeading(double d) {
        this.angle = d % 360.0;
        if (this.angle < 0.0) {
            this.angle += 360.0;
        }
        this.angleSin = Math.sin(Math.PI * this.angle / 180.0);
        this.angleCos = Math.cos(Math.PI * this.angle / 180.0);
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public final boolean getHidden() {
        return this.hidden;
    }

    public final void setPatchColor(Color color) {
        if (this.position != null) {
            this.position.setColor(color);
        }
    }

    public final Color getPatchColor() {
        return this.position != null ? this.position.color : null;
    }

    public final Color getPatchColorAt(int n, int n2) {
        return this.world.getPatchColor(this.normeValue(n + this.xcor(), this.world.x), this.normeValue(n2 + this.ycor(), this.world.y));
    }

    public final void setPatchColorAt(Color color, int n, int n2) {
        if (this.position != null) {
            this.world.setPatchColor(color, this.normeValue(n + this.xcor(), this.world.x), this.normeValue(n2 + this.ycor(), this.world.y));
        }
    }

    public final void fd(int n) {
        this.moveTo(this.x + this.angleCos * (double)n, this.y + this.angleSin * (double)n);
    }

    public final void bk(int n) {
        this.moveTo(this.x - this.angleCos * (double)n, this.y - this.angleSin * (double)n);
    }

    public final void moveTo(double d, double d2) {
        if (this.position != null) {
            this.x = this.normeValue(d, this.world.x);
            this.y = this.normeValue(d2, this.world.y);
            this.world.moveTurtle(this.xcor(), this.ycor(), this);
        }
    }

    public final void moveTo(int n, int n2) {
        if (this.position != null) {
            n = this.normeValue(n, this.world.x);
            n2 = this.normeValue(n2, this.world.y);
            this.x = n;
            this.y = n2;
            this.world.moveTurtle(n, n2, this);
        }
    }

    public final void home() {
        if (this.position != null) {
            this.x = this.world.x / 2;
            this.y = this.world.y / 2;
            this.world.moveTurtle(this.xcor(), this.ycor(), this);
        }
    }

    public final void setX(double d) {
        if (this.position != null) {
            this.x = this.normeValue(d, this.world.x);
            this.world.moveTurtle(this.xcor(), this.ycor(), this);
        }
    }

    public final void setY(double d) {
        if (this.position != null) {
            this.y = this.normeValue(d, this.world.y);
            this.world.moveTurtle(this.xcor(), this.ycor(), this);
        }
    }

    public final void setXY(double d, double d2) {
        if (this.position != null) {
            this.x = this.normeValue(d, this.world.x);
            this.y = this.normeValue(d2, this.world.y);
            this.world.moveTurtle(this.xcor(), this.ycor(), this);
        }
    }

    public final double distanceNowrap(double d, double d2) {
        d = this.normeValue(d, this.world.x);
        d2 = this.normeValue(d2, this.world.y);
        return Math.sqrt((d -= this.x) * d + (d2 -= this.y) * d2);
    }

    public final double distance(double d, double d2) {
        if (!this.world.wrap) {
            return this.distanceNowrap(d, d2);
        }
        d = this.normeValue(d, this.world.x);
        d2 = this.normeValue(d2, this.world.y);
        if (Math.abs(d - this.x) > (double)(this.world.x / 2)) {
            d = d < this.x ? (d += (double)this.world.x) : (d -= (double)this.world.x);
        }
        if (Math.abs(d2 - this.y) > (double)(this.world.y / 2)) {
            d2 = d2 < this.y ? (d2 += (double)this.world.y) : (d2 -= (double)this.world.y);
        }
        return Math.sqrt((d -= this.x) * d + (d2 -= this.y) * d2);
    }

    public final double towardsNowrap(double d, double d2) {
        d = this.normeValue(d, this.world.x);
        d2 = this.normeValue(d2, this.world.y);
        if ((d -= this.x) == 0.0 && (d2 -= this.y) == 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return 180.0 * Math.asin(d / Math.sqrt(d * d + d2 * d2)) / Math.PI + 270.0;
        }
        return 180.0 * Math.acos(d / Math.sqrt(d * d + d2 * d2)) / Math.PI;
    }

    public final double towards(double d, double d2) {
        if (!this.world.wrap) {
            return this.towardsNowrap(d, d2);
        }
        if (this.distance(d, d2) > this.distanceNowrap(d, d2)) {
            return this.towardsNowrap(d, d2);
        }
        d = this.normeValue(d, this.world.x);
        d2 = this.normeValue(d2, this.world.y);
        if (Math.abs(d - this.x) > (double)(this.world.x / 2)) {
            d = d < this.x ? (d += (double)this.world.x) : (d -= (double)this.world.x);
        }
        if (Math.abs(d2 - this.y) > (double)(this.world.y / 2)) {
            d2 = d2 < this.y ? (d2 += (double)this.world.y) : (d2 -= (double)this.world.y);
        }
        if ((d -= this.x) == 0.0 && (d2 -= this.y) == 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return 180.0 * Math.asin(d / Math.sqrt(d * d + d2 * d2)) / Math.PI + 270.0;
        }
        return 180.0 * Math.acos(d / Math.sqrt(d * d + d2 * d2)) / Math.PI;
    }

    public final void randomHeading() {
        this.setHeading(Math.random() * 360.0);
    }

    public final int createTurtle(Turtle turtle) {
        return this.position != null ? this.world.addAgent(turtle, this.xcor(), this.ycor()) : -1;
    }

    public final int xcor() {
        return (int)this.x;
    }

    public final int ycor() {
        return (int)this.y;
    }

    public final double realX() {
        return this.x;
    }

    public final double realY() {
        return this.y;
    }

    public final Turtle getTurtleWithID(int n) {
        return this.world.getTurtleWithID(n);
    }

    public final int dx() {
        return (int)(this.x + this.angleCos) - (int)this.x;
    }

    public final int dy() {
        return (int)(this.y + this.angleSin) - (int)this.y;
    }

    public final void turnRight(double d) {
        this.angle -= d;
        this.setHeading(this.angle);
    }

    public final void turnLeft(double d) {
        this.angle += d;
        this.setHeading(this.angle);
    }

    public final Turtle[] turtlesHere() {
        return this.position != null ? this.position.getOtherTurtles(this) : null;
    }

    public final Turtle[] turtlesAt(int n, int n2) {
        return this.position != null ? this.world.turtlesAt(this.normeValue(n + this.xcor(), this.world.x), this.normeValue(n2 + this.ycor(), this.world.y)) : new Turtle[]{};
    }

    public final int countTurtlesHere() {
        return this.position != null ? Integer.valueOf(this.position.turtlesHere.size()) : null;
    }

    public final int countTurtlesAt(int n, int n2) {
        return this.world.turtlesCountAt(this.normeValue(n + this.xcor(), this.world.x), this.normeValue(n2 + this.ycor(), this.world.y));
    }

    public final int mySelf() {
        return this.who;
    }

    public final int getWorldWidth() {
        return this.world.x;
    }

    public final int getWorldHeight() {
        return this.world.y;
    }

    public final double getPatchVariable(String string) {
        return this.position != null ? this.position.getVariableValue(string) : 0.0;
    }

    public final double getPatchVariableAt(String string, int n, int n2) {
        return this.world.grid[this.normeValue(n + this.xcor(), this.world.x)][this.normeValue(n2 + this.ycor(), this.world.y)].getVariableValue(string);
    }

    public final void incrementPatchVariable(String string, double d) {
        if (this.position != null) {
            this.position.incrementPatchVariable(string, d);
        }
    }

    public final void incrementPatchVariableAt(String string, double d, int n, int n2) {
        if (this.position != null) {
            this.world.grid[this.normeValue(n + this.xcor(), this.world.x)][this.normeValue(n2 + this.ycor(), this.world.y)].incrementPatchVariable(string, d);
        }
    }

    public final Object getMark(String string) {
        return this.position != null ? this.position.getMark(string) : null;
    }

    public final Object getMarkAt(String string, int n, int n2) {
        return this.position != null ? this.world.grid[this.normeValue(n + this.xcor(), this.world.x)][this.normeValue(n2 + this.ycor(), this.world.y)].getMark(string) : null;
    }

    public final void dropMark(String string, Object object) {
        if (this.position != null) {
            this.position.dropMark(string, object);
        }
    }

    public final void dropMarkAt(String string, Object object, int n, int n2) {
        if (this.position != null) {
            this.world.grid[this.normeValue(n + this.xcor(), this.world.x)][this.normeValue(n2 + this.ycor(), this.world.y)].dropMark(string, object);
        }
    }

    public final boolean isMarkPresent(String string) {
        return this.position != null ? Boolean.valueOf(this.position.isMarkPresent(string)) : null;
    }

    public final boolean isMarkPresentAt(String string, int n, int n2) {
        return this.world.grid[this.normeValue(n + this.xcor(), this.world.x)][this.normeValue(n2 + this.ycor(), this.world.y)].isMarkPresent(string);
    }
}

