/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;
import madkit.kernel.SynchroScheduler;
import madkit.kernel.Utils;
import madkit.simulation.activators.TurboMethodActivator;
import madkit.utils.agents.AbstractEditorPanel;
import org.python.core.PyException;
import org.python.util.PythonInterpreter;
import turtlekit.kernel.CommandEditorPanel;
import turtlekit.kernel.Turtle;
import turtlekit.kernel.TurtleEnvironment;

public class PythonCommandCenter
extends SynchroScheduler
implements ActionListener {
    private static final long serialVersionUID = -7115432581375542638L;
    public AbstractEditorPanel display;
    protected PythonInterpreter interp;
    TurboMethodActivator viewersDoIt;
    TurboMethodActivator updateDisplay;
    Activator<Turtle> turtles;
    String simulationGroup;
    final Map<String, ProcedureThread> turtleThreads = new HashMap<String, ProcedureThread>();
    final Map<String, JFrame> frames = new HashMap<String, JFrame>();

    public PythonCommandCenter(String string) {
        try {
            Class clazz = Utils.loadClass((String)"org.python.util.PythonInterpreter");
            this.interp = (PythonInterpreter)clazz.newInstance();
            this.simulationGroup = string;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PythonInterpreter getInterpret() {
        return this.interp;
    }

    public void println(String string) {
        this.display.stdout().println(string);
    }

    public void initGUI() {
        this.display = new CommandEditorPanel((AbstractAgent)this, this.getInterpret());
        this.setGUIObject(this.display);
    }

    public void activate() {
        try {
            this.interp.exec("import sys");
            this.interp.set("self", (Object)this);
            this.interp.exec("def askTurtles(s):self.turtleMethod(s)");
            this.interp.exec("def crt(x):self.createTurtle(x)");
            this.interp.exec("def clearPatch():self.clearPatch()");
            this.interp.exec("def makeProcedure(p):self.makeProcedure(p)");
        }
        catch (PyException pyException) {
            this.println("Python error while activating");
        }
        this.println("Select a pyturtle script or type some turtle commands using python interpreter like this");
        this.println("for i in range (0,20):");
        this.println("\taskTurtles(\"fd(1)\")");
        this.viewersDoIt = new TurboMethodActivator("display", "Turtlekit", this.simulationGroup, "viewer");
        this.addActivator((Activator)this.viewersDoIt);
        this.updateDisplay = new TurboMethodActivator("displayOff", "Turtlekit", this.simulationGroup, "world");
        this.addActivator((Activator)this.updateDisplay);
        this.turtles = new Activator("Turtlekit", this.simulationGroup, "turtle");
        this.addActivator(this.turtles);
        this.interp.set("allTurtles", (Object)this.turtles.getCurrentAgentsList());
        this.interp.exec("def clearT():\n\tfor i in allTurtles:\n\t\ti.die()");
        this.interp.exec("def clearAll():clearPatch(),clearT()");
        this.interp.exec("def addTurtle(t):self.addTurtle(t)");
        this.interp.exec("def killTurtle(x):\n\tfor i in allTurtles:\n\t\tif i.mySelf()==x:\n\t\t\ti.die()");
    }

    public void evaluation(String string, String string2) {
        this.interp.set("allTurtles", (Object)this.turtles.getCurrentAgentsList());
        this.println("<< ControlMessage: " + string);
        try {
            if (string.equals("dir")) {
                this.interp.exec("print dir()");
            } else if (string.equals("eval")) {
                this.interp.exec(string2);
                this.println("OK");
            }
        }
        catch (PyException pyException) {
            this.println("Python error doing " + string);
            pyException.printStackTrace(System.err);
        }
    }

    public final void turtleMethod(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        string2 = string2 + " i." + stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + ", i." + stringTokenizer.nextToken();
        }
        try {
            this.interp.exec("for i in allTurtles:\n\ttry:\n\t\t" + string2 + "\n\texcept:\n\t\tprint i.toString() + \"can't do " + string2 + "\"");
        }
        catch (Exception exception) {
            System.err.println("python error " + exception);
        }
        this.viewersDoIt.execute();
        this.updateDisplay.execute();
    }

    public void createTurtle(int n) {
        TurtleEnvironment turtleEnvironment = (TurtleEnvironment)this.updateDisplay.getAgentNb(0);
        for (int i = 0; i < n; ++i) {
            Turtle turtle = new Turtle();
            turtleEnvironment.addAgent(turtle);
            turtle.home();
            turtle.randomHeading();
            turtle.setColor(new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0)));
        }
        this.viewersDoIt.execute();
        this.interp.set("allTurtles", (Object)this.turtles.getCurrentAgentsList());
    }

    public void addTurtle(Turtle turtle) {
        TurtleEnvironment turtleEnvironment = (TurtleEnvironment)this.updateDisplay.getAgentNb(0);
        turtleEnvironment.addAgent(turtle);
        turtle.setColor(new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0)));
        turtle.home();
        turtle.randomHeading();
        this.viewersDoIt.execute();
        this.interp.set("allTurtles", (Object)this.turtles.getCurrentAgentsList());
    }

    public void clearT() {
        for (Turtle turtle : this.turtles.getCurrentAgentsList()) {
            turtle.die();
        }
    }

    public void clearPatch() {
        TurtleEnvironment turtleEnvironment = (TurtleEnvironment)this.updateDisplay.getAgentNb(0);
        Turtle turtle = new Turtle();
        turtleEnvironment.addAgent(turtle, 0, 0);
        for (int i = 0; i < turtleEnvironment.x; ++i) {
            turtle.setX(i);
            for (int j = 0; j < turtleEnvironment.y; ++j) {
                turtle.setY(j);
                turtle.setPatchColor(Color.black);
            }
        }
        turtle.die();
    }

    public void makeProcedure(String string) {
        if (!this.frames.containsKey(string)) {
            final String string2 = string;
            JFrame jFrame = new JFrame(string + " procedure");
            this.frames.put(string, jFrame);
            jFrame.setLocation((int)(Math.random() * 500.0), (int)(Math.random() * 500.0));
            final JButton jButton = new JButton(string);
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PythonCommandCenter.this.frames.remove(string2);
                    ProcedureThread procedureThread = PythonCommandCenter.this.turtleThreads.remove(string2);
                    if (procedureThread != null) {
                        procedureThread.alive = false;
                    }
                }
            });
            jFrame.setSize(300, 100);
            jFrame.getContentPane().add(jButton);
            jFrame.getContentPane().setLayout(new GridLayout(2, 1));
            jButton.addActionListener(this);
            JCheckBox jCheckBox = new JCheckBox("Forever");
            jCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        jButton.setText(jButton.getText() + " forever");
                    } else {
                        StringTokenizer stringTokenizer = new StringTokenizer(jButton.getText());
                        jButton.setText(stringTokenizer.nextToken());
                    }
                }
            });
            jFrame.getContentPane().add(jCheckBox);
            jFrame.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(actionEvent.getActionCommand());
        JButton jButton = (JButton)actionEvent.getSource();
        String string = stringTokenizer.nextToken();
        if (this.turtleThreads.containsKey(string)) {
            ProcedureThread procedureThread = this.turtleThreads.remove(string);
            procedureThread.alive = false;
            jButton.setBackground(Color.lightGray);
        } else if (stringTokenizer.hasMoreTokens()) {
            if (!this.turtleThreads.containsKey(string)) {
                ProcedureThread procedureThread = new ProcedureThread(string, this);
                this.turtleThreads.put(string, procedureThread);
                procedureThread.start();
                jButton.setBackground(Color.green);
            } else {
                ProcedureThread procedureThread = this.turtleThreads.remove(string);
                procedureThread.alive = false;
                jButton.setBackground(Color.lightGray);
            }
        } else {
            ProcedureThread procedureThread = new ProcedureThread(string, this);
            procedureThread.start();
            procedureThread.alive = false;
        }
    }

    public void executeProcedure(String string) {
        this.interp.set("allTurtles", (Object)this.turtles.getCurrentAgentsList());
        this.interp.exec(string + "()");
    }

    public void end() {
        Iterator<Object> iterator = this.frames.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
        iterator = this.turtleThreads.values().iterator();
        while (iterator.hasNext()) {
            ((ProcedureThread)iterator.next()).alive = false;
        }
        super.end();
    }

    class ProcedureThread
    extends Thread {
        String procedure;
        boolean alive = true;
        PythonCommandCenter interp;

        public ProcedureThread(String string, PythonCommandCenter pythonCommandCenter2) {
            this.procedure = string;
            this.interp = pythonCommandCenter2;
        }

        public void run() {
            this.interp.executeProcedure(this.procedure);
            while (this.alive) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.interp.executeProcedure(this.procedure);
            }
        }
    }
}

