/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import turtlekit.kernel.Turtle;
import turtlekit.kernel.TurtleEnvironment;

public final class Patch {
    final TurtleEnvironment world;
    double diffusion;
    double[] variableValue;
    Hashtable<String, Object> marks = null;
    transient Patch[] neighbors;
    Collection<Turtle> turtlesHere = new HashSet<Turtle>();
    Color color;
    boolean change = true;

    public Patch(TurtleEnvironment turtleEnvironment) {
        this.world = turtleEnvironment;
        this.color = Color.black;
    }

    final void setNeighborhood(Patch[] patchArray) {
        this.neighbors = patchArray;
    }

    final void update(int n) {
        for (int i = this.neighbors.length - 1; i >= 0; --i) {
            int n2 = n;
            this.variableValue[n2] = this.variableValue[n2] + this.neighbors[i].diffusion;
        }
    }

    final void removeAgent(Turtle turtle) {
        this.change = true;
        this.turtlesHere.remove((Object)turtle);
    }

    final void addAgent(Turtle turtle) {
        this.turtlesHere.add(turtle);
        turtle.position = this;
    }

    final int getVariableIndex(String string) {
        return this.world.variables.get(string);
    }

    public final void setPatchVariable(String string, double d) {
        this.change = true;
        this.variableValue[this.getVariableIndex((String)string)] = d;
    }

    public final void incrementPatchVariable(String string, double d) {
        this.change = true;
        int n = this.getVariableIndex(string);
        this.variableValue[n] = this.variableValue[n] + d;
    }

    public final double getVariableValue(String string) {
        return this.variableValue[this.getVariableIndex(string)];
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
        this.color = color;
        this.change = true;
    }

    final synchronized Turtle[] getOtherTurtles(Turtle turtle) {
        HashSet<Turtle> hashSet = new HashSet<Turtle>(this.turtlesHere);
        hashSet.remove((Object)turtle);
        return hashSet.toArray(new Turtle[hashSet.size()]);
    }

    final synchronized int size() {
        return this.turtlesHere.size();
    }

    public final void dropMark(String string, Object object) {
        this.change = true;
        if (this.marks == null) {
            this.marks = new Hashtable(1);
        }
        this.marks.put(string, object);
    }

    public final Object getMark(String string) {
        Object object = null;
        try {
            object = this.marks.remove(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        if (object != null) {
            this.change = true;
        }
        return object;
    }

    public final boolean isMarkPresent(String string) {
        if (this.marks != null) {
            return this.marks.containsKey(string);
        }
        return false;
    }

    public final Turtle[] getTurtles() {
        return this.turtlesHere.toArray(new Turtle[this.turtlesHere.size()]);
    }

    public final Patch[] getNeighbors() {
        return this.neighbors;
    }

    public final String toString() {
        String string = "";
        for (String string2 : this.world.variables.keySet()) {
            double d = this.getVariableValue(string2);
            string = string + "" + string2 + "=" + d + ",";
        }
        return string + "; ";
    }
}

