/*
 * Decompiled with CFR 0.152.
 */
package turtlekit.kernel;

import java.util.Enumeration;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import turtlekit.kernel.LauncherGui;
import turtlekit.kernel.Observer;
import turtlekit.kernel.PatchVariable;
import turtlekit.kernel.PythonCommandCenter;
import turtlekit.kernel.TopMessage;
import turtlekit.kernel.Turtle;
import turtlekit.kernel.TurtleEnvironment;
import turtlekit.kernel.TurtleScheduler;
import turtlekit.kernel.Viewer;

public abstract class Launcher
extends Agent {
    LauncherGui onScreen;
    Vector<PatchVariable> flavors = null;
    Vector<AbstractAgent> launchedAgents = new Vector();
    TurtleEnvironment playGround = null;
    TurtleScheduler sch = null;
    Class<? extends Viewer> preferedViewer;
    public static final String COMMUNITY = "Turtlekit";
    boolean run = false;
    boolean start = false;
    boolean wrap = true;
    boolean diffusion = false;
    boolean pythonOn = false;
    String simulationName = "? NAME ?";
    private int cellSize = 3;
    private int cyclePause = 0;
    private int cycleDisplayEvery = 1000;
    private int envWidth = 100;
    private int envHeight = 100;

    public final void setWidth(int n) {
        this.envWidth = n;
    }

    public final int getWidth() {
        return this.envWidth;
    }

    public final void setCellSize(int n) {
        this.cellSize = n;
    }

    public final int getCellSize() {
        return this.cellSize;
    }

    public final void setHeight(int n) {
        this.envHeight = n;
    }

    public final int getHeight() {
        return this.envHeight;
    }

    public final String getSimulationName() {
        return this.simulationName;
    }

    public final void setSimulationName(String string) {
        this.simulationName = string;
    }

    public final void setCyclePause(int n) {
        this.cyclePause = n;
        if (this.sch != null) {
            this.sch.delay = this.cyclePause;
        }
    }

    final void setReset() {
        this.start = false;
        this.println("Reseting: Please wait ...");
        this.destroyGroup(COMMUNITY, this.simulationName);
        this.killAgent((AbstractAgent)this.sch);
        this.sch = null;
        this.pause(100);
        for (AbstractAgent abstractAgent : this.launchedAgents) {
            this.killAgent(abstractAgent);
        }
        if (this.run) {
            this.run = false;
        }
        this.playGround.finalReset();
        this.killAgent(this.playGround);
        this.flavors = null;
        this.launchedAgents.removeAllElements();
        this.pause(200);
        this.createGroup(false, COMMUNITY, this.simulationName, null, null);
        this.launchSimulation();
        this.start = true;
        this.run = true;
    }

    public final void setWrapModeOn(boolean bl) {
        if (this.playGround != null && this.start && this.run) {
            this.start = false;
            this.run = false;
            this.sendMessage(this.sch.getAddress(), new TopMessage());
            this.waitNextMessage();
            this.playGround.wrap = bl;
            this.wrap = bl;
            if (this.diffusion) {
                this.playGround.initNeighborhood();
            }
            this.sendMessage(this.sch.getAddress(), new TopMessage());
            this.run = true;
            this.start = true;
            return;
        }
        if (this.playGround != null && this.start) {
            this.start = false;
            this.playGround.wrap = bl;
            this.wrap = bl;
            if (this.diffusion) {
                this.playGround.initNeighborhood();
            }
            this.start = true;
            return;
        }
        this.wrap = bl;
    }

    void setStop() {
        if (this.run) {
            this.run = false;
            this.sendMessage(this.sch.getAddress(), new TopMessage());
            this.waitNextMessage();
            this.println("Simulation paused");
        } else {
            this.sendMessage(this.sch.getAddress(), new TopMessage());
            this.println("Simulation running");
            this.run = true;
        }
    }

    final void stepByStep() {
        this.sendMessage(this.sch.getAddress(), new TopMessage());
        this.sendMessage(this.sch.getAddress(), new TopMessage());
    }

    final void initializeVariables() {
        PatchVariable patchVariable;
        Enumeration<PatchVariable> enumeration;
        Object object;
        System.err.println(this.flavors.toString());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String[] stringArray = new String[this.flavors.size()];
        double[] dArray = new double[this.flavors.size()];
        String[] stringArray2 = this.flavors.elements();
        while (stringArray2.hasMoreElements()) {
            object = stringArray2.nextElement();
            System.err.println(((PatchVariable)object).toString());
            if (((PatchVariable)object).diffCoef != 0.0) {
                ++n;
            }
            if (((PatchVariable)object).evaporation != 0.0) {
                ++n2;
            }
            stringArray[n3] = ((PatchVariable)object).n;
            dArray[n3] = ((PatchVariable)object).defaultV;
            ++n3;
            this.diffusion = true;
            this.playGround.initNeighborhood();
        }
        if (n > 0) {
            this.playGround.initNeighborhood();
            this.diffusion = true;
        }
        this.playGround.addVariables(stringArray, dArray);
        if (n > 0) {
            stringArray2 = new String[n];
            object = new double[n];
            n = 0;
            enumeration = this.flavors.elements();
            while (enumeration.hasMoreElements()) {
                patchVariable = enumeration.nextElement();
                if (patchVariable.diffCoef == 0.0) continue;
                stringArray2[n] = patchVariable.n;
                object[n] = patchVariable.diffCoef;
                ++n;
            }
            this.playGround.diffuseVariables(stringArray2, (double[])object);
        }
        if (n2 > 0) {
            stringArray2 = new String[n2];
            object = new double[n2];
            n2 = 0;
            enumeration = this.flavors.elements();
            while (enumeration.hasMoreElements()) {
                patchVariable = enumeration.nextElement();
                if (patchVariable.evaporation == 0.0) continue;
                stringArray2[n2] = patchVariable.n;
                object[n2] = patchVariable.evaporation;
                ++n2;
            }
            this.playGround.evapVariables(stringArray2, (double[])object);
        }
    }

    private final void launchSimulation() {
        this.println("Launching simulation !");
        System.err.println("Launching simulation !");
        this.println("Please wait...");
        if (this.sch == null) {
            this.sch = new TurtleScheduler(this.simulationName);
        }
        this.sch.delay = this.cyclePause;
        this.launchAgent((AbstractAgent)this.sch, this.simulationName + " scheduler", false);
        this.initializePatchVariables();
        this.createLogoWorld();
        this.addSimulationAgents();
        this.waitNextMessage(600L);
        this.sendMessage(this.sch.getAddress(), new TopMessage());
    }

    private final void createLogoWorld() {
        this.playGround = new TurtleEnvironment(this.envWidth, this.envHeight, this.simulationName);
        this.playGround.wrap = this.wrap;
        this.launchAgent(this.playGround, this.simulationName + " world", false);
        this.pause(100);
        if (this.flavors != null) {
            this.initializeVariables();
        }
    }

    private final void initViewer(Viewer viewer, int n, String string) {
        System.err.println("initializing viewers");
        this.preferedViewer = ((Object)((Object)viewer)).getClass();
        viewer.cellSize = n;
        this.addObserver(viewer, true, string);
    }

    protected final void addTurtle(Turtle turtle) {
        this.playGround.addAgent(turtle);
    }

    protected final void addTurtle(Turtle turtle, int n, int n2) {
        this.playGround.addAgent(turtle, n, n2);
    }

    public final void addObserver(Observer observer, boolean bl, String string) {
        observer.simulationGroup = this.simulationName;
        observer.envWidth = this.envWidth;
        observer.envHeight = this.envHeight;
        this.launchAgent((AbstractAgent)observer, string, bl);
        this.launchedAgents.addElement((AbstractAgent)observer);
    }

    public final void addObserver(Observer observer, boolean bl) {
        this.addObserver(observer, bl, this.simulationName + " Observer");
    }

    public final void addViewer() {
        this.addViewer(this.cellSize);
    }

    public final void addViewer(int n) {
        try {
            this.addViewer(this.preferedViewer.newInstance(), n);
        }
        catch (Exception exception) {
            this.addViewer(new Viewer(), n);
        }
    }

    public final void addViewer(Viewer viewer, int n, String string) {
        this.initViewer(viewer, n, string);
    }

    public final void addViewer(Viewer viewer, int n) {
        this.initViewer(viewer, n, this.simulationName + " Observer");
    }

    public final void addViewer(Viewer viewer, String string) {
        this.initViewer(viewer, this.cellSize, string);
    }

    public final void addViewer(Viewer viewer) {
        this.addViewer(viewer, this.cellSize);
    }

    protected final void addMyScheduler(TurtleScheduler turtleScheduler) {
        this.sch = turtleScheduler;
        this.sch.group = this.simulationName;
    }

    protected final void addPatchVariable(PatchVariable patchVariable) {
        if (this.flavors == null) {
            this.flavors = new Vector();
        }
        this.flavors.addElement(patchVariable);
    }

    protected void initializePatchVariables() {
    }

    public abstract void addSimulationAgents();

    public final void initGUI() {
        this.onScreen = new LauncherGui(this);
        this.setGUIObject(this.onScreen);
    }

    public void activate() {
        this.onScreen.initialisation();
        int n = 2;
        if (this.isGroup(this.simulationName)) {
            while (this.isGroup(this.simulationName + " " + n)) {
                ++n;
            }
            this.simulationName = this.simulationName + " " + n;
        }
        this.createGroup(false, COMMUNITY, this.simulationName, null, null);
        this.requestRole(COMMUNITY, this.simulationName, "launcher", null);
        this.onScreen.setName(this.simulationName);
        this.println("Launcher activated !!");
        this.println("Waiting for start instruction...");
        do {
            this.pause(50);
        } while (!this.start);
        this.start = true;
        this.run = true;
        this.launchSimulation();
    }

    public final void live() {
        int n = -1;
        while (true) {
            this.exitImmediatlyOnKill();
            this.pause(this.cycleDisplayEvery);
            if (!this.start || n == this.sch.iteration) continue;
            n = this.sch.iteration;
            this.println("step " + n);
        }
    }

    public final void end() {
        this.println("Closing simulation");
        this.println("Please wait...");
        while (!this.start && this.sch != null) {
            this.pause(100);
        }
        if (this.sch != null) {
            if (this.run) {
                this.sendMessage(this.sch.getAddress(), new TopMessage());
            }
            this.killAgent((AbstractAgent)this.sch);
        }
        if (this.playGround != null) {
            this.playGround.finalReset();
        }
        if (this.playGround != null) {
            this.killAgent(this.playGround);
        }
        for (AbstractAgent abstractAgent : this.launchedAgents) {
            this.killAgent(abstractAgent);
        }
        this.leaveGroup(COMMUNITY, this.simulationName);
    }

    public void launchPython() throws Exception {
        this.start = true;
        PythonCommandCenter pythonCommandCenter = new PythonCommandCenter(this.simulationName);
        this.launchAgent((AbstractAgent)pythonCommandCenter, "Python command center", true);
        this.launchedAgents.add((AbstractAgent)pythonCommandCenter);
        this.stopOrResumeSimulation();
    }

    public void stopOrResumeSimulation() {
        this.onScreen.b1.doClick();
    }
}

