/*
 * Decompiled with CFR 0.152.
 */
package madkit.utils.graphics;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import madkit.kernel.AbstractMadkitBooter;
import madkit.utils.common.OperatingSystem;

public class GraphicUtils {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "konqueror";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void log(String string) {
    }

    public static void debug(Object object) {
    }

    public static void debug(Object object, Object object2) {
    }

    public static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static Frame getRealFrameParent(Component component) {
        while (!(component instanceof Frame) && !(component instanceof JFrame)) {
            if (component == null) {
                return null;
            }
            component = component.getParent();
        }
        return (Frame)component;
    }

    public static Container getFrameParent(Container container) {
        Container container2 = container;
        while (!(container2 instanceof JFrame || container2 instanceof Frame || container2 instanceof JInternalFrame)) {
            if (container2 == null) {
                return null;
            }
            container2 = container2.getParent();
        }
        return container2;
    }

    public static void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n) {
        GraphicUtils.addMenuItem(actionListener, jMenu, string, string2, n, -1);
    }

    public static void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n, int n2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        GraphicUtils.setKeystroke(jMenuItem, n2);
    }

    public static JButton addTool(ActionListener actionListener, JToolBar jToolBar, String string, String string2, String string3) {
        JButton jButton;
        if (string3.equals("")) {
            jButton = (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        } else {
            URL uRL = AbstractMadkitBooter.getBooter().getClass().getResource(string3);
            jButton = uRL != null ? (JButton)jToolBar.add(new JButton(new ImageIcon(uRL))) : (JButton)jToolBar.add(new JButton(string2));
            jButton.setActionCommand(string);
        }
        jButton.setToolTipText(string2);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    static void setKeystroke(JMenuItem jMenuItem, int n) {
        if (n > 0) {
            if (n != 127) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 2, false));
            } else {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 0, false));
            }
        }
    }

    public static void addRadioButtonMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setActionCommand(string2);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setSelected(bl);
        buttonGroup.add(jRadioButtonMenuItem);
    }

    public static void requestFocus(final Window window, final Component component) {
        window.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                component.requestFocus();
                window.removeWindowListener(this);
            }
        });
    }

    public static boolean isPopupTrigger(MouseEvent mouseEvent) {
        if (OperatingSystem.isMacOS()) {
            return mouseEvent.isControlDown() || (mouseEvent.getModifiers() & 4) != 0;
        }
        return (mouseEvent.getModifiers() & 4) != 0;
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        GraphicUtils.showPopupMenu(jPopupMenu, component, n, n2, true);
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2, boolean bl) {
        Component component2;
        int n3 = 0;
        int n4 = 0;
        int n5 = bl ? 1 : 0;
        for (component2 = component; !(component2 instanceof Window) && component2 != null; component2 = component2.getParent()) {
            n3 += component2.getX();
            n4 += component2.getY();
        }
        if (component2 != null) {
            Dimension dimension = jPopupMenu.getPreferredSize();
            Rectangle rectangle = component2.getGraphicsConfiguration().getBounds();
            n = n + n3 + dimension.width + component2.getX() > rectangle.width && n + n3 + component2.getX() >= dimension.width ? (bl ? (n -= dimension.width + n5) : component2.getWidth() - dimension.width - n3 + n5) : (n += n5);
            if (n2 + n4 + dimension.height > component2.getHeight() && n2 + n4 >= dimension.height) {
                if (bl) {
                    n2 = component2.getHeight() - dimension.height - n4 + n5;
                }
            } else {
                n2 += n5;
            }
            jPopupMenu.show(component, n, n2);
        } else {
            jPopupMenu.show(component, n + n5, n2 + n5);
        }
    }

    public static void execute(String string) {
        block6: {
            boolean bl = GraphicUtils.isWindowsPlatform();
            String string2 = null;
            try {
                if (bl) {
                    string2 = "rundll32 url.dll,FileProtocolHandler " + string;
                    Process process = Runtime.getRuntime().exec(string2);
                    break block6;
                }
                string2 = "konqueror -remote openURL(" + string + ")";
                Process process = Runtime.getRuntime().exec(string2);
                try {
                    int n = process.waitFor();
                    if (n != 0) {
                        string2 = "konqueror " + string;
                        process = Runtime.getRuntime().exec(string2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Error bringing up application, cmd='" + string2 + "'");
                    System.err.println("Caught: " + interruptedException);
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not invoke application, command=" + string2);
                System.err.println("Caught: " + iOException);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(WIN_ID);
    }
}

