/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.ActiveStructure;
import SEdit.ArrowDesc;
import SEdit.Command;
import SEdit.ComponentDesc;
import SEdit.ConnectorPlacement;
import SEdit.DefaultStructureBean;
import SEdit.Formalism;
import SEdit.NewArrowCommand;
import SEdit.NewNodeCommand;
import SEdit.NodeDesc;
import SEdit.ReflectorUtil;
import SEdit.SArrow;
import SEdit.SComponent;
import SEdit.SConnect;
import SEdit.SEditAgent;
import SEdit.SEditMessage;
import SEdit.SElement;
import SEdit.SInConnect;
import SEdit.SNode;
import SEdit.SOutConnect;
import SEdit.Structure;
import SEdit.StructureBean;
import SEdit.StructureEditor;
import SEdit.Utils;
import SEdit.XMLStructureLoader;
import SEdit.XMLStructureSaver;
import gnu.lists.LList;
import java.awt.Point;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.Document;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;

public class StructureAgent
extends Agent {
    public static String VERSION = SEditAgent.VERSION;
    public static String DATE = SEditAgent.VERSION;
    public StructureBean gui;
    public Object clipboard;
    protected Formalism formalism;
    protected Structure structure;
    protected String fileName = null;
    int pastenumber = 0;
    static final int decalage = 20;
    boolean showElementPanel = true;
    protected AgentAddress recipient = null;

    public String getFileName() {
        return this.fileName;
    }

    public boolean getShowElementPanel() {
        return this.showElementPanel;
    }

    public void setShowElementPanel(boolean bl) {
        this.showElementPanel = bl;
    }

    public AgentAddress getRecipient() {
        return this.recipient;
    }

    public void setRecipient(AgentAddress agentAddress) {
        this.recipient = agentAddress;
    }

    public void initStructure() {
        try {
            Class clazz = madkit.kernel.Utils.loadClass((String)this.formalism.getStructureClass());
            this.structure = (Structure)clazz.newInstance();
            this.structure.setAgent(this);
            this.structure.setFormalism(this.formalism);
            try {
                ReflectorUtil.setProperties(this.structure, this.formalism.getProperties());
            }
            catch (Exception exception) {
                Utils.log("setProperties failed:" + exception);
            }
            this.structure.initStructure();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Structure Frame - not found the structure with name :" + this.getFormalism().getStructureClass());
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Structure Frame - instanciation failed!");
            System.out.println(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Structure Frame - access problems!");
            System.out.println(illegalAccessException.getMessage());
        }
    }

    public void initEditor() {
        StructureEditor structureEditor = this.getStructure().getEditor();
        if (structureEditor != null) {
            try {
                ReflectorUtil.setProperties(structureEditor, this.formalism.getGraphicProperties());
            }
            catch (Exception exception) {
                Utils.log("setGraphicProperties failed:" + exception);
            }
        }
    }

    public Structure getStructure() {
        return this.structure;
    }

    public Formalism getFormalism() {
        return this.formalism;
    }

    public Formalism getFormalism(String string) {
        if (string.equals(this.formalism.getName())) {
            return this.formalism;
        }
        return null;
    }

    public boolean isFormalismCompatible(String string) {
        return this.formalism.getName().equals(string);
    }

    public StructureAgent(Formalism formalism) {
        this.formalism = formalism;
        this.initStructure();
        this.gui = new DefaultStructureBean(this);
        this.initEditor();
    }

    public StructureAgent(Formalism formalism, String string) {
        this.formalism = formalism;
        this.initStructure();
        this.fileName = string;
        this.gui = new DefaultStructureBean(this);
        this.initEditor();
    }

    public StructureAgent() {
    }

    public void setClipBoard(Object object) {
        this.clipboard = object;
        this.pastenumber = 1;
    }

    public Object getClipBoard() {
        return this.clipboard;
    }

    public void insertClipBoard() {
        if (this.clipboard != null && this.clipboard instanceof Document) {
            XMLStructureLoader xMLStructureLoader = new XMLStructureLoader(this);
            ++this.pastenumber;
            this.structure.activate();
        }
    }

    public void insertXMLFile(String string, boolean bl) {
        if (string != null) {
            try {
                XMLStructureLoader xMLStructureLoader = new XMLStructureLoader(this);
                xMLStructureLoader.setInsertMode(bl);
                Structure structure = xMLStructureLoader.parse(string, this.getStructure());
                if (structure != null) {
                    this.gui.getEditor().setCanvasSize();
                    ++this.pastenumber;
                }
            }
            catch (Exception exception) {
                System.out.println("INTERNAL ERROR: " + exception);
            }
        }
    }

    public void saveXMLFile(String string) {
        System.out.println("saving the XML file: " + string);
        if (string != null) {
            try {
                XMLStructureSaver xMLStructureSaver = new XMLStructureSaver(this);
                xMLStructureSaver.write(new File(string), this.getStructure(), this.getFormalism());
                this.fileName = string;
                this.gui.setTitle(this.getFormalism().getName() + " - " + string);
                System.out.println(":: File " + this.fileName + " saved");
            }
            catch (Exception exception) {
                System.out.println("INTERNAL ERROR: " + exception);
            }
        }
    }

    public void activate() {
        this.createGroup(false, "sedit", null, null);
        this.requestRole("sedit", "editor", null);
        this.getStructure().preactivate();
        if (this.fileName != null) {
            this.insertXMLFile(this.fileName, false);
            this.gui.getEditor().setCanvasSize();
        }
        this.getStructure().activate();
    }

    public void initGUI() {
        try {
            if (this.gui == null) {
                this.gui = new DefaultStructureBean(this);
            }
            this.setGUIObject(this.gui);
        }
        catch (Exception exception) {
            this.println("StructureAgent:" + exception);
            exception.printStackTrace();
        }
    }

    public void live() {
        boolean bl = true;
        while (bl) {
            Message message = this.waitNextMessage();
            if (message instanceof SEditMessage) {
                if (((SEditMessage)message).getRequest().equals("quit")) {
                    bl = false;
                    continue;
                }
                this.handleMessage((SEditMessage)message);
                continue;
            }
            Structure structure = this.getStructure();
            if (!(structure instanceof ActiveStructure)) continue;
            ((ActiveStructure)((Object)structure)).handleMessage(message);
        }
    }

    public void end() {
        this.getStructure().end();
        if (this.getGUIObject() != null) {
            ((StructureBean)this.getGUIObject()).close();
        }
    }

    public void close() {
        this.sendMessage(this.getAddress(), new SEditMessage("quit"));
    }

    protected void handleMessage(SEditMessage sEditMessage) {
    }

    public SComponent newComponent(boolean bl, ComponentDesc componentDesc, String string, String string2, Hashtable hashtable, Point point, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4) {
        SComponent sComponent = (SComponent)componentDesc.makeElement(hashtable);
        if (string == null) {
            this.getStructure().addNode(sComponent);
            this.pastenumber = 1;
        } else {
            this.getStructure().addNode(sComponent, string);
            point.translate(this.pastenumber * 20, this.pastenumber * 20);
        }
        if (string2 != null) {
            sComponent.setLabel(string2);
        }
        sComponent.initGraphics(hashtable2);
        sComponent.getGObject().setLocation(point);
        if (hashtable3 == null) {
            hashtable3 = componentDesc.makeConnectors();
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                SConnect sConnect = (SConnect)hashtable3.get(string3);
                sConnect.setComponent(sComponent);
                if (sConnect instanceof SInConnect) {
                    sComponent.addInConnect(string3, (SInConnect)sConnect);
                }
                if (sConnect instanceof SOutConnect) {
                    sComponent.addOutConnect(string3, (SOutConnect)sConnect);
                }
                this.getStructure().addNode(sConnect);
                sConnect.initGraphics(hashtable2);
                this.gui.getEditor().installNode(sConnect.getGObject(), false);
                Utils.debug(componentDesc + " " + string + " " + string2 + " " + point + " " + hashtable + " " + hashtable2);
            }
            sComponent.computeConnectorsPositions();
        } else {
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                SConnect sConnect = (SConnect)hashtable3.get(string4);
                sConnect.setConnectorPlacement((ConnectorPlacement)hashtable4.get(string4));
                sConnect.setComponent(sComponent);
                if (sConnect instanceof SInConnect) {
                    sComponent.addInConnect(string4, (SInConnect)sConnect);
                }
                if (!(sConnect instanceof SOutConnect)) continue;
                sComponent.addOutConnect(string4, (SOutConnect)sConnect);
            }
        }
        this.gui.getEditor().installNode(sComponent.getGObject(), bl);
        sComponent.init();
        return sComponent;
    }

    public SNode newNode(boolean bl, NodeDesc nodeDesc, String string, String string2, Hashtable hashtable, Point point, Hashtable hashtable2) {
        SElement sElement = nodeDesc.makeElement(hashtable);
        if (string == null) {
            this.getStructure().addNode((SNode)sElement);
            this.pastenumber = 1;
        } else {
            this.getStructure().addNode((SNode)sElement, string);
            point.translate(this.pastenumber * 20, this.pastenumber * 20);
        }
        if (string2 != null) {
            sElement.setLabel(string2);
        }
        sElement.initGraphics(hashtable2);
        sElement.getGObject().setLocation(point);
        this.gui.getEditor().installNode(sElement.getGObject(), bl);
        sElement.init();
        sElement.getGObject().init();
        return (SNode)sElement;
    }

    public SArrow newArrow(boolean bl, ArrowDesc arrowDesc, String string, String string2, String string3, String string4, Hashtable hashtable, Point point, Hashtable hashtable2) {
        SArrow sArrow = (SArrow)arrowDesc.makeElement(hashtable);
        SNode sNode = this.getStructure().getNode(string2);
        SNode sNode2 = this.getStructure().getNode(string3);
        if (this.getStructure().isConnectable(sArrow, sNode, sNode2)) {
            if (string == null) {
                this.getStructure().addArrow(sArrow, sNode, sNode2);
                this.pastenumber = 1;
            } else {
                this.getStructure().addArrow(sArrow, string, sNode, sNode2);
                point.translate(this.pastenumber * 20, this.pastenumber * 20);
            }
            if (string4 != null) {
                sArrow.setLabel(string4);
            }
            sArrow.initGraphics(hashtable2);
            sArrow.getGObject().setLocation(point);
            this.gui.getEditor().installArrow(sArrow.getGObject(), bl);
            sArrow.init();
            return sArrow;
        }
        System.err.println("Can't connect " + sNode + " " + sNode2);
        return null;
    }

    public SElement doCommand(Command command) {
        if (command instanceof NewNodeCommand) {
            NodeDesc nodeDesc = this.getFormalism().getNodeDesc(((NewNodeCommand)command).getNodeDesc());
            Point point = ((NewNodeCommand)command).getPosition();
            if (nodeDesc instanceof ComponentDesc) {
                return this.newComponent(false, (ComponentDesc)nodeDesc, null, null, null, point, null, null, null);
            }
            return this.newNode(false, nodeDesc, null, null, null, point, null);
        }
        if (command instanceof NewArrowCommand) {
            ArrowDesc arrowDesc = this.getFormalism().getArrowDesc(((NewArrowCommand)command).getArrowDesc());
            String string = ((NewArrowCommand)command).getOriginID();
            String string2 = ((NewArrowCommand)command).getTargetID();
            Point point = ((NewArrowCommand)command).getPosition();
            return this.newArrow(false, arrowDesc, null, string, string2, null, null, point, null);
        }
        return null;
    }

    public void sendToRecipient(Message message) {
        if (this.getRecipient() != null) {
            this.sendMessage(this.getRecipient(), message);
        }
    }

    public void doPause(int n) {
        this.pause(n);
    }

    public boolean askMessageBoxEmpty() {
        return this.isMessageBoxEmpty();
    }

    public void doSendMessage(AgentAddress agentAddress, Message message) {
        this.sendMessage(agentAddress, message);
    }

    public void doBroadcastMessage(String string, String string2, Message message) {
        this.sendMessage(string, string2, message);
    }

    public void println(String string) {
        System.out.println(string);
    }

    public void doKillAgent(AbstractAgent abstractAgent) {
        this.killAgent(abstractAgent);
    }

    public void makeLaunchAgent(String string, String string2) {
        try {
            Agent agent = (Agent)madkit.kernel.Utils.loadClass((String)string).newInstance();
            this.launchAgent((AbstractAgent)agent, string2, true);
        }
        catch (Exception exception) {
            this.println("launch-agent exception:" + exception);
        }
    }

    public void doLaunchAgent(AbstractAgent abstractAgent, String string, boolean bl) {
        this.launchAgent(abstractAgent, string, bl);
    }

    public LList schemeGetAgentsWithRole(String string, String string2) {
        return LList.makeList((Object[])this.getAgentsWithRole(string, string2), (int)0);
    }

    public LList schemeGetAgentsWithRole(String string, String string2, String string3) {
        return LList.makeList((Object[])this.getAgentsWithRole(string, string2, string3), (int)0);
    }

    public LList schemeGetMyGroups() {
        return LList.makeList((Object[])this.getMyGroups(), (int)0);
    }

    public LList schemeGetMyGroups(String string) {
        return LList.makeList((Object[])this.getMyGroups(string), (int)0);
    }

    public LList schemeGetExistingGroups() {
        return LList.makeList((Object[])this.getExistingGroups(), (int)0);
    }

    public LList schemeGetExistingGroups(String string) {
        return LList.makeList((Object[])this.getExistingGroups(string), (int)0);
    }

    public LList schemeGetRoles(String string) {
        return LList.makeList((Object[])this.getExistingRoles(string), (int)0);
    }

    public LList schemeGetRoles(String string, String string2) {
        return LList.makeList((Object[])this.getExistingRoles(string, string2), (int)0);
    }

    public LList schemeGetExistingRoles(String string) {
        return LList.makeList((Object[])this.getExistingRoles(string), (int)0);
    }

    public LList schemeGetExistingRoles(String string, String string2) {
        return LList.makeList((Object[])this.getExistingRoles(string, string2), (int)0);
    }

    public LList schemeGetMyRoles(String string) {
        return LList.makeList((Object[])this.getMyRoles(string), (int)0);
    }

    public LList schemeGetMyRoles(String string, String string2) {
        return LList.makeList((Object[])this.getMyRoles(string, string2), (int)0);
    }

    public LList schemeGetAvailableCommunities() {
        return LList.makeList((Object[])this.getAvailableCommunities(), (int)0);
    }
}

