/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Scheme;

import SEdit.Scheme.STools;
import SEdit.Structure;
import gnu.expr.Interpreter;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.text.SyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import kawa.Shell;
import kawa.lang.AutoloadProcedure;
import kawa.standard.Scheme;
import kawa.standard.load;
import madkit.kernel.Utils;

public class SchemeModule {
    public String madkitDirectory;
    protected Environment environment;
    public static Scheme interpreter = null;
    public static int envcount;
    Structure structure;

    Structure getStructure() {
        return this.structure;
    }

    void setStructure(Structure structure) {
        this.structure = structure;
    }

    public void setAsCurrentEnv() {
        Environment.setCurrent((Environment)this.environment);
    }

    public Object readExpr(InPort inPort) throws IOException, SyntaxException {
        return interpreter.read(inPort);
    }

    public Object eval(Object object) {
        return Scheme.eval((Object)object, (Environment)this.environment);
    }

    public void evalString(String string) {
        try {
            Object object = STools.readFromString(string);
            System.out.println(":: test de : " + object + " : " + STools.prinToString(string));
            Object object2 = Scheme.eval((Object)object, (Environment)this.environment);
            System.out.println(">> " + object2 + " : " + STools.prinToString(object2));
        }
        catch (IOException iOException) {
        }
        catch (SyntaxException syntaxException) {
            System.out.println("Erreur de syntaxe: " + (Object)((Object)syntaxException));
        }
    }

    public static void runOutString(String string, Scheme scheme, Environment environment, OutPort outPort) {
        if (outPort == null) {
            outPort = OutPort.outDefault();
        }
        Shell.run((Interpreter)scheme, (Environment)environment, (InPort)new CharArrayInPort(string), (OutPort)outPort, (OutPort)OutPort.errDefault());
    }

    Object evalit1(Object object, Hashtable hashtable) {
        if (object instanceof Pair) {
            return new Pair(this.evalit1(((Pair)object).car, hashtable), this.evalit1(((Pair)object).cdr, hashtable));
        }
        if (object instanceof String && ((String)object).charAt(0) == '?' && hashtable.containsKey((String)object)) {
            return new Pair((Object)"quote", (Object)new Pair(hashtable.get(object), (Object)LList.Empty));
        }
        return object;
    }

    Object evalit(Object object, Hashtable hashtable) {
        Object object2 = this.evalit1(object, hashtable);
        Object object3 = null;
        System.out.println(":: evaluation de : " + object2 + " : " + STools.prinToString(object2));
        object3 = Scheme.eval((Object)object2, (Environment)this.environment);
        return object3;
    }

    void define_proc(String string, String string2) {
        interpreter.define(string, (Object)new AutoloadProcedure(string, string2));
    }

    void checkInitFile() {
        if (this.madkitDirectory == null) {
            String string = "scheme/init.scm";
            this.madkitDirectory = System.getProperty("madkit.dir");
            Boolean bl = this.madkitDirectory != null ? new FString(this.madkitDirectory) : Scheme.falseObject;
            this.environment.define("user-directory", (Object)bl);
            File file = new File(string);
            if (file.exists()) {
                System.err.println(">> chargement de " + file.getPath());
                try {
                    InPort inPort = InPort.openFile((String)file.getPath());
                    load.loadSource((InPort)inPort, (Environment)this.environment);
                    inPort.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
    }

    public Environment getEnvironment() {
        return interpreter.getEnvironment();
    }

    public SchemeModule(Structure structure) {
        this.setStructure(structure);
        if (Interpreter.defaultInterpreter == null) {
            Interpreter.defaultInterpreter = new Scheme();
            Environment.setCurrent((Environment)Interpreter.defaultInterpreter.getEnvironment());
        }
        if (interpreter == null) {
            interpreter = new Scheme();
        }
        this.environment = interpreter.getNewEnvironment();
        System.err.println("initialisation de Scheme :" + ++envcount + " " + this.environment);
    }

    public void init() {
        Object object = Scheme.eval((String)("(define %scheme-agent-count% " + envcount + ")"), (Environment)this.environment);
        this.environment.define("%current-agent%", (Object)this.getStructure().getAgent());
        this.environment.define("self", (Object)this.getStructure().getAgent());
        StringBuffer stringBuffer = new StringBuffer();
        String string = "SEditSchemeAgentLib.scm";
        try {
            InputStream inputStream = Utils.loadClass((String)"SEdit.Scheme.SchemeModule").getResourceAsStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append('\n');
                stringBuffer.append(string2);
            }
        }
        catch (Exception exception) {
            System.err.println("Cannot load :" + string);
            exception.printStackTrace();
        }
        Scheme.eval((String)stringBuffer.toString(), (Environment)this.environment);
    }
}

