/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.AboutBox;
import SEdit.HelpBox;
import SEdit.SEditAgent;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SEditGUI
extends JRootPane
implements ActionListener {
    Hashtable<DefaultMutableTreeNode, String> formalisms = new Hashtable();
    SEditAgent myAgent;
    private static boolean installFileName = false;
    JTree scrollingTree;
    DefaultMutableTreeNode loadedRoot;
    DefaultMutableTreeNode preloadedRoot;
    DefaultMutableTreeNode realRoot;
    JMenuItem metalMenuItem;

    public static void setInstallFileName(boolean bl) {
        installFileName = bl;
    }

    public static boolean getInstallFileName() {
        return installFileName;
    }

    public static void showClipBoard() {
    }

    void quit() {
        int n = JOptionPane.showConfirmDialog(this, "Do you really want to quit SEdit?", "Quit", 0, 3, null);
        if (n == 0) {
            System.exit(0);
        }
    }

    void addTool(JToolBar jToolBar, String string, String string2) {
        URL uRL = ClassLoader.getSystemResource(string2);
        JButton jButton = null;
        uRL = this.getClass().getResource(string2);
        jButton = uRL != null ? (JButton)jToolBar.add(new JButton(new ImageIcon(uRL))) : (JButton)jToolBar.add(new JButton(string));
        jButton.setToolTipText(string);
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
    }

    public static void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n) {
        SEditGUI.addMenuItem(actionListener, jMenu, string, string2, n, -1);
    }

    public static void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n, int n2) {
        JMenuItem jMenuItem = n > 0 ? new JMenuItem(string, n) : new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        if (n2 > 0) {
            if (n2 != 127) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, 2, false));
            } else {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, 0, false));
            }
        }
    }

    public static void addRadioButtonMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setActionCommand(string2);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setSelected(bl);
        buttonGroup.add(jRadioButtonMenuItem);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.command(actionEvent.getActionCommand());
    }

    SEditGUI(SEditAgent sEditAgent) {
        this.myAgent = sEditAgent;
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        JToolBar jToolBar = new JToolBar();
        this.addTool(jToolBar, "open", "/toolbarButtonGraphics/general/Open24.gif");
        this.addTool(jToolBar, "quit", "/toolbarButtonGraphics/general/Stop24.gif");
        jToolBar.addSeparator();
        jPanel.add("South", jToolBar);
        this.getContentPane().add("North", jPanel);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('f');
        jMenuBar.add(jMenu);
        SEditGUI.addMenuItem(this, jMenu, "Open...", "open", 79, 79);
        SEditGUI.addMenuItem(this, jMenu, "Quit", "quit", 81, 81);
        this.getRootPane().setJMenuBar(jMenuBar);
        JMenu jMenu2 = new JMenu("Formalisms");
        jMenuBar.add(jMenu2);
        SEditGUI.addMenuItem(this, jMenu2, "Add a formalism...", "loadFormalism", -1);
        SEditGUI.addMenuItem(this, jMenu2, "Add a formalism from Web...", "urlFormalism", -1);
        JMenu jMenu3 = new JMenu("Help");
        jMenuBar.add(jMenu3);
        SEditGUI.addMenuItem(this, jMenu3, "About", "about", -1);
        SEditGUI.addMenuItem(this, jMenu3, "Help", "help", -1);
        this.realRoot = new DefaultMutableTreeNode("Formalisms");
        this.preloadedRoot = new DefaultMutableTreeNode("Preloaded");
        this.realRoot.add(this.preloadedRoot);
        this.scrollingTree = new JTree(this.realRoot);
        this.scrollingTree.setRootVisible(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.scrollingTree);
        this.getContentPane().add("Center", jScrollPane);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        URL uRL = this.getClass().getResource("/sedit/FormalismIconColor16.gif");
        defaultTreeCellRenderer.setLeafIcon(new ImageIcon(uRL));
        this.scrollingTree.setCellRenderer(defaultTreeCellRenderer);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                String string;
                int n = SEditGUI.this.scrollingTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = SEditGUI.this.scrollingTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 2 && ((TreeNode)treePath.getLastPathComponent()).isLeaf() && (string = SEditGUI.this.formalisms.get(treePath.getLastPathComponent())) != null) {
                    SEditGUI.this.myAgent.startEditor(string);
                }
            }
        };
        this.scrollingTree.addMouseListener(mouseAdapter);
    }

    public void addPreloaded(String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
        this.formalisms.put(defaultMutableTreeNode, string);
        this.preloadedRoot.add(defaultMutableTreeNode);
        this.scrollingTree.repaint();
    }

    public void updateFormalismList(String string, String string2) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.scrollingTree.getModel();
        if (this.loadedRoot == null) {
            this.loadedRoot = new DefaultMutableTreeNode("Added");
            defaultTreeModel.insertNodeInto(this.loadedRoot, this.realRoot, defaultTreeModel.getChildCount(this.realRoot));
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
        this.formalisms.put(defaultMutableTreeNode, string);
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.loadedRoot, defaultTreeModel.getChildCount(this.loadedRoot));
        this.scrollingTree.repaint();
    }

    void command(String string) {
        if (string.equals("quit")) {
            this.quit();
        } else if (string.equals("open")) {
            JFileChooser jFileChooser;
            int n;
            File file = new File(System.getProperty("madkit.dir") + "/plugins/SEdit/scripts");
            if (!file.isDirectory()) {
                file = new File(System.getProperty("user.dir") + "/scripts");
            }
            if (!file.isDirectory()) {
                file = new File(System.getProperty("user.dir"));
            }
            if ((n = (jFileChooser = new JFileChooser(file)).showOpenDialog(null)) != -1 && jFileChooser.getSelectedFile() != null) {
                String string2 = jFileChooser.getSelectedFile().getParent() + File.separator;
                String string3 = jFileChooser.getSelectedFile().getName();
                this.myAgent.openFile(string2 + File.separator + string3);
            }
        } else if (string.equals("showClipBoard")) {
            SEditGUI.showClipBoard();
        } else if (string.equals("help")) {
            HelpBox helpBox = new HelpBox("docs/index.html");
        } else if (string.equals("about")) {
            new AboutBox();
        } else if (string.equals("loadFormalism")) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir", null));
            int n = jFileChooser.showOpenDialog(null);
            if (n != -1 && jFileChooser.getSelectedFile() != null) {
                String string4 = jFileChooser.getSelectedFile().getParent() + File.separator;
                String string5 = jFileChooser.getSelectedFile().getName();
                this.myAgent.loadFormalism(string4 + string5);
            }
        } else if (string.equals("urlFormalism")) {
            String string6 = JOptionPane.showInputDialog(this, "URL to a SEdit formalism", "URL Formalism", -1);
            this.myAgent.urlFormalism(string6);
        } else if (string.equals("look and feel")) {
            System.out.println("look and feel: " + UIManager.getLookAndFeel().getName());
        } else {
            System.out.println("command: " + string);
        }
    }

    class ToggleUIListener
    implements ItemListener {
        ToggleUIListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }
}

