/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.Formalism;
import SEdit.FormalismAgent;
import SEdit.SEditGUI;
import SEdit.SEditMessage;
import SEdit.StructureAgent;
import SEdit.XMLStructureLoader;
import java.awt.AWTEvent;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.Message;

public class SEditAgent
extends Agent {
    SEditGUI gui;
    public static String VERSION = "3.2.2";
    public static String DATE = "04/2005";
    String fileDir;
    String fileName;
    boolean insertMode = false;

    public void activate() {
        this.createGroup(false, "sedit", null, null);
        this.requestRole("sedit", "control-center", null);
        this.println("SEdit, Version " + VERSION + " launched");
        this.debug("Launching FormalismServer");
        this.launchAgent((AbstractAgent)new FormalismAgent(), "Formalizator", false);
    }

    public void loadFormalism(String string) {
        this.sendMessage("sedit", "formalism-server", new SEditMessage("load", string));
    }

    public void urlFormalism(String string) {
        this.sendMessage("sedit", "formalism-server", new SEditMessage("www-get", string));
    }

    public void initGUI() {
        this.gui = new SEditGUI(this);
        this.setGUIObject(this.gui);
    }

    public void doLaunchAgent(AbstractAgent abstractAgent, String string, boolean bl) {
        this.launchAgent(abstractAgent, string, bl);
    }

    public void live() {
        while (this.getAgentsWithRole("sedit", "formalism-server").length == 0) {
            this.pause(200);
        }
        this.sendMessage("sedit", "formalism-server", new SEditMessage("list"));
        SEditMessage sEditMessage = (SEditMessage)this.waitNextMessage();
        Vector vector = (Vector)sEditMessage.getParameter();
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            if (stringArray[1].equals("")) {
                this.gui.addPreloaded(stringArray[0], stringArray[0]);
            } else {
                this.gui.addPreloaded(stringArray[0], stringArray[1]);
            }
            this.gui.repaint();
        }
        while (true) {
            Message message;
            if (!((message = this.waitNextMessage()) instanceof SEditMessage)) {
                continue;
            }
            this.handleMessage((SEditMessage)message);
        }
    }

    protected void handleMessage(SEditMessage sEditMessage) {
        if (sEditMessage.getRequest() == "reply") {
            Formalism formalism = (Formalism)sEditMessage.getParameter();
            if (formalism != null) {
                if (this.fileName != null) {
                    StructureAgent structureAgent = new StructureAgent(formalism, this.fileName);
                    this.launchAgent((AbstractAgent)structureAgent, formalism.getName() + " - " + this.fileName, true);
                    this.fileName = null;
                } else {
                    StructureAgent structureAgent = new StructureAgent(formalism);
                    this.launchAgent((AbstractAgent)structureAgent, formalism.getName() + " - Untitled", true);
                }
            } else {
                System.err.println("ERROR: no formalism found");
            }
        } else if (sEditMessage.getRequest() == "update") {
            String[] stringArray = (String[])sEditMessage.getParameter();
            if (stringArray[1].equals("")) {
                this.gui.updateFormalismList(stringArray[0], stringArray[0]);
            } else {
                this.gui.updateFormalismList(stringArray[0], stringArray[1]);
            }
            this.gui.repaint();
        }
    }

    public void startEditor(String string) {
        this.sendMessage("sedit", "formalism-server", new SEditMessage("get", string));
    }

    void openFile(String string) {
        if (string != null) {
            try {
                String string2 = XMLStructureLoader.parseFormalismName(string);
                if (string2 != null) {
                    this.fileName = string;
                    this.sendMessage("sedit", "formalism-server", new SEditMessage("get", string2));
                }
            }
            catch (Exception exception) {
                System.out.println("INTERNAL ERROR: " + exception);
            }
        }
    }

    public void createModel(String string) {
        this.insertMode = true;
        this.sendMessage("sedit", "formalism-server", new SEditMessage("get", string));
    }

    public void end() {
        System.exit(0);
    }

    public void windowClosing(AWTEvent aWTEvent) {
        this.gui.quit();
    }
}

