/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.ComponentDesc;
import SEdit.ConnectorPlacement;
import SEdit.Graphics.GObject;
import SEdit.SArrow;
import SEdit.SConnect;
import SEdit.SInConnect;
import SEdit.SNode;
import SEdit.SOutConnect;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SComponent
extends SNode {
    boolean beingDeleted = false;
    private Hashtable<String, SInConnect> inPins = new Hashtable();
    private Hashtable<String, SOutConnect> outPins = new Hashtable();

    @Override
    public Vector getInArrows() {
        return null;
    }

    @Override
    public Vector getOutArrows() {
        return null;
    }

    @Override
    protected void addOutArrow(SArrow sArrow) {
    }

    @Override
    protected void addInArrow(SArrow sArrow) {
    }

    public void addConnector(String string) {
        try {
            SConnect sConnect = ((ComponentDesc)this.getDescriptor()).makeConnector(string);
            if (sConnect instanceof SInConnect) {
                this.addInConnect(string, (SInConnect)sConnect);
            }
            if (sConnect instanceof SOutConnect) {
                this.addOutConnect(string, (SOutConnect)sConnect);
            }
            sConnect.setComponent(this);
            this.getStructure().addNode(sConnect);
            sConnect.initGraphics(null);
            this.getStructure().getAgent().gui.getEditor().installNode(sConnect.getGObject(), false);
            this.computeConnectorsPositions();
        }
        catch (Exception exception) {
            System.err.println("AddConnector Error" + exception);
            exception.printStackTrace();
        }
    }

    protected void addInConnect(String string, SInConnect sInConnect) {
        if (this.inPins.containsKey(string)) {
            int n = 1;
            while (this.inPins.containsKey(string + " " + n)) {
                ++n;
            }
            this.inPins.put(string + " " + n, sInConnect);
            sInConnect.setLabel(string + n);
        } else {
            this.inPins.put(string, sInConnect);
            sInConnect.setLabel(string);
        }
    }

    protected void addOutConnect(String string, SOutConnect sOutConnect) {
        if (this.outPins.containsKey(string)) {
            int n = 1;
            while (this.outPins.containsKey(string + " " + n)) {
                ++n;
            }
            this.outPins.put(string + " " + n, sOutConnect);
            sOutConnect.setLabel(string + n);
        } else {
            this.outPins.put(string, sOutConnect);
            sOutConnect.setLabel(string);
        }
    }

    protected void removeInConnect(SInConnect sInConnect) {
        this.inPins.remove(sInConnect);
    }

    protected void removeOutConnect(SOutConnect sOutConnect) {
        this.outPins.remove(sOutConnect);
    }

    protected void removeConnector(SConnect sConnect) {
        if (sConnect instanceof SInConnect) {
            this.removeInConnect((SInConnect)sConnect);
        }
        if (sConnect instanceof SOutConnect) {
            this.removeOutConnect((SOutConnect)sConnect);
        }
    }

    public SInConnect getInConnect(int n) {
        int n2 = 0;
        Enumeration<SInConnect> enumeration = this.inPins.elements();
        while (enumeration.hasMoreElements()) {
            SInConnect sInConnect = enumeration.nextElement();
            if (n2 == n) {
                return sInConnect;
            }
            ++n2;
        }
        return null;
    }

    public SOutConnect getOutConnect(int n) {
        int n2 = 0;
        Enumeration<SOutConnect> enumeration = this.outPins.elements();
        while (enumeration.hasMoreElements()) {
            SOutConnect sOutConnect = enumeration.nextElement();
            if (n2 == n) {
                return sOutConnect;
            }
            ++n2;
        }
        return null;
    }

    public SInConnect getInConnect(String string) {
        return this.inPins.get(string);
    }

    public SOutConnect getOutConnect(String string) {
        return this.outPins.get(string);
    }

    public Enumeration<String> getInNames() {
        return this.inPins.keys();
    }

    public Enumeration<String> getOutNames() {
        return this.outPins.keys();
    }

    public Enumeration<SInConnect> getInConnectors() {
        return this.inPins.elements();
    }

    public Enumeration<SOutConnect> getOutConnectors() {
        return this.outPins.elements();
    }

    public void deleteConnector(String string) {
        if (this.inPins.containsKey(string)) {
            this.inPins.remove(string);
        }
        if (this.outPins.containsKey(string)) {
            this.outPins.remove(string);
        }
    }

    @Override
    public void delete() {
        super.delete();
        this.beingDeleted = true;
        Enumeration<SConnect> enumeration = this.inPins.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().delete();
        }
        enumeration = this.outPins.elements();
        while (enumeration.hasMoreElements()) {
            ((SOutConnect)enumeration.nextElement()).delete();
        }
    }

    public void computeConnectorsPositions() {
        GObject gObject = this.getGObject();
        int n = gObject.getDimension().width;
        int n2 = gObject.getDimension().height;
        int n3 = gObject.getLocation().x;
        int n4 = gObject.getLocation().y;
        int n5 = 4;
        int n6 = 0;
        switch (((ComponentDesc)this.getDescriptor()).getLayout()) {
            case 1: {
                SConnect sConnect;
                n6 = n4 + n5;
                Enumeration<SConnect> enumeration = this.inPins.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    sConnect.getGObject().setLocation(n3 - sConnect.getGObject().getDimension().width / 2, n6);
                    n6 = n6 + sConnect.getGObject().getDimension().height + n5;
                    sConnect.getConnectorPlacement().setSide(2);
                }
                n6 = n4 + n5;
                enumeration = this.outPins.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    sConnect.getGObject().setLocation(n3 + n - sConnect.getGObject().getDimension().width / 2, n6);
                    n6 = n6 + sConnect.getGObject().getDimension().height + n5;
                    sConnect.getConnectorPlacement().setSide(1);
                }
                break;
            }
            case 2: {
                SConnect sConnect;
                Vector<SConnect> vector = new Vector<SConnect>();
                Vector<SConnect> vector2 = new Vector<SConnect>();
                Vector<SConnect> vector3 = new Vector<SConnect>();
                Vector<SConnect> vector4 = new Vector<SConnect>();
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                Enumeration<SConnect> enumeration = this.inPins.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    switch (sConnect.getConnectorPlacement().getSide()) {
                        case 2: {
                            vector.addElement(sConnect);
                            n7 += sConnect.getGObject().getDimension().height;
                            break;
                        }
                        case 1: {
                            vector2.addElement(sConnect);
                            n8 += sConnect.getGObject().getDimension().height;
                            break;
                        }
                        case 3: {
                            vector3.addElement(sConnect);
                            n9 += sConnect.getGObject().getDimension().width;
                            break;
                        }
                        case 4: {
                            vector4.addElement(sConnect);
                            n10 += sConnect.getGObject().getDimension().width;
                        }
                    }
                }
                enumeration = this.outPins.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    switch (sConnect.getConnectorPlacement().getSide()) {
                        case 2: {
                            vector.addElement(sConnect);
                            n7 += sConnect.getGObject().getDimension().height;
                            break;
                        }
                        case 1: {
                            vector2.addElement(sConnect);
                            n8 += sConnect.getGObject().getDimension().height;
                            break;
                        }
                        case 3: {
                            vector3.addElement(sConnect);
                            n9 += sConnect.getGObject().getDimension().width;
                            break;
                        }
                        case 4: {
                            vector4.addElement(sConnect);
                            n10 += sConnect.getGObject().getDimension().width;
                        }
                    }
                }
                n5 = (n2 - n7) / (vector.size() + 1);
                n6 = n4 + n5;
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    sConnect.getGObject().setLocation(n3 - sConnect.getGObject().getDimension().width / 2, n6);
                    n6 = n6 + sConnect.getGObject().getDimension().height + n5;
                }
                n5 = (n2 - n8) / (vector2.size() + 1);
                n6 = n4 + n5;
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    sConnect.getGObject().setLocation(n3 + n - sConnect.getGObject().getDimension().width / 2, n6);
                    n6 = n6 + sConnect.getGObject().getDimension().height + n5;
                }
                n5 = (n - n9) / (vector3.size() + 1);
                n6 = n3 + n5;
                enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    sConnect.getGObject().setLocation(n6, n4 - sConnect.getGObject().getDimension().height / 2);
                    n6 = n6 + sConnect.getGObject().getDimension().width + n5;
                }
                n5 = (n - n10) / (vector4.size() + 1);
                n6 = n3 + n5;
                enumeration = vector4.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    sConnect.getGObject().setLocation(n6, n4 + n2 - sConnect.getGObject().getDimension().height / 2);
                    n6 = n6 + sConnect.getGObject().getDimension().width + n5;
                }
                break;
            }
            case 3: {
                int n11;
                int n12;
                int n13;
                double d;
                double d2;
                ConnectorPlacement connectorPlacement;
                SConnect sConnect;
                Enumeration<SConnect> enumeration = this.inPins.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    connectorPlacement = sConnect.getConnectorPlacement();
                    d2 = 0.0;
                    d = 0.0;
                    n13 = Math.round(sConnect.getGObject().getDimension().width / 2);
                    n12 = Math.round(sConnect.getGObject().getDimension().height / 2);
                    switch (connectorPlacement.getSide()) {
                        case 2: {
                            n11 = (int)Math.round((double)n2 * connectorPlacement.getRatio());
                            d2 = n3 - n13 + gObject.intersection(2, n11);
                            d = n4 + n11 - n12;
                            break;
                        }
                        case 1: {
                            n11 = (int)Math.round((double)n2 * connectorPlacement.getRatio());
                            d2 = n3 - n13 + gObject.intersection(1, n11);
                            d = n4 + n11 - n12;
                            break;
                        }
                        case 3: {
                            n11 = (int)Math.round((double)n * connectorPlacement.getRatio());
                            d2 = n3 + n11 - n13;
                            d = n4 - n12 + gObject.intersection(3, n11);
                            break;
                        }
                        case 4: {
                            n11 = (int)Math.round((double)n * connectorPlacement.getRatio());
                            d2 = n3 + n11 - n13;
                            d = n4 - n12 + gObject.intersection(4, n11);
                        }
                    }
                    sConnect.getGObject().setLocation((int)Math.round(d2), (int)Math.round(d));
                }
                enumeration = this.outPins.elements();
                while (enumeration.hasMoreElements()) {
                    sConnect = enumeration.nextElement();
                    connectorPlacement = sConnect.getConnectorPlacement();
                    d2 = 0.0;
                    d = 0.0;
                    n13 = Math.round(sConnect.getGObject().getDimension().width / 2);
                    n12 = Math.round(sConnect.getGObject().getDimension().height / 2);
                    switch (connectorPlacement.getSide()) {
                        case 2: {
                            n11 = (int)Math.round((double)n2 * connectorPlacement.getRatio());
                            d2 = n3 - n13 + gObject.intersection(2, n11);
                            d = n4 + n11 - n12;
                            break;
                        }
                        case 1: {
                            n11 = (int)Math.round((double)n2 * connectorPlacement.getRatio());
                            d2 = n3 - n13 + gObject.intersection(1, n11);
                            d = n4 + n11 - n12;
                            break;
                        }
                        case 3: {
                            n11 = (int)Math.round((double)n * connectorPlacement.getRatio());
                            d2 = n3 + n11 - n13;
                            d = n4 - n12 + gObject.intersection(3, n11);
                            break;
                        }
                        case 4: {
                            n11 = (int)Math.round((double)n * connectorPlacement.getRatio());
                            d2 = n3 + n11 - n13;
                            d = n4 - n12 + gObject.intersection(4, n11);
                        }
                    }
                    sConnect.getGObject().setLocation((int)Math.round(d2), (int)Math.round(d));
                }
                break;
            }
        }
    }

    @Override
    protected boolean isConnectable(SArrow sArrow, boolean bl) {
        return false;
    }

    public String toString() {
        SConnect sConnect;
        String string = "SComponent " + super.toString();
        string = string + " in[";
        Enumeration<SConnect> enumeration = this.inPins.elements();
        while (enumeration.hasMoreElements()) {
            sConnect = enumeration.nextElement();
            string = string + "(" + sConnect.getGObject() + ")";
        }
        string = string + "] out[";
        enumeration = this.outPins.elements();
        while (enumeration.hasMoreElements()) {
            sConnect = (SOutConnect)enumeration.nextElement();
            string = string + "(" + sConnect.getGObject() + ")";
        }
        return string + "]";
    }
}

