/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

class HtmlPane
extends JPanel
implements HyperlinkListener {
    JEditorPane html;
    Object base;

    public HtmlPane(String string, Object object) {
        this.setLayout(new BorderLayout());
        this.base = object;
        try {
            URL uRL = string.startsWith("http") ? new URL(string) : new URL("file:" + new File(string).getCanonicalPath());
            this.html = new JEditorPane(uRL);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            JScrollPane jScrollPane = new JScrollPane();
            JViewport jViewport = jScrollPane.getViewport();
            jViewport.add(this.html);
            this.add((Component)jScrollPane, "Center");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Malformed URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        Cursor cursor = this.html.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        this.html.setCursor(cursor2);
        SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL uRL, Cursor cursor) {
            this.url = uRL;
            this.cursor = cursor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.url == null) {
                HtmlPane.this.html.setCursor(this.cursor);
                Container container = HtmlPane.this.html.getParent();
                container.repaint();
            } else {
                Document document = HtmlPane.this.html.getDocument();
                try {
                    HtmlPane.this.html.setPage(this.url);
                }
                catch (IOException iOException) {
                    HtmlPane.this.html.setDocument(document);
                    HtmlPane.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

