/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Graphics;

import SEdit.Graphics.GNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class GRectangle
extends GNode {
    protected static int rDefaultWidth = 40;
    protected static int rDefaultHeight = 60;

    public GRectangle() {
        this.setDimension(rDefaultWidth, rDefaultHeight);
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.white);
        graphics.fillRect(this.x, this.y, this.width, this.height);
        graphics.setColor(color);
        graphics.drawRect(this.x, this.y, this.width, this.height);
    }

    public boolean isContainedIn(Rectangle rectangle) {
        return rectangle.contains(this.x + this.width / 2, this.y + this.height / 2);
    }

    public boolean contains(Point point) {
        return new Rectangle(this.x, this.y, this.width, this.height).contains(point);
    }

    public Point intersection(Point point) {
        float f = Math.abs((float)(this.width / 2) / (float)(point.x - (this.x + this.width / 2)));
        float f2 = Math.abs((float)(this.height / 2) / (float)(point.y - (this.y + this.height / 2)));
        float f3 = Math.min(f, f2);
        Point point2 = new Point(Math.round((float)(this.x + this.width / 2) + f3 * (float)(point.x - (this.x + this.width / 2))), Math.round((float)(this.y + this.height / 2) + f3 * (float)(point.y - (this.y + this.height / 2))));
        return point2;
    }
}

