/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Graphics;

import SEdit.SElement;
import SEdit.StructureEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public abstract class GObject {
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int CENTER = 5;
    public static final int TOP_RIGHT = 6;
    StructureEditor editor;
    Color foreground = Color.black;
    public boolean selected = false;
    protected boolean displayLabel = true;
    protected int labelLocation = 5;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Rectangle bounds;
    protected SElement element;

    public StructureEditor getEditor() {
        return this.editor;
    }

    public void setEditor(StructureEditor structureEditor) {
        this.editor = structureEditor;
    }

    public Rectangle getRectangle() {
        if (this.bounds == null) {
            this.bounds = new Rectangle(this.x, this.y, this.width, this.height);
            return this.bounds;
        }
        this.bounds.setBounds(this.x, this.y, this.width, this.height);
        return this.bounds;
    }

    public int getLabelLocation() {
        return this.labelLocation;
    }

    public void setLabelLocation(int n) {
        this.labelLocation = n;
    }

    public boolean getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(boolean bl) {
        this.displayLabel = bl;
    }

    public Point getCenter() {
        return new Point(this.x + this.width / 2, this.y + this.height / 2);
    }

    public void setCenter(Point point) {
        this.setCenter(point.x, point.y);
    }

    public void setCenter(int n, int n2) {
        this.setLocation(n - this.width / 2, n2 - this.height / 2);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void init() {
    }

    public void drag(int n, int n2, int n3, int n4) {
        this.translate(n2 - n, n4 - n3);
    }

    public void alignHorizontalTo(GObject gObject) {
        this.setCenter(this.getCenter().x, gObject.getCenter().y);
    }

    public void alignVerticalTo(GObject gObject) {
        this.setCenter(gObject.getCenter().x, this.getCenter().y);
    }

    public void select(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isSelectable() {
        return true;
    }

    public void paint(Graphics graphics) {
    }

    public boolean contains(Point point) {
        return new Rectangle(this.x, this.y, this.width, this.height).contains(point);
    }

    public Point intersection(Point point) {
        float f = Math.abs((float)(this.width / 2) / (float)(point.x - (this.x + this.width / 2)));
        float f2 = Math.abs((float)(this.height / 2) / (float)(point.y - (this.y + this.height / 2)));
        float f3 = Math.min(f, f2);
        Point point2 = new Point(Math.round((float)(this.x + this.width / 2) + f3 * (float)(point.x - (this.x + this.width / 2))), Math.round((float)(this.y + this.height / 2) + f3 * (float)(point.y - (this.y + this.height / 2))));
        return point2;
    }

    public int intersection(int n, int n2) {
        switch (n) {
            case 1: {
                return this.width;
            }
            case 4: {
                return this.height;
            }
        }
        return 0;
    }

    public void translate(int n, int n2) {
        Point point = this.getLocation();
        point.translate(n, n2);
        this.setLocation(point);
    }

    public void translateWrap(int n, int n2, Rectangle rectangle) {
        Point point = this.getLocation();
        point.x += n;
        if (point.x + this.width >= rectangle.x + rectangle.width) {
            point.x = point.x + this.width - rectangle.width;
        } else if (point.x < rectangle.x) {
            point.x = point.x + rectangle.width - this.width;
        }
        point.y += n2;
        if (point.y + this.height >= rectangle.y + rectangle.height) {
            point.y = point.y + this.height - rectangle.height;
        } else if (point.y < rectangle.y) {
            point.y = point.y + rectangle.height - this.height;
        }
        this.setLocation(point);
    }

    public void translateBound(int n, int n2, Rectangle rectangle) {
        Point point = this.getLocation();
        point.x += n;
        if (point.x >= rectangle.x + rectangle.width - this.width) {
            point.x = rectangle.x + rectangle.width - this.width - 1;
        }
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        point.y += n2;
        if (point.y >= rectangle.y + rectangle.height - this.height) {
            point.y = rectangle.y + rectangle.height - this.height - 1;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        this.setLocation(point);
    }

    public void snapToGrid(int n) {
        this.x = n * (int)Math.round((double)this.x / (double)n);
        this.y = n * (int)Math.round((double)this.y / (double)n);
    }

    public SElement getSElement() {
        return this.element;
    }

    public void setSElement(SElement sElement) {
        this.element = sElement;
    }

    public boolean isContainedIn(Rectangle rectangle) {
        return rectangle.contains(this.getLocation());
    }

    public boolean isContainedIn(Polygon polygon) {
        return polygon.contains(this.getLocation());
    }

    public void displayName(Graphics graphics) {
        String string = this.getSElement().getLabel();
        if (string == null) {
            string = this.getSElement().getID();
        }
        if (this.displayLabel) {
            switch (this.labelLocation) {
                case 5: {
                    FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                    int n = fontMetrics.stringWidth(string);
                    int n2 = fontMetrics.getAscent();
                    graphics.drawString(string, this.x + this.width / 2 - n / 2, this.y + this.height / 2 + n2 / 2);
                    break;
                }
                case 6: {
                    graphics.drawString(string, this.x + this.width, this.y);
                    break;
                }
                case 4: {
                    FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                    int n = fontMetrics.stringWidth(string);
                    int n3 = fontMetrics.getAscent();
                    graphics.drawString(string, this.x + this.width / 2 - n / 2, this.y + this.height + n3 + 2);
                    break;
                }
                case 3: {
                    FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
                    int n = fontMetrics.stringWidth(string);
                    graphics.drawString(string, this.x + this.width / 2 - n / 2, this.y - 2);
                    break;
                }
            }
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setSize(int n, int n2) {
        this.setDimension(n, n2);
    }

    public void setDimension(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getDimension());
    }

    public void delete() {
        this.editor.removeGObject(this);
    }

    public void reInstall(StructureEditor structureEditor) {
        this.setEditor(structureEditor);
        structureEditor.addGObject(this);
    }
}

