/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Graphics;

import SEdit.Graphics.GObject;
import SEdit.SComponent;
import SEdit.SElement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class GNode
extends GObject {
    public final int HANDLE_SIZE = 8;
    protected int selectedHandle = 0;
    final int NO_HANDLE = 0;
    final int LEFT_TOP_HANDLE = 1;
    final int RIGHT_TOP_HANDLE = 2;
    final int LEFT_BOTTOM_HANDLE = 3;
    final int RIGHT_BOTTOM_HANDLE = 4;
    final int LEFT_HANDLE = 5;
    final int TOP_HANDLE = 6;
    final int RIGHT_HANDLE = 7;
    final int BOTTOM_HANDLE = 8;
    protected boolean resizable = false;

    public int getSelectedHandle() {
        return this.selectedHandle;
    }

    public boolean getResizable() {
        return this.resizable;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public void select(boolean bl) {
        super.select(bl);
        this.selectedHandle = 0;
    }

    public void doReSelect(int n, int n2) {
        this.selectedHandle = this.getHandleNum(n, n2);
    }

    public void doDrag(int n, int n2) {
        switch (this.selectedHandle) {
            case 0: {
                this.x += n;
                this.y += n2;
                break;
            }
            case 1: {
                this.x += n;
                this.y += n2;
                this.height -= n2;
                this.width -= n;
                break;
            }
            case 2: {
                this.y += n2;
                this.height -= n2;
                this.width += n;
                break;
            }
            case 3: {
                this.x += n;
                this.height += n2;
                this.width -= n;
                break;
            }
            case 4: {
                this.height += n2;
                this.width += n;
                break;
            }
            case 5: {
                this.x += n;
                this.width -= n;
                break;
            }
            case 7: {
                this.width += n;
                break;
            }
            case 6: {
                this.y += n2;
                this.height -= n2;
                break;
            }
            case 8: {
                this.height += n2;
                break;
            }
        }
        SElement sElement = this.getSElement();
        if (sElement instanceof SComponent) {
            ((SComponent)sElement).computeConnectorsPositions();
        }
    }

    public boolean isContainedIn(Rectangle rectangle) {
        return rectangle.contains(this.x + this.width / 2, this.y + this.height / 2);
    }

    public boolean contains(Point point) {
        return new Rectangle(this.x, this.y, this.width, this.height).contains(point);
    }

    public Point intersection(Point point) {
        float f = Math.abs((float)(this.width / 2) / (float)(point.x - (this.x + this.width / 2)));
        float f2 = Math.abs((float)(this.height / 2) / (float)(point.y - (this.y + this.height / 2)));
        float f3 = Math.min(f, f2);
        Point point2 = new Point(Math.round((float)(this.x + this.width / 2) + f3 * (float)(point.x - (this.x + this.width / 2))), Math.round((float)(this.y + this.height / 2) + f3 * (float)(point.y - (this.y + this.height / 2))));
        return point2;
    }

    public void displayHandles(Graphics graphics) {
        int n = 8;
        int n2 = this.width;
        int n3 = this.height;
        if (this.getResizable()) {
            graphics.setColor(Color.blue);
            graphics.fillRect(this.x, this.y, n, n);
            graphics.fillRect(this.x + n2 - n, this.y, n, n);
            graphics.fillRect(this.x, this.y + n3 - n, n, n);
            graphics.fillRect(this.x + n2 - n, this.y + n3 - n, n, n);
            graphics.fillRect(this.x, this.y + (n3 - n) / 2, n, n);
            graphics.fillRect(this.x + (n2 - n) / 2, this.y, n, n);
            graphics.fillRect(this.x + n2 - n, this.y + (n3 - n) / 2, n, n);
            graphics.fillRect(this.x + (n2 - n) / 2, this.y + n3 - n, n, n);
        }
    }

    int getHandleNum(int n, int n2) {
        int n3 = 8;
        int n4 = this.width;
        int n5 = this.height;
        if (n >= this.x && n2 >= this.y && n <= this.x + n3 && n2 <= this.y + n3) {
            return 1;
        }
        if (n >= this.x + n4 - n3 && n2 >= this.y && n <= this.x + n4 && n2 <= this.y + n3) {
            return 2;
        }
        if (n >= this.x && n2 >= this.y + n5 - n3 && n <= this.x + n3 && n2 <= this.y + n5) {
            return 3;
        }
        if (n >= this.x + n4 - n3 && n2 >= this.y + n5 - n3 && n <= this.x + n4 && n2 <= this.y + n5) {
            return 4;
        }
        if (n >= this.x && n2 >= this.y + (n5 - n3) / 2 && n <= this.x + n3 && n2 <= this.y + n3 + (n5 - n3) / 2) {
            return 5;
        }
        if (n >= this.x + (n4 - n3) / 2 && n2 >= this.y && n <= this.x + n3 + (n4 - n3) / 2 && n2 <= this.y + n3) {
            return 6;
        }
        if (n >= this.x + n4 - n3 && n2 >= this.y + (n5 - n3) / 2 && n <= this.x + n4 && n2 <= this.y + n3 + (n5 - n3) / 2) {
            return 7;
        }
        if (n >= this.x + (n4 - n3) / 2 && n2 >= this.y + n5 - n3 && n <= this.x + n3 + (n4 - n3) / 2 && n2 <= this.y + n5) {
            return 8;
        }
        return 0;
    }
}

