/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Graphics;

import SEdit.Graphics.GNode;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import madkit.kernel.Utils;

public class GJavaComponent
extends GNode {
    JComponent comp = new JButton("Swing!!");
    public static int DEFAULT_WIDTH = 120;
    public static int DEFAULT_HEIGHT = 80;
    boolean deleted = false;
    protected String javaComponentClass = null;

    public GJavaComponent() {
        Dimension dimension = this.comp.getPreferredSize();
        if (dimension != null) {
            this.setDimension(dimension.width, dimension.height);
        }
    }

    public JComponent getComponent() {
        return this.comp;
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.comp != null) {
            this.getEditor().remove(this.comp);
        }
        super.delete();
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        if (this.comp != null) {
            this.comp.reshape(this.x, this.y, this.getWidth(), this.getHeight());
        }
    }

    public void setJavaComponentClass(String string) {
        this.javaComponentClass = string;
    }

    public String getJavaComponentClass() {
        return this.javaComponentClass;
    }

    public void init() {
        Serializable serializable;
        if (this.javaComponentClass != null) {
            try {
                serializable = Utils.loadClass((String)this.javaComponentClass);
                this.comp = (JComponent)((Class)serializable).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Class not found :" + this.javaComponentClass + " " + classNotFoundException);
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                System.err.println("Can't instanciate ! " + this.javaComponentClass + " " + instantiationException);
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("illegal access! " + this.javaComponentClass + " " + illegalAccessException);
                illegalAccessException.printStackTrace();
            }
        }
        if (this.comp != null) {
            serializable = this.getDimension();
            Dimension dimension = this.comp.getPreferredSize();
            if (this.getWidth() == 0 && this.getHeight() == 0) {
                if (dimension != null) {
                    this.comp.reshape(this.x, this.y, dimension.width, dimension.height);
                } else {
                    this.comp.reshape(this.x, this.y, DEFAULT_WIDTH, DEFAULT_HEIGHT);
                    this.setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
                }
            } else {
                this.comp.reshape(this.x, this.y, this.getWidth(), this.getHeight());
            }
            this.getEditor().add(this.comp);
        }
    }

    public void setCenter(int n, int n2) {
        super.setCenter(n, n2);
        if (this.comp != null) {
            this.comp.setLocation(this.x, this.y);
            this.comp.revalidate();
        }
    }

    public void doDrag(int n, int n2) {
        super.doDrag(n, n2);
        this.comp.setSize(this.getWidth(), this.getHeight());
        this.comp.revalidate();
    }

    public void paint(Graphics graphics) {
        Object var2_2 = null;
        if (this.comp != null) {
            this.comp.setLocation(this.x, this.y);
            this.comp.setSize(this.getWidth(), this.getHeight());
        }
        if (this.selected) {
            graphics.drawRect(this.x - 1, this.y + 1, this.width + 2, this.height + 2);
        }
    }
}

