/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Formalisms.World;

import SEdit.Formalisms.World.Brain;
import SEdit.Formalisms.World.WorldStructure;
import SEdit.SArrow;
import SEdit.SNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Utils;

public class WorldEntity
extends SNode {
    boolean deleted = false;
    Brain myBrain;
    protected String brainClass;
    protected String behaviorFileName = null;
    boolean askForDeletion = false;

    public Vector getInArrows() {
        return null;
    }

    public Vector getOutArrows() {
        return null;
    }

    protected void addOutArrow(SArrow sArrow) {
    }

    protected void addInArrow(SArrow sArrow) {
    }

    protected boolean isConnectable(SArrow sArrow, boolean bl) {
        return false;
    }

    WorldStructure getEnvironment() {
        return (WorldStructure)this.getStructure();
    }

    public Point getLocation() {
        return this.getGObject().getCenter();
    }

    public void setBrain(Brain brain) {
        this.myBrain = brain;
    }

    public Brain getBrain() {
        return this.myBrain;
    }

    public void setBrainClass(String string) {
        this.brainClass = string;
    }

    public String getBrainClass() {
        return this.brainClass;
    }

    public void setBehaviorFileName(String string) {
        this.behaviorFileName = string;
    }

    public String getBehaviorFileName() {
        return this.behaviorFileName;
    }

    public Point getPosition() {
        return this.getGObject().getCenter();
    }

    public int getDistance(WorldEntity worldEntity) {
        Point point = worldEntity.getPosition();
        Point point2 = this.getPosition();
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        return (int)Math.round(Math.sqrt(n * n + n2 * n2));
    }

    public void makeBrain(String string, String string2, boolean bl, String string3) {
        try {
            Class clazz = Utils.loadClass((String)string);
            this.myBrain = (Brain)clazz.newInstance();
            this.myBrain.setBody(this);
            if (this.myBrain instanceof AbstractAgent) {
                String string4 = string2;
                if (string4 == null) {
                    string4 = this.getLabel();
                }
                if (string4 == null) {
                    string4 = this.getID();
                }
                if (string3 != null) {
                    this.setBehaviorFileName(string3);
                }
                this.getStructure().getAgent().doLaunchAgent((AbstractAgent)this.myBrain, string4, bl);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found :" + string + " " + classNotFoundException);
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Can't instanciate ! " + string + " " + instantiationException);
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("illegal access! " + string + " " + illegalAccessException);
            illegalAccessException.printStackTrace();
        }
    }

    public void showLine(WorldEntity worldEntity, Color color) {
        Graphics graphics = this.getGObject().getEditor().getGraphics();
        Point point = this.getGObject().getCenter();
        Point point2 = worldEntity.getGObject().getCenter();
        graphics.setColor(color);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        if (this.myBrain != null) {
            if (this.myBrain instanceof AbstractAgent) {
                this.getStructure().getAgent().doKillAgent((AbstractAgent)this.myBrain);
            } else {
                this.myBrain.delete();
            }
        }
        super.delete();
    }

    public void selfDelete() {
        if (((WorldStructure)this.getStructure()).isRunning()) {
            this.askForDeletion = true;
        } else {
            this.delete();
        }
    }

    public void doIt() {
        this.beforeDoIt();
        if (this.myBrain != null) {
            this.myBrain.doIt();
        } else {
            this.bodyDoIt();
        }
        this.afterDoIt();
    }

    public void bodyDoIt() {
    }

    public void beforeDoIt() {
    }

    public void afterDoIt() {
        if (this.askForDeletion) {
            this.delete();
        }
    }

    public String toString() {
        return "a " + this.getClass().getName();
    }
}

