/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Formalisms.World;

import SEdit.Formalisms.World.Obstacle;
import SEdit.Formalisms.World.WorldEntity;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class MobileEntity
extends WorldEntity {
    public static final double convDegGrad = 0.0174533;
    public static final double convGradDeg = 57.29577951;
    public static int BOUND = 0;
    public static int WRAP = 1;
    protected int movementType = WRAP;
    private int maxSpeed;
    private int speed = this.maxSpeed = 6;
    int direction = 0;
    int detectingRange = 40;
    boolean detecting = false;
    private int randomCptMax;
    private int cpt = this.randomCptMax = 10;

    public void setMaxSpeed(int n) {
        this.maxSpeed = n;
    }

    public int getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setSpeed(int n) {
        this.speed = n <= this.maxSpeed ? this.maxSpeed : n;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDetecting(boolean bl) {
        this.detecting = bl;
    }

    public boolean isDetecting() {
        return this.detecting;
    }

    public void setDetectingRange(int n) {
        this.detectingRange = n;
    }

    public int getDetectingRange() {
        return this.detectingRange;
    }

    public void init() {
        this.setSpeed(this.getMaxSpeed());
        String string = this.getBrainClass();
        if (string != null) {
            this.makeBrain(string, null, false, this.getBehaviorFileName());
        }
    }

    void moveDir(int n, int n2) {
        Rectangle rectangle = this.getEnvironment().getWorldDimension();
        if (this.movementType == WRAP) {
            this.getGObject().translateWrap(n, n2, rectangle);
        } else if (this.movementType == BOUND) {
            this.getGObject().translateBound(n, n2, rectangle);
        } else {
            this.getGObject().translate(n, n2);
        }
    }

    public void move() {
        int n = (int)Math.round((double)this.speed * Math.cos(0.0174533 * (double)this.direction));
        int n2 = (int)Math.round((double)this.speed * Math.sin(0.0174533 * (double)this.direction));
        this.moveDir(n, n2);
    }

    public void directTowards(WorldEntity worldEntity) {
        if (worldEntity != null) {
            int n;
            this.direction = n = this.getDirectionTo(worldEntity);
        }
    }

    public int getDirectionTo(WorldEntity worldEntity) {
        if (worldEntity != null) {
            Point point = worldEntity.getGObject().getCenter();
            Point point2 = this.getGObject().getCenter();
            int n = point.y - point2.y;
            int n2 = point.x - point2.x;
            double d = Math.atan((double)n / (double)n2);
            int n3 = (int)Math.round(d * 57.29577951);
            if (n3 < 0 || n < 0) {
                n3 = n2 > 0 ? 360 + n3 : 180 + n3;
            }
            return n3;
        }
        return (int)Math.round(Math.random() * 360.0);
    }

    public int getDirectionTo(Point point) {
        Point point2 = this.getGObject().getCenter();
        int n = point.y - point2.y;
        int n2 = point.x - point2.x;
        double d = Math.atan((double)n / (double)n2);
        int n3 = (int)Math.round(d * 57.29577951);
        if (n3 < 0 || n < 0) {
            n3 = n2 > 0 ? 360 + n3 : 180 + n3;
        }
        return n3;
    }

    public int getDistanceTo(WorldEntity worldEntity) {
        if (worldEntity != null) {
            Point point = worldEntity.getGObject().getCenter();
            Point point2 = this.getGObject().getCenter();
            int n = point.x - point2.x;
            int n2 = point.y - point2.y;
            double d = Math.sqrt(n * n + n2 * n2);
            return (int)Math.round(d);
        }
        return -1;
    }

    public void moveTo(WorldEntity worldEntity) {
        this.directTowards(worldEntity);
        this.move();
    }

    public Vector detect() {
        Point point = this.getGObject().getCenter();
        return this.getEnvironment().detectEntities(this, point, this.detectingRange);
    }

    public void avoidObstacles(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                WorldEntity worldEntity = (WorldEntity)vector.elementAt(i);
                if (!(worldEntity instanceof Obstacle) && !(worldEntity instanceof MobileEntity) || !this.isTouching(worldEntity)) continue;
                this.direction = (this.direction + 180 + Math.round(10.0f)) % 360;
                return;
            }
        }
    }

    public boolean isTouching(WorldEntity worldEntity) {
        return this.getGObject().getBounds().intersects(worldEntity.getGObject().getBounds());
    }

    public void randomDir() {
        this.direction = (int)Math.round(Math.random() * 360.0);
    }

    public void setRandomCptMax(int n) {
        this.randomCptMax = n;
    }

    public void randomMove() {
        --this.cpt;
        if (this.cpt == 0) {
            this.cpt = this.randomCptMax;
            this.randomDir();
            this.move();
        } else {
            this.move();
        }
    }
}

