/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Formalisms.World.Ants;

import SEdit.Formalisms.World.Ants.AbstractAnt;
import SEdit.Formalisms.World.Ants.Home;
import SEdit.Formalisms.World.Ants.Mark;
import SEdit.Formalisms.World.Food;
import SEdit.Formalisms.World.WorldEntity;
import java.awt.Point;
import java.util.Vector;

public class MarkingAnt
extends AbstractAnt {
    int value = 0;
    int cptMarkMax;
    int cptMark = this.cptMarkMax = 10;

    void initCpt() {
        super.initCpt();
        this.value = 0;
    }

    public void bodyDoIt() {
        Vector vector = this.detect();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                WorldEntity worldEntity = (WorldEntity)vector.elementAt(i);
                if (worldEntity instanceof Food && !this.carrying) {
                    if (this.isTouching(worldEntity)) {
                        this.eat(worldEntity);
                        this.carrying = true;
                        this.initCpt();
                        return;
                    }
                    this.moveTo(worldEntity);
                    this.initCpt();
                    return;
                }
                if (!(worldEntity instanceof Home)) continue;
                if (this.getHome() == null) {
                    this.setHome(worldEntity);
                }
                if (!this.carrying) continue;
                if (this.isTouching(worldEntity)) {
                    this.carrying = false;
                    ((Home)worldEntity).addFood();
                    this.initCpt();
                    return;
                }
                this.dropMark();
                this.moveTo(worldEntity);
                return;
            }
        }
        if (this.carrying) {
            WorldEntity worldEntity = this.getHome();
            if (worldEntity != null) {
                this.dropMark();
                this.moveTo(worldEntity);
            } else {
                this.randomMove();
            }
        } else if (vector != null && this.containMarks(vector)) {
            this.followMarks(vector);
        } else {
            this.randomMove();
        }
    }

    void dropMark() {
        --this.cptMark;
        if (this.cptMark <= 0) {
            Point point = this.getLocation();
            Mark mark = (Mark)this.getStructure().createNode("Mark", point.x, point.y);
            mark.setValue(this.value++);
            this.cptMark = this.cptMarkMax;
        }
    }

    boolean containMarks(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            WorldEntity worldEntity = (WorldEntity)vector.elementAt(i);
            if (worldEntity == null || !(worldEntity instanceof Mark)) continue;
            return true;
        }
        return false;
    }

    void followMarks(Vector vector) {
        Mark mark = null;
        for (int i = 0; i < vector.size(); ++i) {
            WorldEntity worldEntity = (WorldEntity)vector.elementAt(i);
            if (!(worldEntity instanceof Mark)) continue;
            if (mark == null) {
                mark = (Mark)worldEntity;
                continue;
            }
            if (((Mark)worldEntity).getValue() >= mark.getValue()) continue;
            mark = (Mark)worldEntity;
        }
        this.moveTo(mark);
    }
}

