/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Formalisms.Petri;

import SEdit.SArrow;
import SEdit.SEditTools;
import SEdit.Scheme.STools;
import java.awt.Color;
import javax.swing.JOptionPane;

public abstract class PetriLink
extends SArrow {
    protected boolean activated = false;
    protected boolean validated = false;
    protected int weight = 1;
    protected Object filter;
    protected String filterString = null;

    public void setWeight(int n) {
        this.weight = n;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setFilter(Object object) {
        this.filter = object;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilterString(String string) {
        try {
            this.setFilter(STools.readFromString(string));
            this.filterString = string;
        }
        catch (Exception exception) {
            System.out.println(":: Erreur de saisie de filtre");
        }
    }

    public String getFilterString() {
        return this.filterString;
    }

    public static String askForNewString(String string) {
        String string2 = JOptionPane.showInputDialog(null, "Modification de : " + string, "Nouvelle valeur ", -1);
        if (string.equals(string2)) {
            return null;
        }
        return string2;
    }

    protected void active(boolean bl) {
        if (this.activated != bl) {
            this.activated = bl;
            if (this.activated) {
                this.getGObject().setForeground(Color.magenta);
            } else {
                this.getGObject().setForeground(Color.black);
            }
            this.getGObject().getEditor().repaint();
        }
    }

    protected void validate(boolean bl) {
        if (this.validated != bl) {
            this.validated = bl;
        }
    }

    public void modifyWeight() {
        String string = PetriLink.askForNewString(String.valueOf(this.weight));
        if (string != null) {
            try {
                this.setWeight(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void modifyFilter() {
        String string = this.filter != null ? STools.writeToString(this.getFilter()) : "";
        String string2 = SEditTools.editText(this.getStructure().getAgent().gui, "Editing filter", string);
        if (string2 != null) {
            this.setFilterString(string2);
            this.setLabel(string2);
            this.getGObject().setDisplayLabel(true);
        }
    }
}

