/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Formalisms.Mobile;

import SEdit.Formalisms.Mobile.MobileLink;
import SEdit.Formalisms.Mobile.MobileNode;
import SEdit.SArrow;
import SEdit.SElement;
import SEdit.Structure;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public class MobileStructure
extends Structure
implements Runnable {
    protected boolean running;
    boolean stress = false;
    boolean random = true;
    Thread relaxing = null;
    int cpt = 0;
    int relaxingTime = 120;
    Thread relaxer;

    public int getRelaxingTime() {
        return this.relaxingTime;
    }

    public void setRelaxingTime(int n) {
        this.relaxingTime = n;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.relaxing = new Thread(this);
            this.relaxing.setPriority(10);
            this.relaxing.start();
        }
    }

    public void stop() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            this.relax();
            int n = this.getNodes().size();
            try {
                Thread.sleep(this.relaxingTime);
            }
            catch (InterruptedException interruptedException) {
                this.running = false;
                break;
            }
        }
    }

    synchronized void relax() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        SElement sElement;
        Vector vector = this.getNodes();
        int n = vector.size();
        Enumeration enumeration = this.getArrows().elements();
        while (enumeration.hasMoreElements()) {
            sElement = (MobileLink)enumeration.nextElement();
            MobileNode mobileNode = (MobileNode)((SArrow)sElement).getTarget();
            MobileNode mobileNode2 = (MobileNode)((SArrow)sElement).getOrigin();
            d5 = mobileNode.getGObject().getLocation().x - mobileNode2.getGObject().getLocation().x;
            d4 = mobileNode.getGObject().getLocation().y - mobileNode2.getGObject().getLocation().y;
            d3 = Math.sqrt(d5 * d5 + d4 * d4);
            d2 = (((MobileLink)sElement).len() - d3) / (d3 * 3.0);
            d = d2 * d5;
            double d6 = d2 * d4;
            mobileNode.addDx(d);
            mobileNode.addDy(d6);
            mobileNode2.addDx(-d);
            mobileNode2.addDy(-d6);
        }
        for (int i = 0; i < n; ++i) {
            sElement = (MobileNode)vector.elementAt(i);
            double d7 = 0.0;
            d5 = 0.0;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                MobileNode mobileNode = (MobileNode)vector.elementAt(j);
                d3 = sElement.getGObject().getLocation().x - mobileNode.getGObject().getLocation().x;
                d2 = sElement.getGObject().getLocation().y - mobileNode.getGObject().getLocation().y;
                d = d3 * d3 + d2 * d2;
                if (d == 0.0) {
                    d7 += Math.random();
                    d5 += Math.random();
                    continue;
                }
                if (!(d < 90000.0)) continue;
                d7 += d3 / d;
                d5 += d2 / d;
            }
            d4 = d7 * d7 + d5 * d5;
            if (!(d4 > 0.0)) continue;
            d4 = Math.sqrt(d4) / 2.0;
            ((MobileNode)sElement).addDx(d7 / d4);
            ((MobileNode)sElement).addDy(d5 / d4);
        }
        Dimension dimension = this.getEditor().getSize();
        int n2 = dimension.width - 80;
        int n3 = dimension.height - 60;
        for (int i = 0; i < n; ++i) {
            MobileNode mobileNode = (MobileNode)vector.elementAt(i);
            if (!mobileNode.isFixed()) {
                mobileNode.getGObject().setLocation(mobileNode.getGObject().getLocation().x + (int)Math.max(-5.0, Math.min(5.0, mobileNode.getDx())), mobileNode.getGObject().getLocation().y + (int)Math.max(-5.0, Math.min(5.0, mobileNode.getDy())));
                this.normalize(mobileNode);
            }
            mobileNode.dx /= 2.0;
            mobileNode.dy /= 2.0;
        }
        this.getEditor().repaint();
    }

    public void scramble() {
        Dimension dimension = this.getEditor().getSize();
        int n = dimension.width / 2 - 80;
        int n2 = dimension.height / 2 - 60;
        for (int i = 0; i < this.getNodes().size(); ++i) {
            MobileNode mobileNode = (MobileNode)this.getNodes().elementAt(i);
            if (mobileNode.isFixed()) continue;
            mobileNode.getGObject().setLocation(10 + (int)((double)n * Math.random()), 10 + (int)((double)n * Math.random()));
            this.normalize(mobileNode);
        }
        this.getEditor().repaint();
    }

    public void shake() {
        Dimension dimension = this.getEditor().getSize();
        int n = dimension.width / 2 - 80;
        int n2 = dimension.height / 2 - 60;
        for (int i = 0; i < this.getNodes().size(); ++i) {
            MobileNode mobileNode = (MobileNode)this.getNodes().elementAt(i);
            if (mobileNode.isFixed()) continue;
            mobileNode.getGObject().setLocation(mobileNode.getGObject().getLocation().x + (int)(80.0 * Math.random() - 40.0), mobileNode.getGObject().getLocation().y + (int)(80.0 * Math.random() - 40.0));
            this.normalize(mobileNode);
        }
        this.getEditor().repaint();
    }

    public void normalize(SElement sElement) {
        Point point = sElement.getGObject().getLocation();
        if (point.x < 80) {
            point.x = 80;
        } else if (point.x > this.getEditor().getWidth()) {
            point.x = this.getEditor().getWidth();
        }
        if (point.y < 60) {
            point.y = 60;
        } else if (point.y > this.getEditor().getHeight()) {
            point.y = this.getEditor().getHeight();
        }
        sElement.getGObject().setLocation(point);
    }
}

