/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.DefaultAuthHandler;
import HTTPClient.GlobalConstants;
import HTTPClient.HashVerifier;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.MD5;
import HTTPClient.ParseException;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;

class VerifyDigest
implements HashVerifier,
GlobalConstants {
    private String HA1;
    private String nonce;
    private String method;
    private String uri;
    private String hdr;
    private RoResponse resp;

    public VerifyDigest(String string, String string2, String string3, String string4, String string5, RoResponse roResponse) {
        this.HA1 = string;
        this.nonce = string2;
        this.method = string3;
        this.uri = string4;
        this.hdr = string5;
        this.resp = roResponse;
    }

    public void verifyHash(byte[] byArray, long l) throws IOException {
        Vector vector;
        String string = this.resp.getHeader(this.hdr);
        if (string == null) {
            string = this.resp.getTrailer(this.hdr);
        }
        if (string == null) {
            return;
        }
        try {
            vector = Util.parseHeader(string);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
        HttpHeaderElement httpHeaderElement = Util.getElement(vector, "digest");
        if (httpHeaderElement == null || httpHeaderElement.getValue() == null) {
            return;
        }
        byte[] byArray2 = DefaultAuthHandler.unHex(httpHeaderElement.getValue());
        String string2 = MD5.hexDigest(this.uri + ":" + VerifyDigest.header_val("Content-Type", this.resp) + ":" + VerifyDigest.header_val("Content-Length", this.resp) + ":" + VerifyDigest.header_val("Content-Encoding", this.resp) + ":" + VerifyDigest.header_val("Last-Modified", this.resp) + ":" + VerifyDigest.header_val("Expires", this.resp));
        byArray = MD5.digest(this.HA1 + ":" + this.nonce + ":" + this.method + ":" + VerifyDigest.header_val("Date", this.resp) + ":" + string2 + ":" + MD5.toHex(byArray));
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            throw new IOException("MD5-Digest mismatch: expected " + DefaultAuthHandler.hex(byArray2) + " but calculated " + DefaultAuthHandler.hex(byArray));
        }
        Log.write(8, "Auth:  digest from " + this.hdr + " successfully verified");
    }

    private static final String header_val(String string, RoResponse roResponse) throws IOException {
        String string2 = roResponse.getHeader(string);
        String string3 = roResponse.getTrailer(string);
        return string2 != null ? string2 : (string3 != null ? string3 : "");
    }
}

