/*
 * Decompiled with CFR 0.152.
 */
package jxxload_help;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PathVFS {
    private static final Object PRESENT = new Object();
    private Vector vfs = new Vector();
    private Hashtable once = new Hashtable();

    public void addVFS(String string) {
        if (string.length() == 0) {
            if (!this.once.containsKey("")) {
                this.once.put("", PRESENT);
                this.vfs.addElement(new DirVFS(""));
            }
            return;
        }
        try {
            File file = new File(string);
            String string2 = file.getCanonicalPath().toString();
            if (!this.once.containsKey(string2)) {
                this.once.put(string2, PRESENT);
                if (file.isDirectory()) {
                    this.vfs.addElement(new DirVFS(string));
                } else if (file.exists() && (string.endsWith(".jar") || string.endsWith(".zip"))) {
                    this.vfs.addElement(new JarVFS(string));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream open(String string) {
        Enumeration enumeration = this.vfs.elements();
        while (enumeration.hasMoreElements()) {
            VFS vFS = (VFS)enumeration.nextElement();
            InputStream inputStream = vFS.open(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    public static interface VFS {
        public InputStream open(String var1);
    }

    public static class JarVFS
    implements VFS {
        private ZipFile zipfile;

        public InputStream open(String string) {
            ZipEntry zipEntry = this.zipfile.getEntry(string);
            if (zipEntry == null) {
                return null;
            }
            try {
                return this.zipfile.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public JarVFS(String string) throws IOException {
            this.zipfile = new ZipFile(string);
        }
    }

    public static class DirVFS
    implements VFS {
        private String prefix;

        public InputStream open(String string) {
            File file = new File(this.prefix, string.replace('/', File.separatorChar));
            if (file.isFile()) {
                try {
                    return new BufferedInputStream(new FileInputStream(file));
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return null;
        }

        public DirVFS(String string) {
            this.prefix = string.length() == 0 ? null : string;
        }
    }
}

