/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import madkit.kernel.SiteAgent;
import madkit.kernel.SitesTableModel;

final class siteAgentGUI
extends JPanel
implements ItemListener {
    SiteAgent myAgent;

    siteAgentGUI(SiteAgent siteAgent) {
        this.setSize(200, 300);
        this.myAgent = siteAgent;
        this.refreshCommunities();
    }

    void refreshCommunities() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        String[] stringArray = this.myAgent.getCommunities();
        Object[][] objectArray = new Object[stringArray.length][2];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i][0] = stringArray[i];
            objectArray[i][1] = new Boolean(this.myAgent.connectedWith(stringArray[i]));
        }
        SitesTableModel sitesTableModel = new SitesTableModel(this, objectArray);
        JTable jTable = new JTable(sitesTableModel);
        jTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add((Component)jScrollPane, "Center");
        this.add("North", new JLabel("Available communities"));
        this.validate();
    }

    void communityChange(boolean bl, String string) {
        if (bl) {
            this.myAgent.joinCommunity(string);
        } else {
            this.myAgent.leaveCommunity(string);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemEvent.getStateChange() == 2) {
            this.myAgent.leaveCommunity(((JCheckBox)itemSelectable).getText());
        } else {
            this.myAgent.joinCommunity(((JCheckBox)itemSelectable).getText());
        }
    }
}

