/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import madkit.kernel.AGRTrio;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentInformation;
import madkit.kernel.Kernel;
import madkit.kernel.KernelMessage;
import madkit.kernel.Message;
import madkit.kernel.Organization;
import madkit.kernel.SiteAgent;

final class KernelAgent
extends Agent {
    private Collection distantKernels;
    private Collection[] monitor_hooks = new Collection[13];
    private AgentAddress myCommunicator = null;
    Organization localOrg;
    SiteAgent siteAgent;

    KernelAgent() {
        for (int i = 0; i < 13; ++i) {
            this.monitor_hooks[i] = new HashSet(7);
        }
    }

    public final void activate() {
        this.requestRole("system", "kernel", null);
        this.pause(100);
    }

    public final void live() {
        while (true) {
            Message message = this.waitNextMessage();
            this.handleMessage(message);
        }
    }

    public void end() {
        System.err.println("KERNEL AGENT KILLED !!!!!!!!!!!!!");
        System.err.println("UNSTABLE SYSTEM ....");
    }

    private final void handleMessage(Message message) {
        if (message instanceof KernelMessage) {
            KernelMessage kernelMessage = (KernelMessage)message;
            switch (kernelMessage.getType()) {
                case 14: {
                    this.invokeKernelOperation(kernelMessage);
                    break;
                }
                default: {
                    this.manageHooks(kernelMessage);
                }
            }
        }
    }

    protected final void invokeKernelOperation(KernelMessage kernelMessage) {
        switch (kernelMessage.getOperation()) {
            case 23: {
                AgentAddress agentAddress = (AgentAddress)kernelMessage.getArgument();
                AbstractAgent abstractAgent = Kernel.getReference(agentAddress);
                AgentInformation agentInformation = null;
                if (abstractAgent != null) {
                    agentInformation = abstractAgent.getAgentInformation();
                }
                this.sendMessage(kernelMessage.getSender(), new KernelMessage(13, kernelMessage.getOperation(), agentInformation));
                break;
            }
            case 20: {
                this.sendMessage(kernelMessage.getSender(), new KernelMessage(13, kernelMessage.getOperation(), this.localOrg.getGroups()));
                break;
            }
            case 22: {
                this.sendMessage(kernelMessage.getSender(), new KernelMessage(13, kernelMessage.getOperation(), this.localOrg.getLocalOrganization()));
                break;
            }
            case 27: {
                this.sendMessage(kernelMessage.getSender(), new KernelMessage(13, kernelMessage.getOperation(), this.getCurrentKernel().getDumpCommunities()));
                break;
            }
            case 21: {
                AgentAddress agentAddress = kernelMessage.getSender();
                int n = kernelMessage.getOperation();
                this.getCurrentKernel();
                this.sendMessage(agentAddress, new KernelMessage(13, n, Kernel.getLocalAgents()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void manageHooks(KernelMessage kernelMessage) {
        if (kernelMessage.getOperation() >= 13) return;
        switch (kernelMessage.getType()) {
            case 22: {
                if (this.getDebug()) {
                    this.println("Adding hook:" + kernelMessage.getOperation() + " for " + kernelMessage.getSender());
                }
                Collection[] collectionArray = this.monitor_hooks;
                synchronized (this.monitor_hooks) {
                    this.monitor_hooks[kernelMessage.getOperation()].add(kernelMessage.getSender());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            case 23: {
                if (this.getDebug()) {
                    this.println("Removing hook:" + kernelMessage.getOperation() + " for " + kernelMessage.getSender());
                }
                Collection[] collectionArray = this.monitor_hooks;
                synchronized (this.monitor_hooks) {
                    this.monitor_hooks[kernelMessage.getOperation()].remove(kernelMessage.getSender());
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void callHooks(int n, Object object) {
        this.debug("hook called : hook's code is : " + n + " " + object);
        Vector vector = new Vector();
        Object object2 = this.monitor_hooks;
        synchronized (this.monitor_hooks) {
            vector.addAll(this.monitor_hooks[n]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (vector.size() > 0) {
                object2 = vector.iterator();
                while (object2.hasNext()) {
                    this.sendMessage((AgentAddress)object2.next(), new KernelMessage(15, n, object));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void callHooks(int n, AgentAddress agentAddress, String string, String string2, String string3) {
        this.debug("hook called : hook's code is : " + n + " " + agentAddress + " " + string + " " + string2 + " " + string3);
        Vector vector = new Vector();
        Object object = this.monitor_hooks;
        synchronized (this.monitor_hooks) {
            vector.addAll(this.monitor_hooks[n]);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (vector.size() > 0) {
                object = vector.iterator();
                while (object.hasNext()) {
                    this.sendMessage((AgentAddress)object.next(), new KernelMessage(15, n, new AGRTrio(agentAddress, string, string2, string3)));
                }
            }
            return;
        }
    }
}

