/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.util.NoSuchElementException;
import madkit.kernel.KernelAddress;

public class AgentAddress
implements Serializable {
    private static final String MADKIT_PROTOCOL = "mka";
    private static int agentCounter = 0;
    private String protocol;
    private String name;
    private int localID;
    private KernelAddress kernel;

    public AgentAddress(String string, KernelAddress kernelAddress) {
        this.protocol = MADKIT_PROTOCOL;
        this.name = string;
        this.localID = ++agentCounter;
        this.kernel = kernelAddress;
    }

    public AgentAddress(String string) {
        try {
            int n = string.indexOf(":");
            this.protocol = string.substring(0, n);
            if (!this.protocol.equals(MADKIT_PROTOCOL) && !this.protocol.equals("request")) {
                throw new NoSuchElementException("invalid protocol:" + this.protocol);
            }
            string = string.substring(n + 1);
            n = string.indexOf(",");
            this.name = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf("@");
            this.localID = Integer.parseInt(string.substring(0, n));
            this.kernel = new KernelAddress(string.substring(n + 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.name + "," + this.localID + "@" + this.kernel.shortString();
    }

    public boolean isLocal() {
        return this.kernel.isLocal();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AgentAddress) {
            AgentAddress agentAddress = (AgentAddress)object;
            return this.kernel.equals(agentAddress.getKernel()) && this.localID == agentAddress.localID && this.protocol.equals(agentAddress.protocol);
        }
        return false;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public int getLocalID() {
        return this.localID;
    }

    public KernelAddress getKernel() {
        return this.kernel;
    }

    public int hashCode() {
        return (this.localID + this.kernel.toString()).hashCode();
    }

    void update(KernelAddress kernelAddress) {
        this.localID = ++agentCounter;
        this.kernel = kernelAddress;
    }

    void update(AgentAddress agentAddress) {
        this.localID = agentAddress.getLocalID();
        this.protocol = new String(agentAddress.getProtocol());
        this.name = new String(agentAddress.getName());
        this.kernel = agentAddress.getKernel();
    }

    static final synchronized int getAgentCounter() {
        return agentCounter;
    }
}

