/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class ClassFactory {
    private static final transient Logger LOG = Logger.getLogger((String)ClassFactory.class.getName());

    protected ClassFactory() {
    }

    protected abstract Map getAssocTable();

    protected abstract Class getClassForKey();

    public Iterator getAvailableKeys() {
        return Collections.unmodifiableSet(this.getAssocTable().keySet()).iterator();
    }

    public Set getEntrySet() {
        return Collections.unmodifiableSet(this.getAssocTable().entrySet());
    }

    protected abstract Class getClassOfInstantiators();

    protected boolean registerFromResources(String resourceName, String propertyName) throws MissingResourceException {
        ResourceBundle jxtaRsrcs = ResourceBundle.getBundle(resourceName);
        String fromProps = jxtaRsrcs.getString(propertyName).trim();
        return this.registerFromString(fromProps);
    }

    protected boolean registerFromString(String classNamesString) {
        boolean registeredSomething = false;
        if (null == classNamesString || 0 == classNamesString.length()) {
            return false;
        }
        StringTokenizer eachInstanceClass = new StringTokenizer(classNamesString);
        while (eachInstanceClass.hasMoreTokens()) {
            String willInitialize = eachInstanceClass.nextToken();
            try {
                registeredSomething |= this.registerAssoc(willInitialize);
            }
            catch (Exception allElse) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Failed to register '" + willInitialize + "'"), (Throwable)allElse);
            }
        }
        return registeredSomething;
    }

    protected boolean registerAssoc(String className) throws Exception {
        boolean registeredSomething;
        block4: {
            registeredSomething = false;
            try {
                Class<?> ignored = Class.forName(className);
                registeredSomething = true;
            }
            catch (ClassNotFoundException ignored) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Failed to locate '" + className + "'"));
                }
            }
            catch (NoClassDefFoundError ignored) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                LOG.warn((Object)("Failed to locate '" + className + "'"));
            }
        }
        return registeredSomething;
    }

    protected boolean registerAssoc(Object key, Object instantiator) {
        Class<?> itsA;
        if (!this.getClassOfInstantiators().isInstance(instantiator)) {
            throw new ClassCastException("instantiator '" + instantiator.getClass().getName() + "' does not implement '" + this.getClassOfInstantiators().getName() + "'");
        }
        Class requiredKeyClass = this.getClassForKey();
        if (!requiredKeyClass.isAssignableFrom(itsA = key.getClass())) {
            throw new IllegalArgumentException("Incorrect Class for key type");
        }
        if (null != this.getAssocTable().get(key)) {
            return false;
        }
        this.getAssocTable().put(key, instantiator);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Factory : " + this.getClass().getName() + " Registered instantiator '" + instantiator + "' for '" + key + "'"));
        }
        return true;
    }

    protected Object getInstantiator(Object key) throws NoSuchElementException {
        Class requiredKeyClass = this.getClassForKey();
        if (!requiredKeyClass.isAssignableFrom(key.getClass())) {
            throw new IllegalArgumentException("Incorrect Class for key type");
        }
        Object instantiator = this.getAssocTable().get(key);
        if (null == instantiator) {
            throw new NoSuchElementException("key '" + key + "' not registered.");
        }
        return instantiator;
    }
}

