/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.jxta.util.SimpleSelectable;
import net.jxta.util.SimpleSelector;

public abstract class AbstractSimpleSelectable
implements SimpleSelectable {
    public final SimpleSelectable.IdentityReference identityReference = new SimpleSelectable.IdentityReference(this);
    private final SimpleSelectable srcObject;
    private Map myListeners = Collections.synchronizedMap(new WeakHashMap(2));

    public SimpleSelectable.IdentityReference getIdentityReference() {
        return this.identityReference;
    }

    public AbstractSimpleSelectable() {
        this.srcObject = this;
    }

    public AbstractSimpleSelectable(SimpleSelectable srcObject) {
        this.srcObject = srcObject;
    }

    protected boolean haveListeners() {
        return !this.myListeners.isEmpty();
    }

    protected void registerListener(SimpleSelectable selectable) {
        this.myListeners.put(selectable, null);
    }

    protected void unregisterListener(SimpleSelectable selectable) {
        this.myListeners.remove(selectable);
    }

    public void register(SimpleSelector s) {
        this.registerListener(s);
        s.itemChanged(this);
    }

    public void unregister(SimpleSelector s) {
        this.unregisterListener(s);
    }

    protected final boolean notifyChange() {
        SimpleSelectable[] listeners = this.myListeners.keySet().toArray(new SimpleSelectable[0]);
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].itemChanged(this.srcObject);
        }
        return listeners.length > 0;
    }
}

