/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class PeerAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private static final Logger LOG = Logger.getLogger((String)PeerAdvertisement.class.getName());
    private PeerID pid = null;
    private PeerGroupID gid = null;
    private String name = null;
    private Element description = null;
    private Hashtable serviceParams = new Hashtable();
    protected volatile int modCount = 0;

    public int getModCount() {
        return this.modCount;
    }

    protected int incModCount() {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            Throwable trace = new Throwable("Stack Trace");
            StackTraceElement[] elements = trace.getStackTrace();
            LOG.debug((Object)("Modification #" + (this.modCount + 1) + " to PeerAdv@" + Integer.toHexString(System.identityHashCode(this)) + " caused by : " + "\n\t" + elements[1] + "\n\t" + elements[2]));
        }
        return this.modCount++;
    }

    public static String getAdvertisementType() {
        return "jxta:PA";
    }

    public final String getBaseAdvType() {
        return PeerAdvertisement.getAdvertisementType();
    }

    public Object clone() {
        try {
            PeerAdvertisement result = (PeerAdvertisement)super.clone();
            result.serviceParams = (Hashtable)this.serviceParams.clone();
            return result;
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.incModCount();
    }

    public PeerID getPeerID() {
        return this.pid;
    }

    public void setPeerID(PeerID pid) {
        this.pid = pid;
        this.incModCount();
    }

    public PeerGroupID getPeerGroupID() {
        return this.gid;
    }

    public void setPeerGroupID(PeerGroupID gid) {
        this.gid = gid;
        this.incModCount();
    }

    public ID getID() {
        String peer;
        if (this.gid == null || this.pid == null) {
            return null;
        }
        if (this.gid.equals(PeerGroupID.defaultNetPeerGroupID) || this.gid.equals(PeerGroupID.worldPeerGroupID)) {
            peer = this.pid.getUniqueValue().toString();
        } else {
            String grp = this.gid.getUniqueValue().toString();
            grp = grp.substring(0, grp.length() - 2);
            peer = this.pid.getUniqueValue().toString();
            peer = grp + peer.substring(grp.length());
        }
        try {
            return IDFactory.fromURI(new URI("urn:jxta:" + peer));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String getDescription() {
        if (null != this.description) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Desc", description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
        this.incModCount();
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
        this.incModCount();
    }

    public void setServiceParams(Hashtable params) {
        this.incModCount();
        if (params == null) {
            this.serviceParams = new Hashtable();
            return;
        }
        Hashtable<ID, StructuredDocument> copy = new Hashtable<ID, StructuredDocument>();
        Enumeration keys = params.keys();
        while (keys.hasMoreElements()) {
            ID key = (ID)keys.nextElement();
            Element e = (Element)params.get(key);
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            copy.put(key, newDoc);
        }
        this.serviceParams = copy;
    }

    public Hashtable getServiceParams() {
        Hashtable<ID, StructuredDocument> copy = new Hashtable<ID, StructuredDocument>();
        Enumeration keys = this.serviceParams.keys();
        while (keys.hasMoreElements()) {
            ID key = (ID)keys.nextElement();
            Element e = (Element)this.serviceParams.get(key);
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            copy.put(key, newDoc);
        }
        return copy;
    }

    public void putServiceParam(ID key, Element param) {
        this.incModCount();
        if (param == null) {
            this.serviceParams.remove(key);
            return;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        this.serviceParams.put(key, newDoc);
    }

    public StructuredDocument getServiceParam(ID key) {
        Element param = (Element)this.serviceParams.get(key);
        if (param == null) {
            return null;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        return newDoc;
    }

    public StructuredDocument removeServiceParam(ID key) {
        Element param = (Element)this.serviceParams.remove(key);
        if (param == null) {
            return null;
        }
        this.incModCount();
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        return newDoc;
    }
}

