/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class ConfigParams
extends ExtendableAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)ConfigParams.class.getName());
    private static final String SVC_TAG = "Svc";
    private static final String MCID_TAG = "MCID";
    private static final String PARAM_TAG = "Parm";
    private Map params = new HashMap();
    protected volatile transient int modCount = 0;

    public int getModCount() {
        return this.modCount;
    }

    protected synchronized int incModCount() {
        return this.modCount++;
    }

    public static String getAdvertisementType() {
        return "jxta:CP";
    }

    public final String getBaseAdvType() {
        return ConfigParams.getAdvertisementType();
    }

    public void putServiceParam(ID key, Element param) {
        this.incModCount();
        if (param == null) {
            this.params.remove(key);
            return;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        this.params.put(key, newDoc);
    }

    public StructuredDocument getServiceParam(ID key) {
        Element param = (Element)this.params.get(key);
        if (param == null) {
            return null;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        return newDoc;
    }

    public StructuredDocument removeServiceParam(ID key) {
        Element param = (Element)this.params.remove(key);
        if (param == null) {
            return null;
        }
        this.incModCount();
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        return newDoc;
    }

    public Set getServiceParamsEntrySet() {
        return Collections.unmodifiableSet(this.params.entrySet());
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(SVC_TAG)) {
            Enumeration elems = elem.getChildren();
            ID classID = null;
            XMLElement param = null;
            while (elems.hasMoreElements()) {
                XMLElement e = (XMLElement)elems.nextElement();
                if (e.getName().equals(MCID_TAG)) {
                    try {
                        URI mcid = new URI(e.getTextValue());
                        classID = IDFactory.fromURI(mcid);
                        continue;
                    }
                    catch (URISyntaxException badID) {
                        throw new IllegalArgumentException("Bad ModuleClassID in advertisement: " + e.getTextValue());
                    }
                }
                if (!e.getName().equals(PARAM_TAG)) continue;
                param = e;
            }
            if (classID == null || param == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Incomplete Service Param : id=" + classID + " param=" + param));
                }
                return false;
            }
            this.putServiceParam(classID, param);
            return true;
        }
        return false;
    }

    public boolean addDocumentElements(StructuredDocument adv) {
        Iterator eachParam = this.getServiceParamsEntrySet().iterator();
        if (!eachParam.hasNext()) {
            return false;
        }
        while (eachParam.hasNext()) {
            Map.Entry anEntry = (Map.Entry)eachParam.next();
            ID anID = (ID)anEntry.getKey();
            StructuredDocument aDoc = (StructuredDocument)anEntry.getValue();
            Element s = adv.createElement(SVC_TAG);
            adv.appendChild(s);
            Element e = adv.createElement(MCID_TAG, anID.toString());
            s.appendChild(e);
            StructuredDocumentUtils.copyElements(adv, s, aDoc, PARAM_TAG);
        }
        return true;
    }
}

