/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.peer.PeerID;

public abstract class AccessPointAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private PeerID pid = null;
    private Vector endpointAddresses = new Vector();

    public Object clone() {
        AccessPointAdvertisement a;
        try {
            a = (AccessPointAdvertisement)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
        a.endpointAddresses = (Vector)this.endpointAddresses.clone();
        return a;
    }

    public static String getAdvertisementType() {
        return "jxta:APA";
    }

    public final String getAdvBaseType() {
        return AccessPointAdvertisement.getAdvertisementType();
    }

    public PeerID getPeerID() {
        return this.pid;
    }

    public void setPeerID(PeerID pid) {
        this.pid = pid;
    }

    public Enumeration getEndpointAddresses() {
        return this.endpointAddresses.elements();
    }

    public Vector getVectorEndpointAddresses() {
        return this.endpointAddresses;
    }

    public void setEndpointAddresses(Vector addresses) {
        this.endpointAddresses = addresses;
    }

    public void addEndpointAddresses(Vector addresses) {
        this.endpointAddresses.addAll(addresses);
    }

    public void addEndpointAddress(String address) {
        this.endpointAddresses.add(address);
    }

    public void removeEndpointAddresses(Vector addresses) {
        this.endpointAddresses.removeAll(addresses);
    }

    public boolean contains(EndpointAddress addr) {
        return this.endpointAddresses.contains(addr.toString());
    }

    public String display() {
        StringBuffer routeBuf = new StringBuffer();
        routeBuf.append("PID=");
        PeerID peerId = this.getPeerID();
        if (peerId == null) {
            routeBuf.append("Null Destination");
        } else {
            routeBuf.append(peerId.toString());
        }
        Enumeration e = this.getEndpointAddresses();
        while (e.hasMoreElements()) {
            routeBuf.append("\n Addr=" + (String)e.nextElement());
        }
        return routeBuf.toString();
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target == null) {
            return false;
        }
        AccessPointAdvertisement ap = null;
        try {
            ap = (AccessPointAdvertisement)target;
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (!this.getPeerID().equals(ap.getPeerID())) {
            return false;
        }
        Vector ad = ap.getVectorEndpointAddresses();
        if (ad == null && this.endpointAddresses == null) {
            return true;
        }
        if (ad == null || this.endpointAddresses == null) {
            return false;
        }
        if (ad.size() != this.endpointAddresses.size()) {
            return false;
        }
        for (int index = 0; index < ad.size(); ++index) {
            if (((String)ad.elementAt(index)).equals((String)this.endpointAddresses.elementAt(index))) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.endpointAddresses.size();
    }
}

