/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.meter;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaException;
import net.jxta.id.ID;
import net.jxta.meter.MonitorFilterException;
import net.jxta.meter.ServiceMetric;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.util.AdvertisementUtilities;
import net.jxta.util.JxtaUtilities;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;

public class MonitorResources {
    public static final String SERVICE_MONITOR_TAG = "serviceMonitor";
    public static final String SERVICE_MONITOR_ADVERTISEMENT_TAG = ModuleImplAdvertisement.getAdvertisementType();
    public static final String CLASS_ID_TAG = "moduleClassID";
    public static final String SERVICE_TITLE_TAG = "serviceTitle";
    public static final String SERVICE_MONITOR_IMPL_TAG = "serviceMonitorImpl";
    public static final String METRIC_CLASS_TAG = "serviceMetric";
    public static final String FILTER_CLASS_TAG = "serviceMonitorFilter";
    private static Hashtable registeredMonitorResources = new Hashtable();
    public static final ModuleClassID monitorServiceClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000011F05");
    public static final ModuleClassID resolverServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010205");
    public static final ModuleClassID discoveryServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010305");
    public static final ModuleClassID pipeServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010405");
    public static final ModuleClassID membershipServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010505");
    public static final ModuleClassID rendezvousServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010605");
    public static final ModuleClassID peerinfoServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010705");
    public static final ModuleClassID endpointServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010805");
    public static final ModuleClassID transportServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010905");
    public static final ModuleClassID routerServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010B05");
    public static final ModuleClassID tlsProtoServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010D05");
    public static final ModuleClassID proxyServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010E05");
    public static final ModuleClassID relayServiceMonitorClassID = (ModuleClassID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010F05");
    public static final ModuleSpecID refMonitorServiceSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000011F0106");
    public static final ModuleSpecID refResolverServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe000001020106");
    public static final ModuleSpecID refDiscoveryServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe000001030106");
    public static final ModuleSpecID refPipeServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe000001040106");
    public static final ModuleSpecID refMembershipServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe000001050106");
    public static final ModuleSpecID refRendezvousServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe000001060106");
    public static final ModuleSpecID refPeerinfoServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe000001070106");
    public static final ModuleSpecID refEndpointServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe000001080106");
    public static final ModuleSpecID refTransportServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe000001090106");
    public static final ModuleSpecID refRouterServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010B0106");
    public static final ModuleSpecID refTlsServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010D0106");
    public static final ModuleSpecID refProxyServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010E0106");
    public static final ModuleSpecID refRelayServiceMonitorSpecID = (ModuleSpecID)MonitorResources.getIdFromString("DeadBeefDeafBabaFeedBabe0000010F0106");
    private static ModuleClassID[] standardServiceMonitorClassIDs = new ModuleClassID[]{resolverServiceMonitorClassID, rendezvousServiceMonitorClassID, endpointServiceMonitorClassID, transportServiceMonitorClassID};
    static /* synthetic */ Class class$net$jxta$meter$ServiceMonitorFilter;
    static /* synthetic */ Class class$net$jxta$meter$ServiceMetric;

    private static ID getIdFromString(String idText) {
        try {
            return JxtaUtilities.getIdFromString("urn", "", "jxta:uuid-" + idText);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ModuleImplAdvertisement getReferenceAllPurposeMonitorServiceImplAdvertisement(boolean includeTransports) {
        ModuleImplAdvertisement moduleImplAdvertisement = AdvertisementUtilities.createModuleImplAdvertisement(refMonitorServiceSpecID, "net.jxta.impl.meter.MonitorManager", "Service Monitor");
        StructuredTextDocument param = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, SERVICE_MONITOR_TAG);
        MonitorResources.addServiceMonitorServiceAdvertisement(param, refResolverServiceMonitorSpecID, "Resolver", "net.jxta.impl.resolver.resolverMeter.ResolverServiceMonitor", "net.jxta.impl.resolver.resolverMeter.ResolverServiceMetric", "net.jxta.impl.resolver.resolverMeter.ResolverServiceMonitorFilter");
        MonitorResources.addServiceMonitorServiceAdvertisement(param, refEndpointServiceMonitorSpecID, "Endpoint", "net.jxta.impl.endpoint.endpointMeter.EndpointServiceMonitor", "net.jxta.impl.endpoint.endpointMeter.EndpointServiceMetric", "net.jxta.impl.endpoint.endpointMeter.EndpointServiceMonitorFilter");
        MonitorResources.addServiceMonitorServiceAdvertisement(param, refTransportServiceMonitorSpecID, "Transport", "net.jxta.impl.endpoint.transportMeter.TransportServiceMonitor", "net.jxta.impl.endpoint.transportMeter.TransportServiceMetric", "net.jxta.impl.endpoint.transportMeter.TransportServiceMonitorFilter");
        MonitorResources.addServiceMonitorServiceAdvertisement(param, refRendezvousServiceMonitorSpecID, "Rendezvous", "net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitor", "net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMetric", "net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitorFilter");
        moduleImplAdvertisement.setParam(param);
        return moduleImplAdvertisement;
    }

    private static void addServiceMonitorServiceAdvertisement(Element root, ModuleSpecID moduleSpecID, String title, String implClassName, String metricClassName, String filterClassName) {
        ModuleImplAdvertisement moduleImplAdvertisement = MonitorResources.createServiceMonitorModuleImplAdvertisement(moduleSpecID, title, implClassName, metricClassName, filterClassName);
        Element serviceMonitorElement = DocumentSerializableUtilities.createChildElement(root, SERVICE_MONITOR_TAG);
        ModuleClassID moduleClassID = moduleSpecID.getBaseClass();
        DocumentSerializableUtilities.addString(serviceMonitorElement, CLASS_ID_TAG, moduleClassID.toString());
        Element serviceMonitorAdvertisementElement = DocumentSerializableUtilities.createChildElement(serviceMonitorElement, SERVICE_MONITOR_ADVERTISEMENT_TAG);
        Element advDoc = (Element)((Object)moduleImplAdvertisement.getDocument(MimeMediaType.XMLUTF8));
        DocumentSerializableUtilities.copyChildren(serviceMonitorAdvertisementElement, advDoc);
    }

    public static ModuleImplAdvertisement createServiceMonitorModuleImplAdvertisement(ModuleSpecID moduleSpecID, String title, String implClassName, String metricClassName, String filterClassName) {
        ModuleImplAdvertisement moduleImplAdvertisement = AdvertisementUtilities.createModuleImplAdvertisement(moduleSpecID, implClassName, "Service Monitor");
        StructuredTextDocument param = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, SERVICE_MONITOR_TAG);
        DocumentSerializableUtilities.addString(param, SERVICE_TITLE_TAG, title);
        DocumentSerializableUtilities.addString(param, METRIC_CLASS_TAG, metricClassName);
        DocumentSerializableUtilities.addString(param, FILTER_CLASS_TAG, filterClassName);
        moduleImplAdvertisement.setParam(param);
        return moduleImplAdvertisement;
    }

    public static ModuleImplAdvertisement getServiceMonitorImplAdvertisement(ModuleClassID serviceMonitorModuleClassID, ModuleImplAdvertisement monitorServiceImplAdvertisement) {
        String classIDText = serviceMonitorModuleClassID.toString();
        StructuredDocument param = monitorServiceImplAdvertisement.getParam();
        Enumeration e = param.getChildren(SERVICE_MONITOR_TAG);
        while (e.hasMoreElements()) {
            Element serviceMonitorElement = (Element)e.nextElement();
            String serviceMonitorClassIDText = DocumentSerializableUtilities.getString(serviceMonitorElement, CLASS_ID_TAG, "");
            if (!classIDText.equals(serviceMonitorClassIDText)) continue;
            TextElement serviceMonitorAdvertisementElement = (TextElement)DocumentSerializableUtilities.getChildElement(serviceMonitorElement, SERVICE_MONITOR_ADVERTISEMENT_TAG);
            return (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(serviceMonitorAdvertisementElement);
        }
        return null;
    }

    public static void registerServiceMonitorModuleImplAdvertisement(ModuleImplAdvertisement moduleImplAdvertisement) throws JxtaException {
        ModuleClassID moduleClassID = moduleImplAdvertisement.getModuleSpecID().getBaseClass();
        if (registeredMonitorResources.get(moduleClassID) != null) {
            return;
        }
        registeredMonitorResources.put(moduleClassID, new ServiceResource(moduleImplAdvertisement));
    }

    public static ServiceMonitorFilter createServiceMonitorFilter(ModuleClassID moduleClassID) throws MonitorFilterException {
        try {
            ServiceResource serviceResource = (ServiceResource)registeredMonitorResources.get(moduleClassID);
            ServiceMonitorFilter serviceMonitorFilter = (ServiceMonitorFilter)serviceResource.serviceMonitorFilterClass.newInstance();
            serviceMonitorFilter.init(moduleClassID);
            return serviceMonitorFilter;
        }
        catch (Exception e) {
            throw new MonitorFilterException("Unable to Create Filter: " + moduleClassID);
        }
    }

    public static ServiceMetric createServiceMetric(ModuleClassID moduleClassID) throws JxtaException {
        try {
            ServiceResource serviceResource = (ServiceResource)registeredMonitorResources.get(moduleClassID);
            ServiceMetric serviceMetric = (ServiceMetric)serviceResource.serviceMetricClass.newInstance();
            serviceMetric.init(moduleClassID);
            return serviceMetric;
        }
        catch (Exception e) {
            throw new JxtaException("Unable to Create Service Metric");
        }
    }

    public static String getServiceMetricClassName(ModuleImplAdvertisement serviceMonitorModuleImplAdvertisement) {
        StructuredDocument param = serviceMonitorModuleImplAdvertisement.getParam();
        return DocumentSerializableUtilities.getString(param, METRIC_CLASS_TAG, null);
    }

    public static String getServiceMonitorFilterClassName(ModuleImplAdvertisement serviceMonitorModuleImplAdvertisement) {
        StructuredDocument param = serviceMonitorModuleImplAdvertisement.getParam();
        return DocumentSerializableUtilities.getString(param, FILTER_CLASS_TAG, null);
    }

    public static ModuleClassID[] getRegisteredModuleClassIDs() {
        return (ModuleClassID[])standardServiceMonitorClassIDs.clone();
    }

    public static String getMonitorTypeName(ModuleClassID moduleClassID) {
        if (moduleClassID.equals(monitorServiceClassID)) {
            return "monitor";
        }
        if (moduleClassID.equals(resolverServiceMonitorClassID)) {
            return "Resolver";
        }
        if (moduleClassID.equals(discoveryServiceMonitorClassID)) {
            return "Discovery";
        }
        if (moduleClassID.equals(pipeServiceMonitorClassID)) {
            return "Pipe";
        }
        if (moduleClassID.equals(membershipServiceMonitorClassID)) {
            return "Membership";
        }
        if (moduleClassID.equals(rendezvousServiceMonitorClassID)) {
            return "Rendezvous";
        }
        if (moduleClassID.equals(peerinfoServiceMonitorClassID)) {
            return "PeerInfo";
        }
        if (moduleClassID.equals(endpointServiceMonitorClassID)) {
            return "Endpoint";
        }
        if (moduleClassID.equals(transportServiceMonitorClassID)) {
            return "Transport";
        }
        if (moduleClassID.equals(routerServiceMonitorClassID)) {
            return "monitor";
        }
        if (moduleClassID.equals(tlsProtoServiceMonitorClassID)) {
            return "TlsPrototype";
        }
        if (moduleClassID.equals(proxyServiceMonitorClassID)) {
            return "Proxy";
        }
        if (moduleClassID.equals(relayServiceMonitorClassID)) {
            return "Relay";
        }
        return null;
    }

    private static class ServiceResource {
        String serviceMonitorClassName;
        Class serviceMonitorClass;
        String serviceMonitorFilterClassName;
        Class serviceMonitorFilterClass;
        String serviceMetricClassName;
        Class serviceMetricClass;

        ServiceResource(ModuleImplAdvertisement moduleImplAdvertisement) throws JxtaException {
            try {
                this.serviceMonitorClassName = moduleImplAdvertisement.getCode();
                this.serviceMonitorFilterClassName = MonitorResources.getServiceMonitorFilterClassName(moduleImplAdvertisement);
                this.serviceMonitorFilterClass = Class.forName(this.serviceMonitorFilterClassName);
                if (!(class$net$jxta$meter$ServiceMonitorFilter == null ? (class$net$jxta$meter$ServiceMonitorFilter = MonitorResources.class$("net.jxta.meter.ServiceMonitorFilter")) : class$net$jxta$meter$ServiceMonitorFilter).isAssignableFrom(this.serviceMonitorFilterClass)) {
                    throw new JxtaException("Bad ServiceMonitorImplAdvertisment: " + this.serviceMonitorFilterClassName + " is not a ServiceMonitorFilter");
                }
                this.serviceMetricClassName = MonitorResources.getServiceMetricClassName(moduleImplAdvertisement);
                this.serviceMetricClass = Class.forName(this.serviceMetricClassName);
                if (!(class$net$jxta$meter$ServiceMetric == null ? (class$net$jxta$meter$ServiceMetric = MonitorResources.class$("net.jxta.meter.ServiceMetric")) : class$net$jxta$meter$ServiceMetric).isAssignableFrom(this.serviceMetricClass)) {
                    throw new JxtaException("Bad ServiceMonitorImplAdvertisment: " + this.serviceMetricClassName + " is not a ServiceMetric");
                }
            }
            catch (Exception e) {
                throw new JxtaException("Bad ServiceMonitorImplAdvertisment: Unable to load constituent parts", e);
            }
        }
    }
}

