/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.meter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaException;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMetric;
import net.jxta.platform.ModuleClassID;
import net.jxta.util.JxtaUtilities;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class MonitorReport
implements DocumentSerializable {
    private long toTime;
    private long fromTime;
    private boolean isCumulative;
    private HashMap serviceMetrics = new HashMap();
    private LinkedList unknownModuleClassIDs;

    public MonitorReport() {
    }

    public MonitorReport(long fromTime, long toTime, boolean isCumulative) {
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.isCumulative = isCumulative;
    }

    public long getFromTime() {
        return this.fromTime;
    }

    public long getToTime() {
        return this.toTime;
    }

    public boolean isCumulative() {
        return this.isCumulative;
    }

    public Iterator getServiceMetrics() {
        return this.serviceMetrics.values().iterator();
    }

    public ServiceMetric getServiceMetric(ModuleClassID moduleClassID) {
        return (ServiceMetric)this.serviceMetrics.get(moduleClassID);
    }

    public void addServiceMetric(ServiceMetric serviceMetric) {
        this.serviceMetrics.put(serviceMetric.getModuleClassID(), serviceMetric);
    }

    public void addServiceMetric(ModuleClassID moduleClassID, ServiceMetric serviceMetric) {
        this.serviceMetrics.put(moduleClassID, serviceMetric);
    }

    public boolean isUnknownModuleClassIDs() {
        return this.unknownModuleClassIDs != null;
    }

    public Iterator getUnknownModuleClassIDs() {
        if (this.unknownModuleClassIDs != null) {
            return this.unknownModuleClassIDs.iterator();
        }
        return new LinkedList().iterator();
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addLong(element2, "toTime", this.toTime);
        DocumentSerializableUtilities.addLong(element2, "fromTime", this.fromTime);
        DocumentSerializableUtilities.addBoolean(element2, "isCumulative", this.isCumulative);
        Iterator i = this.serviceMetrics.values().iterator();
        while (i.hasNext()) {
            ServiceMetric serviceMetric = (ServiceMetric)i.next();
            Element serviceMetricElement = DocumentSerializableUtilities.createChildElement(element2, "service");
            DocumentSerializableUtilities.addString(serviceMetricElement, "moduleClassID", serviceMetric.getModuleClassID().toString());
            DocumentSerializableUtilities.addDocumentSerializable(serviceMetricElement, "serviceMetric", serviceMetric);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("toTime")) {
                this.toTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("fromTime")) {
                this.fromTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("isCumulative")) {
                this.isCumulative = DocumentSerializableUtilities.getBoolean(childElement);
                continue;
            }
            if (!tagName.equals("service")) continue;
            try {
                ModuleClassID moduleClassID = (ModuleClassID)JxtaUtilities.getIdFromString(DocumentSerializableUtilities.getString(childElement, "moduleClassID", "ERROR"));
                try {
                    ServiceMetric serviceMetric = MonitorResources.createServiceMetric(moduleClassID);
                    serviceMetric.init(moduleClassID);
                    Element serviceMetricElement = DocumentSerializableUtilities.getChildElement(childElement, "serviceMetric");
                    serviceMetric.initializeFrom(serviceMetricElement);
                    this.serviceMetrics.put(moduleClassID, serviceMetric);
                }
                catch (Exception ex) {
                    if (this.unknownModuleClassIDs == null) {
                        this.unknownModuleClassIDs = new LinkedList();
                    }
                    this.unknownModuleClassIDs.add(moduleClassID);
                }
            }
            catch (JxtaException jex) {
                throw new DocumentSerializationException("Can't get ModuleClassID", jex);
            }
        }
    }
}

