/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.impl.util.ScheduledJxtaEventHandler;

public class ScheduledJxtaTimer {
    private Thread timerThread;
    private LinkedList timerEvents = new LinkedList();
    private boolean keepRunning = true;

    public synchronized void addScheduledJxtaEventHandler(ScheduledJxtaEventHandler handler, long time) {
        TimerEvent timerEvent = new TimerEvent(handler, time);
        this.timerEvents.add(timerEvent);
        if (this.timerThread == null) {
            this.createTimeThread();
        } else {
            this.timerThread.interrupt();
        }
    }

    public synchronized void removeScheduledJxtaEventHandler(ScheduledJxtaEventHandler handler) {
        Iterator i = this.timerEvents.iterator();
        while (i.hasNext()) {
            TimerEvent timerEvent = (TimerEvent)i.next();
            if (!timerEvent.handler.equals(handler)) continue;
            i.remove();
            break;
        }
    }

    private TimerEvent getNextTimerEvent() {
        long nextEventTime = Long.MAX_VALUE;
        TimerEvent timerEvent = null;
        Iterator i = this.timerEvents.iterator();
        while (i.hasNext()) {
            TimerEvent te = (TimerEvent)i.next();
            if (te.eventTime >= nextEventTime) continue;
            timerEvent = te;
        }
        return timerEvent;
    }

    private void createTimeThread() {
        this.timerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (ScheduledJxtaTimer.this.keepRunning) {
                    try {
                        TimerEvent timerEvent = null;
                        LinkedList linkedList = ScheduledJxtaTimer.this.timerEvents;
                        synchronized (linkedList) {
                            long waitTime;
                            timerEvent = ScheduledJxtaTimer.this.getNextTimerEvent();
                            if (timerEvent == null) {
                                ScheduledJxtaTimer.this.timerEvents.wait();
                            }
                            if ((waitTime = timerEvent.eventTime - System.currentTimeMillis()) > 0L) {
                                Thread.sleep(waitTime);
                            }
                            ScheduledJxtaTimer.this.timerEvents.remove(timerEvent);
                        }
                        TimerEvent event = timerEvent;
                        new Thread(new Runnable(this, event){
                            private final /* synthetic */ TimerEvent val$event;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$event = val$event;
                            }

                            public void run() {
                                try {
                                    this.val$event.handler.execute();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }).start();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.timerThread.setDaemon(true);
        this.timerThread.start();
    }

    public synchronized void cancel() {
        this.keepRunning = false;
        if (this.timerThread != null) {
            this.timerThread.interrupt();
        }
    }

    class TimerEvent {
        long eventTime;
        ScheduledJxtaEventHandler handler;

        TimerEvent(ScheduledJxtaEventHandler handler, long eventTime) {
            this.handler = handler;
            this.eventTime = eventTime + System.currentTimeMillis();
        }
    }
}

