/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.impl.meter.MetricUtilities;
import net.jxta.peer.PeerID;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class SrdiDestinationMetric
implements DocumentSerializable {
    private PeerID peerID;
    private int messageProcessed;
    private int errorWhileProcessing;
    private int srdiToUnregisteredHandler = 0;
    private int messageSentViaUnicast;

    public SrdiDestinationMetric(PeerID peerID) {
        this.peerID = peerID;
    }

    public SrdiDestinationMetric(SrdiDestinationMetric prototype) {
        this.peerID = prototype.peerID;
    }

    public SrdiDestinationMetric() {
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    void messageProcessed() {
        ++this.messageProcessed;
    }

    public int getMessagesProcessed() {
        return this.messageProcessed;
    }

    void errorWhileProcessing() {
        ++this.errorWhileProcessing;
    }

    public int getErrorsWhileProcessing() {
        return this.errorWhileProcessing;
    }

    void messageSentViaUnicast() {
        ++this.messageSentViaUnicast;
    }

    public int getMessagesSentViaUnicast() {
        return this.messageSentViaUnicast;
    }

    public void srdiToUnregisteredHandler() {
        ++this.srdiToUnregisteredHandler;
    }

    public int getSrdiToUnregisteredHandler() {
        return this.srdiToUnregisteredHandler;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        if (this.peerID != null) {
            DocumentSerializableUtilities.addString(element2, "peerID", this.peerID.toString());
        }
        if (this.messageProcessed != 0) {
            DocumentSerializableUtilities.addInt(element2, "messageProcessed", this.messageProcessed);
        }
        if (this.errorWhileProcessing != 0) {
            DocumentSerializableUtilities.addInt(element2, "errorWhileProcessing", this.errorWhileProcessing);
        }
        if (this.srdiToUnregisteredHandler != 0) {
            DocumentSerializableUtilities.addInt(element2, "srdiToUnregisteredHandler", this.srdiToUnregisteredHandler);
        }
        if (this.messageSentViaUnicast != 0) {
            DocumentSerializableUtilities.addInt(element2, "messageSentViaUnicast", this.messageSentViaUnicast);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("peerID")) {
                String peerIDText = DocumentSerializableUtilities.getString(childElement);
                this.peerID = MetricUtilities.getPeerIdFromString(peerIDText);
                continue;
            }
            if (tagName.equals("messageProcessed")) {
                this.messageProcessed = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("errorWhileProcessing")) {
                this.errorWhileProcessing = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("srdiToUnregisteredHandler")) {
                this.srdiToUnregisteredHandler = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (!tagName.equals("messageSentViaUnicast")) continue;
            this.messageSentViaUnicast = DocumentSerializableUtilities.getInt(childElement);
        }
    }

    public void mergeMetrics(SrdiDestinationMetric otherSrdiDestinationMetric) {
        this.errorWhileProcessing += otherSrdiDestinationMetric.errorWhileProcessing;
        this.messageProcessed += otherSrdiDestinationMetric.messageProcessed;
        this.messageSentViaUnicast += otherSrdiDestinationMetric.messageSentViaUnicast;
    }

    public int hashCode() {
        return this.peerID.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof SrdiDestinationMetric) {
            SrdiDestinationMetric otherSrdiDestinationMetric = (SrdiDestinationMetric)other;
            return this.peerID.equals(otherSrdiDestinationMetric.peerID);
        }
        return false;
    }
}

