/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver.resolverMeter;

import net.jxta.impl.resolver.resolverMeter.SrdiDestinationMetric;
import net.jxta.peer.PeerID;

public class SrdiDestinationMeter {
    private PeerID peerID;
    private SrdiDestinationMetric cumulativeMetrics;
    private SrdiDestinationMetric deltaMetrics;

    public SrdiDestinationMeter(PeerID peerID) {
        this.peerID = peerID;
        this.cumulativeMetrics = new SrdiDestinationMetric(peerID);
    }

    public synchronized SrdiDestinationMetric collectMetrics() {
        SrdiDestinationMetric prevDelta = this.deltaMetrics;
        this.deltaMetrics = null;
        return prevDelta;
    }

    public SrdiDestinationMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new SrdiDestinationMetric(this.peerID);
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    protected void messageProcessed() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.messageProcessed();
        this.cumulativeMetrics.messageProcessed();
    }

    protected void srdiToUnregisteredHandler() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.srdiToUnregisteredHandler();
        this.cumulativeMetrics.srdiToUnregisteredHandler();
    }

    protected void errorWhileProcessing() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.errorWhileProcessing();
        this.cumulativeMetrics.errorWhileProcessing();
    }

    protected void messageSentViaUnicast() {
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.messageSentViaUnicast();
        this.cumulativeMetrics.messageSentViaUnicast();
    }
}

