/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rdv;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RdvGreeter;
import net.jxta.impl.rendezvous.RdvWalk;
import net.jxta.impl.rendezvous.RdvWalker;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.StdRendezVousService;
import net.jxta.impl.rendezvous.limited.LimitedRangeWalk;
import net.jxta.impl.rendezvous.rdv.ClientConnection;
import net.jxta.impl.util.TimeUtils;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RdvPeerRdvService
extends StdRendezVousService {
    private static final Logger LOG = Logger.getLogger((String)RdvPeerRdvService.class.getName());
    public static final String RDV_SVC_NAME = "RdvWalkSvcName";
    public static final String RDV_SVC_PARAM = "RdvWalkSvcParam";
    private Map clients;
    private long leaseDuration;
    private long maxNbOfClients;
    private RdvWalk walk;
    private RdvGreeter greeter;
    private RdvWalker walker;
    private WalkListener walkListener;

    public RdvPeerRdvService(PeerGroup g, RendezVousServiceImpl rdvService) {
        block11: {
            super(g, rdvService);
            this.clients = Collections.synchronizedMap(new HashMap());
            this.leaseDuration = 1200000L;
            this.maxNbOfClients = 200L;
            this.walk = null;
            this.greeter = null;
            this.walker = null;
            this.walkListener = null;
            ConfigParams confAdv = g.getConfigAdvertisement();
            if (confAdv != null) {
                Advertisement adv = null;
                try {
                    XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(rdvService.getAssignedID());
                    if (null != configDoc) {
                        adv = AdvertisementFactory.newAdvertisement(configDoc);
                    }
                }
                catch (NoSuchElementException failed) {
                    // empty catch block
                }
                if (adv instanceof RdvConfigAdv) {
                    RdvConfigAdv rdvConfigAdv = (RdvConfigAdv)adv;
                    if (-1 != rdvConfigAdv.getMaxTTL()) {
                        this.MAX_TTL = rdvConfigAdv.getMaxTTL();
                    }
                    if (0 != rdvConfigAdv.getMaxClients()) {
                        this.maxNbOfClients = rdvConfigAdv.getMaxClients();
                    }
                    if (0L != rdvConfigAdv.getLeaseDuration()) {
                        this.leaseDuration = rdvConfigAdv.getLeaseDuration();
                    }
                }
            }
            try {
                XMLDocument params = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                TextElement e = params.createElement("Rdv", Boolean.TRUE.toString());
                params.appendChild((Element)e);
                this.group.getPeerAdvertisement().putServiceParam(rdvService.getAssignedID(), params);
            }
            catch (Exception ohwell) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block11;
                LOG.warn((Object)"Failed adding service params", (Throwable)ohwell);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("RendezVous Service is initialized for " + this.group.getPeerGroupID() + " as a Rendezvous peer."));
        }
    }

    protected int startApp(String[] argv) {
        super.startApp(argv, new StdRdvRdvProtocolListener());
        this.rdvService.setMonitor(null);
        this.walkInit();
        this.timer.scheduleAtFixedRate((TimerTask)new GCTask(), 120000L, 120000L);
        this.rdvService.generateEvent(8, this.group.getPeerID());
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"RdvPeerRdvService is started");
        }
        return 0;
    }

    protected synchronized void stopApp() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.walkListener != null) {
            this.greeter.setEndpointListener(null);
            this.walkListener = null;
            this.greeter.stop();
            this.greeter = null;
        }
        if (this.walker != null) {
            this.walker.stop();
            this.walker = null;
        }
        if (this.walk != null) {
            this.walk.stop();
            this.walk = null;
        }
        this.disconnectAllClients();
        this.clients.clear();
        super.stopApp();
    }

    public void challengeRendezVous(ID peer, long delay) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    public void disconnectFromRendezVous(ID peerId) {
        throw new UnsupportedOperationException("Not supported by rendezvous");
    }

    public boolean isConnectedToRendezVous() {
        return false;
    }

    public void setChoiceDelay(long delay) {
    }

    public Vector getConnectedPeerIDs() {
        Vector<ID> result = new Vector<ID>();
        List<Object> allClients = Arrays.asList(this.clients.values().toArray());
        Iterator<Object> eachClient = allClients.iterator();
        while (eachClient.hasNext()) {
            PeerConnection aConnection = (PeerConnection)eachClient.next();
            if (!aConnection.isConnected()) continue;
            result.add(aConnection.getPeerID());
        }
        return result;
    }

    public Enumeration getConnectedPeers() {
        return Collections.enumeration(this.getConnectedPeerIDs());
    }

    public Enumeration getConnectedRendezVous() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getDisconnectedRendezVous() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public void propagate(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.walk((Message)msg.clone(), "JxtaPropagate", this.PropPName, ttl);
            this.sendToEachConnection(msg, propHdr);
            this.sendToNetwork(msg, propHdr);
        }
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.walk((Message)msg.clone(), "JxtaPropagate", this.PropPName, ttl);
            this.sendToEachConnection(msg, propHdr);
        }
    }

    protected void repropagate(Message msg, RendezVousPropagateMessage propHdr, String serviceName, String serviceParam) {
        block5: {
            try {
                propHdr = this.updatePropHeader(msg, propHdr, serviceName, serviceParam, this.MAX_TTL);
                if (null != propHdr) {
                    this.walk((Message)msg.clone(), "JxtaPropagate", this.PropPName, this.MAX_TTL);
                    this.sendToEachConnection(msg, propHdr);
                    this.sendToNetwork(msg, propHdr);
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Null propagate header, declining to repropagate " + msg));
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block5;
                LOG.debug((Object)("Could not repropagate " + msg + " (" + propHdr.getMsgId() + ")"), (Throwable)ez1);
            }
        }
    }

    public PeerConnection getPeerConnection(ID peer) {
        return (PeerConnection)this.clients.get(peer);
    }

    protected PeerConnection[] getPeerConnections() {
        return this.clients.values().toArray(new PeerConnection[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnection addClient(PeerAdvertisement padv, long lease) {
        int eventType;
        ClientConnection pConn;
        Object clientConnectionMeter = null;
        Map map = this.clients;
        synchronized (map) {
            pConn = (ClientConnection)this.clients.get(padv.getPeerID());
            if (null != pConn) {
                eventType = 3;
            } else {
                eventType = 2;
                pConn = new ClientConnection(this.group, this.rdvService, padv.getPeerID());
                this.clients.put(padv.getPeerID(), pConn);
            }
        }
        if (2 == eventType) {
            // empty if block
        }
        this.rdvService.generateEvent(eventType, padv.getPeerID());
        pConn.connect(padv, lease);
        return pConn;
    }

    private ClientConnection removeClient(ID peerid) {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Removing client " + peerid));
        }
        return (ClientConnection)this.clients.remove(peerid);
    }

    private void disconnectClient(PeerConnection pConn) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Disconnecting client " + pConn));
        }
        if (pConn.isConnected()) {
            pConn.disconnect();
            this.rdvService.generateEvent(6, pConn.getPeerID());
            this.sendDisconnect(pConn.getPeerID(), pConn.getCachedMessenger());
        }
        this.removeClient(pConn.getPeerID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAllClients() {
        Iterator<Object> eachConnected = Arrays.asList(this.clients.values().toArray()).iterator();
        while (eachConnected.hasNext()) {
            ClientConnection pConn = (ClientConnection)eachConnected.next();
            try {
                this.disconnectClient(pConn);
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("disconnectFromClient failed for" + pConn), (Throwable)ez1);
            }
        }
    }

    private void processDisconnectRequest(Message msg) {
        PeerAdvertisement adv = null;
        try {
            MessageElement elem = msg.getMessageElement("jxta", "Disconnect");
            adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(elem.getMimeType(), elem.getStream());
        }
        catch (Exception e) {
            return;
        }
        ClientConnection pConn = (ClientConnection)this.clients.get(adv.getPeerID());
        if (null != pConn) {
            pConn.disconnect();
            this.rdvService.generateEvent(6, pConn.getPeerID());
            this.disconnectClient(pConn);
        }
    }

    private void processLeaseRequest(Message msg) {
        ClientConnection pConn;
        long lease;
        PeerAdvertisement adv;
        block16: {
            try {
                MessageElement elem = msg.getMessageElement("jxta", "Connect");
                adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(elem.getMimeType(), elem.getStream());
                msg.removeMessageElement(elem);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Cannot retrieve advertisment from lease request", (Throwable)e);
                }
                return;
            }
            try {
                DiscoveryService discovery = this.group.getDiscoveryService();
                if (null != discovery) {
                    discovery.publish(adv, 0x6DDD00L, 0x6DDD00L);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block16;
                LOG.warn((Object)"Publish failed", (Throwable)e);
            }
        }
        RendezVousManager manager = this.rdvService.getManager();
        if (null != manager) {
            lease = manager.requestConnection(adv);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                if (lease > 0L) {
                    LOG.debug((Object)("Offering " + lease + "ms lease to " + adv.getName() + " [" + adv.getPeerID() + "]"));
                } else {
                    LOG.debug((Object)("Declining to offer lease to " + adv.getName() + " [" + adv.getPeerID() + "]"));
                }
            }
        } else {
            pConn = (ClientConnection)this.clients.get(adv.getPeerID());
            if (null != pConn) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Renewing client lease for " + pConn));
                }
                lease = this.leaseDuration;
            } else {
                long l = lease = (long)this.clients.size() >= this.maxNbOfClients ? 0L : this.leaseDuration;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Offering new client lease to " + adv.getName() + " [" + adv.getPeerID() + "]"));
                }
            }
        }
        if (lease > 0L) {
            pConn = this.addClient(adv, lease);
            this.sendLease(pConn, lease);
        }
    }

    private boolean sendLease(ClientConnection pConn, long lease) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Sending lease (" + lease + ") to " + pConn.getPeerName()));
        }
        Message msg = new Message();
        msg.addMessageElement("jxta", new TextDocumentMessageElement("RdvAdvReply", this.getPeerAdvertisementDoc(), null));
        msg.addMessageElement("jxta", new StringMessageElement("ConnectedPeer", this.group.getPeerID().toString(), null));
        msg.addMessageElement("jxta", new StringMessageElement("ConnectedLease", Long.toString(lease), null));
        pConn.sendMessage(msg, this.pName, this.pParam);
        return true;
    }

    public void walk(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Walk initiated for " + msg + " [" + serviceName + "/" + serviceParam + "]"));
        }
        if (this.walker == null) {
            IOException failure = new IOException("Cannot walk message : no walker");
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Cannot walk message : no walker", (Throwable)failure);
            }
            throw failure;
        }
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_SVC_NAME, serviceName, null));
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_SVC_PARAM, serviceParam, null));
        try {
            this.walker.sendMessage(null, msg, this.pName, this.pParam, ttl, null);
        }
        catch (IOException failure) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot send message with Walker", (Throwable)failure);
            }
            IOException failed = new IOException("Cannot send message with Walker");
            failed.initCause(failure);
            throw failed;
        }
    }

    public void walk(Vector destPeerIDs, Message msg, String serviceName, String serviceParam, int defaultTTL) throws IOException {
        if (destPeerIDs == null || destPeerIDs.size() == 0) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"No destination");
            }
            throw new IOException("no destination");
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("walk initiated for :\n\tsvc name:" + serviceName + "\tsvc params:" + serviceParam));
        }
        if (this.walker == null) {
            IOException failure = new IOException("Cannot walk message : no walker");
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Cannot walk message : no walker", (Throwable)failure);
            }
            throw failure;
        }
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_SVC_NAME, serviceName, null));
        msg.replaceMessageElement("jxta", new StringMessageElement(RDV_SVC_PARAM, serviceParam, null));
        PeerID dest = null;
        for (int i = 0; i < destPeerIDs.size(); ++i) {
            try {
                dest = (PeerID)destPeerIDs.elementAt(i);
                Message tmpMsg = (Message)msg.clone();
                this.walker.sendMessage(dest, tmpMsg, this.pName, this.pParam, defaultTTL, null);
                continue;
            }
            catch (Exception failed) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Cannot send message with Walker to: " + dest), (Throwable)failed);
                }
                IOException failure = new IOException("Cannot send message with Walker to: " + dest);
                failure.initCause(failed);
            }
        }
    }

    private void walkInit() {
        this.walk = new LimitedRangeWalk(this.group, this.pName, this.pParam, this.rdvService.rpv);
        this.greeter = this.walk.getGreeter();
        if (this.greeter == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot get Greeter");
            }
            return;
        }
        this.greeter.start();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Greeter listening on " + this.pName + "/" + this.pParam));
        }
        this.walker = this.walk.getWalker();
        if (this.walker == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot get Walker");
            }
            return;
        }
        this.walkListener = new WalkListener();
        this.greeter.setEndpointListener(this.walkListener);
    }

    private class WalkListener
    implements EndpointListener {
        private WalkListener() {
        }

        public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            block8: {
                String sParam;
                MessageElement serviceME = msg.getMessageElement("jxta", RdvPeerRdvService.RDV_SVC_NAME);
                if (null == serviceME) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Discarding " + msg + " because its missing service name element"));
                    }
                    return;
                }
                msg.removeMessageElement(serviceME);
                String sName = serviceME.toString();
                MessageElement paramME = msg.getMessageElement("jxta", RdvPeerRdvService.RDV_SVC_PARAM);
                if (null == paramME) {
                    sParam = null;
                } else {
                    msg.removeMessageElement(paramME);
                    sParam = paramME.toString();
                }
                EndpointAddress realDest = new EndpointAddress(dstAddr, sName, sParam);
                EndpointListener listener = RdvPeerRdvService.this.rdvService.getListener(sName + sParam);
                if (listener != null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Calling local listener for [" + sName + "/" + sParam + "] with " + msg));
                    }
                    try {
                        listener.processIncomingMessage(msg, srcAddr, realDest);
                    }
                    catch (Throwable ignored) {
                        if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block8;
                        LOG.error((Object)("Uncaught Throwable during callback of (" + listener + ") to " + sName + "/" + sParam), ignored);
                    }
                }
            }
        }
    }

    private class GCTask
    extends TimerTask {
        private GCTask() {
        }

        public void run() {
            block6: {
                try {
                    Iterator<Object> eachClient = Arrays.asList(RdvPeerRdvService.this.clients.values().toArray()).iterator();
                    while (eachClient.hasNext()) {
                        ClientConnection pConn = null;
                        try {
                            pConn = (ClientConnection)eachClient.next();
                            long now = TimeUtils.timeNow();
                            if (pConn.isConnected() && pConn.getLeaseEnd() >= now) continue;
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("GC CLIENT: dropping " + pConn));
                            }
                            pConn.disconnect();
                            RdvPeerRdvService.this.rdvService.generateEvent(7, pConn.getPeerID());
                            RdvPeerRdvService.this.disconnectClient(pConn);
                        }
                        catch (Exception e) {
                            if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                            LOG.error((Object)"gcClient failed ", (Throwable)e);
                        }
                    }
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block6;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
            }
        }
    }

    private class StdRdvRdvProtocolListener
    implements StdRendezVousService.StdRdvProtocolListener {
        private StdRdvRdvProtocolListener() {
        }

        public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + RdvPeerRdvService.this.group.getPeerGroupID() + "] processing " + msg));
            }
            if (msg.getMessageElement("jxta", "Connect") != null) {
                RdvPeerRdvService.this.processLeaseRequest(msg);
            }
            if (msg.getMessageElement("jxta", "Disconnect") != null) {
                RdvPeerRdvService.this.processDisconnectRequest(msg);
            }
            if (msg.getMessageElement("jxta", "RdvAdv") != null) {
                RdvPeerRdvService.this.processRdvAdvReply(msg);
            }
        }
    }
}

