/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.limited;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.LimitedRangeRdvMsg;
import net.jxta.impl.rendezvous.RdvGreeter;
import net.jxta.impl.rendezvous.RdvWalk;
import net.jxta.impl.rendezvous.rpv.PeerView;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.LimitedRangeRdvMessage;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LimitedRangeGreeter
extends RdvGreeter
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)LimitedRangeGreeter.class.getName());
    public static final String ServiceName = "LR-Greeter";
    private PeerGroup group = null;
    private EndpointService endpoint = null;
    private PeerView rpv = null;
    private RdvWalk walk = null;
    private boolean started = false;
    private final String svcName;
    private final String svcParam;

    public LimitedRangeGreeter(PeerGroup group, RdvWalk walk) {
        this.rpv = walk.getPeerView();
        this.group = group;
        this.walk = walk;
        this.svcName = ServiceName + group.getPeerGroupID().toString();
        this.svcParam = walk.getServiceName() + walk.getServiceParam();
        this.endpoint = group.getEndpointService();
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Listening on " + this.svcName + "/" + this.svcParam));
        }
        this.endpoint.addIncomingMessageListener(this, this.svcName, this.svcParam);
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.endpoint.removeIncomingMessageListener(this.svcName, this.svcParam);
        this.started = false;
        this.group = null;
        this.endpoint = null;
        this.rpv = null;
        this.walk = null;
        super.stop();
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        block7: {
            EndpointListener listener = this.getEndpointListener();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Processing " + message + " from " + srcAddr));
            }
            if (!this.checkMessage(message)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Limited Range Greeter received an invalid message. Dropping it.");
                }
                return;
            }
            if (listener != null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Limited Range Greeter calls listener");
                }
                try {
                    listener.processIncomingMessage(message, srcAddr, dstAddr);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block7;
                    LOG.error((Object)("Uncaught Throwable in listener (" + listener.getClass().getName() + ")"), ignored);
                }
            }
        }
    }

    private LimitedRangeRdvMessage getRdvMessage(Message msg) {
        LimitedRangeRdvMsg rdvMsg = null;
        MessageElement el = msg.getMessageElement("jxta", "LimitedRangeRdvMessage");
        try {
            if (el == null) {
                return null;
            }
            XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(el.getMimeType(), el.getStream());
            rdvMsg = new LimitedRangeRdvMsg(asDoc);
        }
        catch (Exception ez) {
            return null;
        }
        return rdvMsg;
    }

    private boolean checkMessage(Message msg) {
        LimitedRangeRdvMessage rdvMsg = this.getRdvMessage(msg);
        if (rdvMsg == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Limited Range Greeter received a message without LimitedRangeRdvMessage: invalid.");
            }
            return false;
        }
        if (rdvMsg.getTTL() <= 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Discarding " + msg + " TTL= " + rdvMsg.getTTL() + " invalid."));
            }
            return false;
        }
        rdvMsg.setTTL(rdvMsg.getTTL() - 1);
        return true;
    }

    public void replyMessage(Message msg, Message reply) throws IOException {
        ID peerid;
        LimitedRangeRdvMessage rdvMsg = this.getRdvMessage(msg);
        if (rdvMsg == null) {
            throw new IOException("LimitedRangeWalker was not able to send message: not from this greeter");
        }
        if (rdvMsg.getTTL() <= 0) {
            throw new IOException("LimitedRangeWalker was not able to send message: ttl expired");
        }
        try {
            peerid = IDFactory.fromURI(new URI(rdvMsg.getSrcPeerID()));
        }
        catch (URISyntaxException badID) {
            throw new IllegalArgumentException("Bad ID in message");
        }
        PeerViewElement pve = this.rpv.getPeerViewElement(peerid);
        if (null == pve) {
            throw new IOException("LimitedRangeWalker was not able to send message: no pve");
        }
        if (!pve.sendMessage(msg, rdvMsg.getSrcSvcName(), rdvMsg.getSrcSvcParams())) {
            throw new IOException("LimitedRangeWalker was not able to send message: send failed");
        }
    }
}

