/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.edge;

import net.jxta.id.ID;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.util.TimeUtils;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RdvConnection
extends PeerConnection {
    private static final transient Logger LOG = Logger.getLogger((String)RdvConnection.class.getName());
    protected long leasedTil;
    protected long beginRenewalAt;
    protected PeerAdvertisement cachedPeerAdvertisement = null;
    protected int cachedModCount = -1;

    public RdvConnection(PeerGroup group, RendezVousServiceImpl rdvService, ID peer) {
        super(group, rdvService, peer);
        this.cachedPeerAdvertisement = group.getPeerAdvertisement();
        this.cachedModCount = this.cachedPeerAdvertisement.getModCount();
    }

    public String toString() {
        return super.toString() + " / " + Long.toString(TimeUtils.toRelativeTimeMillis(this.beginRenewalAt));
    }

    public synchronized boolean peerAdvertisementHasChanged() {
        boolean changed = false;
        PeerAdvertisement currPeerAdv = this.group.getPeerAdvertisement();
        int currModCount = currPeerAdv.getModCount();
        if (this.cachedPeerAdvertisement != currPeerAdv || this.cachedModCount != currModCount) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("PeerAdvertisement has changed :\n\t" + System.identityHashCode(this.cachedPeerAdvertisement) + " != " + System.identityHashCode(currPeerAdv) + "\n\t" + this.cachedModCount + " != " + currModCount));
            }
            this.cachedPeerAdvertisement = currPeerAdv;
            this.cachedModCount = currModCount;
            changed = true;
        }
        return changed;
    }

    protected void setLease(long leaseDuration) {
        this.setLease(leaseDuration, 0L);
    }

    public void setLease(long leaseDuration, long earlyRenewal) {
        if (leaseDuration < earlyRenewal) {
            throw new IllegalArgumentException("Renewal scheduled before begining of lease");
        }
        super.setLease(leaseDuration);
        this.beginRenewalAt = TimeUtils.toAbsoluteTimeMillis(leaseDuration - earlyRenewal);
    }

    public void connect(PeerAdvertisement padv, long leaseDuration, long earlyRenewal) {
        super.connect(leaseDuration);
        this.setLease(leaseDuration, earlyRenewal);
        this.getCachedMessenger(padv);
    }

    public long getRenewal() {
        return this.beginRenewalAt;
    }
}

