/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.adhoc;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.id.ID;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AdhocPeerRdvService
extends RendezVousServiceProvider {
    private static final transient Logger LOG = Logger.getLogger((String)AdhocPeerRdvService.class.getName());
    private static final int DEFAULT_MAX_TTL = 2;

    public AdhocPeerRdvService(PeerGroup g, RendezVousServiceImpl rdvService) {
        super(g, rdvService);
        ConfigParams confAdv = g.getConfigAdvertisement();
        if (confAdv != null) {
            RdvConfigAdv rdvConfigAdv;
            Advertisement adv = null;
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(rdvService.getAssignedID());
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
                // empty catch block
            }
            this.MAX_TTL = adv instanceof RdvConfigAdv ? (-1 != (rdvConfigAdv = (RdvConfigAdv)adv).getMaxTTL() ? rdvConfigAdv.getMaxTTL() : 2) : 2;
        } else {
            this.MAX_TTL = 2;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("RendezVous Service is initialized for " + g.getPeerGroupID() + " as an ad hoc peer. "));
        }
    }

    protected int startApp(String[] arg) {
        super.startApp(arg);
        this.rdvService.generateEvent(9, this.group.getPeerID());
        return 0;
    }

    protected synchronized void stopApp() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.stopApp();
    }

    public Vector getConnectedPeerIDs() {
        return new Vector(0);
    }

    public Enumeration getConnectedPeers() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public boolean isConnectedToRendezVous() {
        return false;
    }

    public Enumeration getConnectedRendezVous() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getDisconnectedRendezVous() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public void connectToRendezVous(PeerAdvertisement adv) throws IOException {
        throw new UnsupportedOperationException("Not supported by ad hoc");
    }

    public void connectToRendezVous(EndpointAddress addr) throws IOException {
        throw new UnsupportedOperationException("Not supported by ad hoc");
    }

    public void challengeRendezVous(ID peer, long delay) {
        throw new UnsupportedOperationException("Not supported by ad hoc");
    }

    public void disconnectFromRendezVous(ID peerId) {
        throw new UnsupportedOperationException("Not supported by ad hoc");
    }

    public void setChoiceDelay(long delay) {
    }

    public void propagate(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.sendToNetwork(msg, propHdr);
        }
    }

    public void propagateInGroup(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.sendToNetwork(msg, propHdr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagate(Enumeration destPeerIDs, Message msg, String serviceName, String serviceParam, int ttl) {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            int numPeers = 0;
            block4: while (true) {
                while (destPeerIDs.hasMoreElements()) {
                    EndpointAddress addr;
                    Messenger messenger;
                    ID dest = (ID)destPeerIDs.nextElement();
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Sending " + msg + " to client " + dest));
                    }
                    if (null == (messenger = this.rdvService.endpoint.getMessenger(addr = AdhocPeerRdvService.mkAddress((PeerID)dest, "JxtaPropagate", this.PropPName)))) continue;
                    try {
                        messenger.sendMessage(msg);
                        ++numPeers;
                        continue block4;
                    }
                    catch (IOException failed) {
                    }
                }
                break;
            }
        }
    }

    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.sendToNetwork(msg, propHdr);
        }
    }

    public void walk(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        this.propagate(msg, serviceName, serviceParam, ttl);
    }

    public void walk(Vector destPeerIDs, Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        this.propagate(destPeerIDs.elements(), msg, serviceName, serviceParam, ttl);
    }

    protected void repropagate(Message msg, RendezVousPropagateMessage propHdr, String serviceName, String serviceParam) {
        block5: {
            try {
                propHdr = this.updatePropHeader(msg, propHdr, serviceName, serviceParam, this.MAX_TTL);
                if (null != propHdr) {
                    this.sendToNetwork(msg, propHdr);
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Declining to repropagate " + msg + " (" + propHdr.getMsgId() + ")"));
                }
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)("Could not repropagate " + msg + " (" + propHdr.getMsgId() + ")"), (Throwable)ez1);
            }
        }
    }
}

