/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.RendezVousServiceProvider;
import net.jxta.impl.rendezvous.rpv.PeerViewElement;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class StdRendezVousService
extends RendezVousServiceProvider {
    private static final Logger LOG = Logger.getLogger((String)StdRendezVousService.class.getName());
    public static final long GCDelay = 120000L;
    public static final String ConnectRequest = "Connect";
    public static final String DisconnectRequest = "Disconnect";
    public static final String ConnectedPeerReply = "ConnectedPeer";
    public static final String ConnectedLeaseReply = "ConnectedLease";
    public static final String ConnectedRdvAdvReply = "RdvAdvReply";
    public static final String RdvAdvReply = "RdvAdv";
    protected static final int DEFAULT_MAX_TTL = 200;
    protected final String pName;
    protected final String pParam;
    private StdRdvProtocolListener handler;
    protected Timer timer;

    protected StdRendezVousService(PeerGroup group, RendezVousServiceImpl rdvService) {
        super(group, rdvService);
        this.MAX_TTL = 200;
        this.pName = rdvService.getAssignedID().toString();
        this.pParam = group.getPeerGroupID().getUniqueValue().toString();
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new TimerThreadNamer("StdRendezVousService Timer for " + group.getPeerGroupID()), 0L);
    }

    protected int startApp(String[] argv, StdRdvProtocolListener handler) {
        this.handler = handler;
        this.rdvService.endpoint.addIncomingMessageListener(handler, this.pName, null);
        return super.startApp(argv);
    }

    protected void stopApp() {
        EndpointListener shouldbehandler = this.rdvService.endpoint.removeIncomingMessageListener(this.pName, null);
        if (this.handler != shouldbehandler && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("Unregistered listener was not as expected." + this.handler + " != " + shouldbehandler));
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        super.stopApp();
    }

    protected void processRdvAdvReply(Message msg) {
        block4: {
            try {
                MessageElement elem = msg.getMessageElement("jxta", RdvAdvReply);
                if (null != elem) {
                    PeerAdvertisement adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(elem.getMimeType(), elem.getStream());
                    DiscoveryService discovery = this.group.getDiscoveryService();
                    if (null != discovery) {
                        discovery.publish(adv, 0x6DDD00L, 0x6DDD00L);
                    }
                }
            }
            catch (Exception failed) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block4;
                LOG.debug((Object)"Publish Rdv Adv failed", (Throwable)failed);
            }
        }
    }

    public void processReceivedMessage(Message message, RendezVousPropagateMessage propHdr, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (srcAddr.getProtocolName().equalsIgnoreCase("jxta")) {
            String idstr = "urn:jxta:" + srcAddr.getProtocolAddress();
            ID id = null;
            try {
                id = IDFactory.fromURI(new URI(idstr));
            }
            catch (URISyntaxException badID) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Bad ID in message", (Throwable)badID);
                }
                return;
            }
            if (!this.group.getPeerID().equals(id)) {
                PeerConnection pConn = this.getPeerConnection(id);
                if (null == pConn) {
                    PeerViewElement pve = this.rdvService.rpv.getPeerViewElement(id);
                    if (null == pve) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Received " + message + " (" + propHdr.getMsgId() + ") from unrecognized peer : " + id));
                        }
                        propHdr.setTTL(Math.min(propHdr.getTTL(), 3));
                        if (this.rdvService.isRendezVous() || this.getPeerConnections().length > 0) {
                            this.sendDisconnect(id, null);
                        }
                    } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Received " + message + " (" + propHdr.getMsgId() + ") from " + pve));
                    }
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Received " + message + " (" + propHdr.getMsgId() + ") from " + pConn));
                }
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Received " + message + " (" + propHdr.getMsgId() + ") from loopback."));
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Received " + message + " (" + propHdr.getMsgId() + ") from network -- repropagating with TTL 2"));
            }
            propHdr.setTTL(Math.min(propHdr.getTTL(), 3));
        }
        super.processReceivedMessage(message, propHdr, srcAddr, dstAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propagate(Enumeration destPeerIDs, Message msg, String serviceName, String serviceParam, int ttl) {
        ttl = Math.min(ttl, this.MAX_TTL);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null == propHdr) {
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
            LOG.debug((Object)("Declined to send " + msg + " (" + propHdr.getMsgId() + ")"));
            return;
        }
        int numPeers = 0;
        try {
            while (destPeerIDs.hasMoreElements()) {
                ID dest = (ID)destPeerIDs.nextElement();
                try {
                    block11: {
                        PeerConnection pConn = this.getPeerConnection(dest);
                        if (null == pConn) {
                            EndpointAddress addr;
                            Messenger messenger;
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Sending " + msg + " (" + propHdr.getMsgId() + ") to " + dest));
                            }
                            if (null == (messenger = this.rdvService.endpoint.getMessengerImmediate(addr = StdRendezVousService.mkAddress((PeerID)dest, "JxtaPropagate", this.PropPName), null))) continue;
                            try {
                                messenger.sendMessage(msg);
                                break block11;
                            }
                            catch (IOException ignored) {
                                continue;
                            }
                        }
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Sending " + msg + " (" + propHdr.getMsgId() + ") to " + pConn));
                        }
                        if (!pConn.isConnected()) continue;
                        pConn.sendMessage((Message)msg.clone(), "JxtaPropagate", this.PropPName);
                    }
                    ++numPeers;
                }
                catch (Exception failed) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                    LOG.warn((Object)("Failed to send " + msg + " (" + propHdr.getMsgId() + ") to " + dest));
                }
            }
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) throw throwable;
            LOG.debug((Object)("Propagated " + msg + " (" + propHdr.getMsgId() + ") to " + numPeers + " peers."));
            throw throwable;
        }
        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
        LOG.debug((Object)("Propagated " + msg + " (" + propHdr.getMsgId() + ") to " + numPeers + " peers."));
    }

    public void propagateToNeighbors(Message msg, String serviceName, String serviceParam, int ttl) throws IOException {
        ttl = Math.min(this.MAX_TTL, ttl);
        RendezVousPropagateMessage propHdr = this.updatePropHeader(msg, this.getPropHeader(msg), serviceName, serviceParam, ttl);
        if (null != propHdr) {
            this.sendToNetwork(msg, propHdr);
        }
    }

    public abstract PeerConnection getPeerConnection(ID var1);

    protected abstract PeerConnection[] getPeerConnections();

    protected int sendToEachConnection(Message msg, RendezVousPropagateMessage propHdr) {
        int sentToPeers = 0;
        List<PeerConnection> peers = Arrays.asList(this.getPeerConnections());
        Iterator<PeerConnection> eachClient = peers.iterator();
        while (eachClient.hasNext()) {
            PeerConnection pConn = null;
            try {
                pConn = eachClient.next();
                if (!pConn.isConnected()) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)("Skipping " + pConn + " for " + msg + "(" + propHdr.getMsgId() + ") -- disconnected."));
                    continue;
                }
                if (propHdr.isVisited(pConn.getPeerID().toURI())) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)("Skipping " + pConn + " for " + msg + "(" + propHdr.getMsgId() + ") -- already visited."));
                    continue;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending " + msg + "(" + propHdr.getMsgId() + ") to " + pConn));
                }
                pConn.sendMessage((Message)msg.clone(), "JxtaPropagate", this.PropPName);
                ++sentToPeers;
            }
            catch (Exception e) {
                if (null != pConn) {
                    pConn.disconnect();
                }
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("Failed sending " + msg + "(" + propHdr.getMsgId() + ")  to " + pConn), (Throwable)e);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Sent " + msg + "(" + propHdr.getMsgId() + ") to " + sentToPeers + " of " + peers.size() + " peers."));
        }
        return sentToPeers;
    }

    protected void sendDisconnect(ID peerid, Messenger messenger) {
        block5: {
            Message msg = new Message();
            try {
                msg.replaceMessageElement("jxta", new TextDocumentMessageElement(DisconnectRequest, this.getPeerAdvertisementDoc(), null));
                if (null == messenger) {
                    EndpointAddress addr = StdRendezVousService.mkAddress(peerid, this.pName, this.pParam);
                    messenger = this.rdvService.endpoint.getMessenger(addr, null);
                }
                if (null == messenger) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Could not get messenger for " + peerid));
                    }
                    return;
                }
                messenger.sendMessage(msg, this.pName, this.pParam);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"sendDisconnect failed", (Throwable)e);
            }
        }
    }

    protected static interface StdRdvProtocolListener
    extends EndpointListener {
    }
}

