/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceImpl;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousMeter;
import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousServiceMonitor;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class RendezVousServiceProvider
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)RendezVousServiceProvider.class.getName());
    protected static final String PropSName = "JxtaPropagate";
    protected static final String MESSAGE_NAMESPACE_NAME = "jxta";
    protected final String PropPName;
    protected final String HEADER_NAME;
    protected int MAX_TTL;
    protected PeerGroup group = null;
    protected RendezVousServiceImpl rdvService = null;
    protected boolean closed = false;
    private PeerAdvertisement cachedPeerAdv = null;
    private int cachedPeerAdvModCount = -1;
    private XMLDocument cachedPeerAdvDoc = null;
    protected RendezvousServiceMonitor rendezvousServiceMonitor = null;
    protected RendezvousMeter rendezvousMeter = null;

    protected RendezVousServiceProvider(PeerGroup g, RendezVousServiceImpl rdvService) {
        this.group = g;
        this.rdvService = rdvService;
        this.PropPName = this.group.getPeerGroupID().getUniqueValue().toString();
        this.HEADER_NAME = "RendezVousPropagate" + this.PropPName;
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        RendezVousPropagateMessage propHdr = this.checkPropHeader(msg);
        if (null != propHdr) {
            String sName = propHdr.getDestSName();
            String sParam = propHdr.getDestSParam();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Processing " + msg + "(" + propHdr.getMsgId() + ") for " + sName + "/" + sParam + " from " + srcAddr));
            }
            this.processReceivedMessage(msg, propHdr, srcAddr, new EndpointAddress(dstAddr, sName, sParam));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLDocument getPeerAdvertisementDoc() {
        PeerAdvertisement newPadv = null;
        RendezVousServiceProvider rendezVousServiceProvider = this;
        synchronized (rendezVousServiceProvider) {
            newPadv = this.group.getPeerAdvertisement();
            int newModCount = newPadv.getModCount();
            if (this.cachedPeerAdv != newPadv || this.cachedPeerAdvModCount != newModCount) {
                this.cachedPeerAdv = newPadv;
                this.cachedPeerAdvModCount = newModCount;
            } else {
                newPadv = null;
            }
            if (null != newPadv) {
                this.cachedPeerAdvDoc = (XMLDocument)this.cachedPeerAdv.getDocument(MimeMediaType.XMLUTF8);
            }
        }
        return this.cachedPeerAdvDoc;
    }

    protected int startApp(String[] arg) {
        block8: {
            block7: {
                try {
                    if (!this.rdvService.endpoint.addIncomingMessageListener(this, PropSName, this.PropPName) && LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Cannot register the propagation listener (already registered)");
                    }
                    this.rdvService.addPropagateListener(PropSName + this.PropPName, this);
                }
                catch (Exception ez1) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block7;
                    LOG.error((Object)"Failed registering the propagation listener", (Throwable)ez1);
                }
            }
            try {
                if (this.rdvService.isRendezVous()) {
                    XMLDocument params = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                    XMLElement e = (XMLElement)params.createElement("Rdv", Boolean.TRUE.toString());
                    params.appendChild(e);
                    this.group.getPeerAdvertisement().putServiceParam(this.rdvService.getAssignedID(), params);
                } else {
                    this.group.getPeerAdvertisement().removeServiceParam(this.rdvService.getAssignedID());
                }
            }
            catch (Exception ignored) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block8;
                LOG.warn((Object)"Could not update Rdv Params in Peer Advertisement", (Throwable)ignored);
            }
        }
        return 0;
    }

    protected void stopApp() {
        EndpointListener shouldbeMe = this.rdvService.endpoint.removeIncomingMessageListener(PropSName, this.PropPName);
        if (this != shouldbeMe && LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("Unregistered listener was not as expected." + this + " != " + shouldbeMe));
        }
        this.group.getPeerAdvertisement().removeServiceParam(this.rdvService.getAssignedID());
        this.group = null;
        this.rdvService = null;
    }

    public void setRendezvousServiceMonitor(RendezvousServiceMonitor rendezvousServiceMonitor) {
    }

    public abstract void challengeRendezVous(ID var1, long var2);

    public abstract void disconnectFromRendezVous(ID var1);

    public abstract Enumeration getConnectedRendezVous();

    public abstract Enumeration getDisconnectedRendezVous();

    public abstract Vector getConnectedPeerIDs();

    public abstract Enumeration getConnectedPeers();

    public abstract void setChoiceDelay(long var1);

    public abstract void propagate(Message var1, String var2, String var3, int var4) throws IOException;

    public abstract void propagate(Enumeration var1, Message var2, String var3, String var4, int var5) throws IOException;

    public abstract void propagateToNeighbors(Message var1, String var2, String var3, int var4) throws IOException;

    public abstract boolean isConnectedToRendezVous();

    public abstract void walk(Message var1, String var2, String var3, int var4) throws IOException;

    public abstract void walk(Vector var1, Message var2, String var3, String var4, int var5) throws IOException;

    protected void processReceivedMessage(Message message, RendezVousPropagateMessage propHdr, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        EndpointListener listener;
        block6: {
            listener = this.rdvService.getListener(dstAddr.getServiceName() + dstAddr.getServiceParameter());
            if (listener != null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Calling local listener for [" + dstAddr.getServiceName() + dstAddr.getServiceParameter() + "] with " + message + " (" + propHdr.getMsgId() + ")"));
                }
                try {
                    listener.processIncomingMessage(message, srcAddr, dstAddr);
                }
                catch (Throwable ignored) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block6;
                    LOG.error((Object)("Uncaught Throwable during callback of (" + listener + ") to " + dstAddr), ignored);
                }
            }
        }
        if (this.rdvService.isRendezVous() || listener == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Repropagating " + message + " (" + propHdr.getMsgId() + ")"));
            }
            this.repropagate(message, propHdr, dstAddr.getServiceName(), dstAddr.getServiceParameter());
        }
    }

    protected abstract void repropagate(Message var1, RendezVousPropagateMessage var2, String var3, String var4);

    public abstract void propagateInGroup(Message var1, String var2, String var3, int var4) throws IOException;

    protected void sendToNetwork(Message msg, RendezVousPropagateMessage propHdr) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Endpoint propagating " + msg + " (" + propHdr.getMsgId() + ")"));
        }
        this.rdvService.endpoint.propagate((Message)msg.clone(), PropSName, this.PropPName);
    }

    protected static final EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURI(new URI(destPeer));
        }
        catch (URISyntaxException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return RendezVousServiceProvider.mkAddress(asID, serv, parm);
    }

    protected static final EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress(MESSAGE_NAMESPACE_NAME, destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    protected RendezVousPropagateMessage getPropHeader(Message msg) {
        MessageElement elem = msg.getMessageElement(MESSAGE_NAMESPACE_NAME, this.HEADER_NAME);
        if (elem == null) {
            return null;
        }
        try {
            StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(elem.getMimeType(), elem.getStream());
            return new RendezVousPropagateMessage(asDoc);
        }
        catch (IOException failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Could not get prop header of " + msg), (Throwable)failed);
            }
            IllegalArgumentException failure = new IllegalArgumentException("Could not get prop header of " + msg);
            failure.initCause(failed);
            throw failure;
        }
    }

    protected RendezVousPropagateMessage checkPropHeader(Message msg) {
        RendezVousPropagateMessage propHdr;
        try {
            propHdr = this.getPropHeader(msg);
            if (null == propHdr) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Discarding " + msg + " -- missing propagate header."));
                }
                return null;
            }
        }
        catch (Exception failure) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Discarding " + msg + " -- bad propagate header."), (Throwable)failure);
            }
            return null;
        }
        if (propHdr.getTTL() <= 0) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Discarding " + msg + "(" + propHdr.getMsgId() + ") -- dead on arrival (TTl=" + propHdr.getTTL() + ")."));
            }
            return null;
        }
        if (!this.rdvService.addMsgId(propHdr.getMsgId())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Discarding " + msg + "(" + propHdr.getMsgId() + ") -- feedback."));
            }
            return null;
        }
        if (propHdr.isVisited(this.group.getPeerID().toURI())) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Discarding " + msg + "(" + propHdr.getMsgId() + ") -- loopback."));
            }
            return null;
        }
        return propHdr;
    }

    protected RendezVousPropagateMessage updatePropHeader(Message msg, RendezVousPropagateMessage propHdr, String serviceName, String serviceParam, int ttl) {
        boolean newHeader = false;
        if (null == propHdr) {
            propHdr = this.newPropHeader(serviceName, serviceParam, ttl);
            newHeader = true;
        } else if (null == this.updatePropHeader(propHdr, ttl)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("TTL expired for " + msg + " (" + propHdr.getMsgId() + ") ttl=" + propHdr.getTTL()));
            }
            return null;
        }
        XMLDocument propHdrDoc = (XMLDocument)propHdr.getDocument(MimeMediaType.XMLUTF8);
        TextDocumentMessageElement elem = new TextDocumentMessageElement(this.HEADER_NAME, propHdrDoc, null);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)((newHeader ? "Added" : "Updated") + " prop header for " + msg + " (" + propHdr.getMsgId() + ") ttl=" + propHdr.getTTL()));
        }
        msg.replaceMessageElement(MESSAGE_NAMESPACE_NAME, elem);
        return propHdr;
    }

    private RendezVousPropagateMessage newPropHeader(String serviceName, String serviceParam, int ttl) {
        RendezVousPropagateMessage propHdr = new RendezVousPropagateMessage();
        propHdr.setTTL(ttl);
        propHdr.setDestSName(serviceName);
        propHdr.setDestSParam(serviceParam);
        UUID msgID = this.rdvService.createMsgId();
        propHdr.setMsgId(msgID);
        this.rdvService.addMsgId(msgID);
        propHdr.addVisited(this.group.getPeerID().toURI());
        return propHdr;
    }

    private RendezVousPropagateMessage updatePropHeader(RendezVousPropagateMessage propHdr, int maxTTL) {
        int msgTTL = propHdr.getTTL();
        URI me = this.group.getPeerID().toURI();
        int useTTL = msgTTL;
        if (!propHdr.isVisited(me)) {
            --useTTL;
        }
        useTTL = Math.min(useTTL, maxTTL);
        propHdr.setTTL(useTTL);
        propHdr.addVisited(me);
        return useTTL <= 0 ? null : propHdr;
    }
}

