/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.EncryptedPrivateKeyInfo;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.protocol.Certificate;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PSEConfigAdv
extends ExtendableAdvertisement {
    private static final String advType = "jxta:PSEConfig";
    private static final Logger LOG = Logger.getLogger((String)PSEConfigAdv.class.getName());
    private static final String ROOT_CERT_TAG = "RootCert";
    private static final String CERT_TAG = "Certificate";
    private static final String ENCRYPTED_PRIVATE_KEY_TAG = "EncryptedPrivateKey";
    private static final String KEY_STORE_TYPE_ATTR = "KeyStoreType";
    private static final String KEY_STORE_PROVIDER_ATTR = "KeyStoreProvider";
    private static final String KEY_STORE_LOCATION_TAG = "KeyStoreLocation";
    private static final String[] fields = new String[0];
    private List certs = null;
    private EncryptedPrivateKeyInfo encryptedPrivateKey = null;
    private String privAlgorithm = null;
    private String keyStoreType = null;
    private String keyStoreProvider = null;
    private URI keyStoreLocation = null;

    private PSEConfigAdv() {
    }

    private PSEConfigAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PSEConfigAdv.getAdvertisementType()) && !PSEConfigAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration eachAttr = doc.getAttributes();
        while (eachAttr.hasMoreElements()) {
            Attribute anAttr = (Attribute)eachAttr.nextElement();
            if (KEY_STORE_TYPE_ATTR.equals(anAttr.getName())) {
                this.keyStoreType = anAttr.getValue().trim();
                continue;
            }
            if (KEY_STORE_PROVIDER_ATTR.equals(anAttr.getName())) {
                this.keyStoreProvider = anAttr.getValue().trim();
                continue;
            }
            if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Unhandled Attribute: " + anAttr.getName()));
        }
        this.certs = new ArrayList();
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
        if (this.certs.isEmpty()) {
            throw new IllegalArgumentException("Root Certificate not initialized");
        }
        if (null == this.encryptedPrivateKey) {
            throw new IllegalArgumentException("Private Key not initialized");
        }
    }

    public Object clone() {
        PSEConfigAdv result = new PSEConfigAdv();
        result.encryptedPrivateKey = this.encryptedPrivateKey;
        result.privAlgorithm = this.privAlgorithm;
        result.setCertificateChain(this.getCertificateChain());
        return result;
    }

    public static String getAdvertisementType() {
        return advType;
    }

    public String getAdvType() {
        return PSEConfigAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return PSEConfigAdv.getAdvertisementType();
    }

    public ID getID() {
        ByteArrayInputStream data = new ByteArrayInputStream(this.getCert().getBytes());
        try {
            return IDFactory.newCodatID(PeerGroupID.worldPeerGroupID, new byte[16], data);
        }
        catch (IOException failed) {
            throw new UndeclaredThrowableException(failed, "Could not generate id");
        }
    }

    public X509Certificate getCertificate() {
        return (X509Certificate)this.certs.get(0);
    }

    public X509Certificate[] getCertificateChain() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public String getCert() {
        try {
            return PSEUtils.base64Encode(this.getCertificate().getEncoded());
        }
        catch (Throwable failed) {
            throw new IllegalStateException("Failed to process root cert");
        }
    }

    public void setCert(String newCert) {
        try {
            byte[] cert_der = PSEUtils.base64Decode(new StringReader(newCert));
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            this.setCertificate((X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert_der)));
        }
        catch (Throwable failed) {
            throw new IllegalArgumentException("Failed to process cert");
        }
    }

    public void setCertificate(X509Certificate newCert) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("setCert : " + newCert));
        }
        if (null == newCert) {
            this.encryptedPrivateKey = null;
            this.certs = null;
        } else {
            this.certs = Collections.singletonList(newCert);
        }
    }

    public void setCertificateChain(X509Certificate[] newCert) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("setCert : " + newCert));
        }
        if (null == newCert) {
            this.encryptedPrivateKey = null;
            this.certs = null;
        } else {
            this.certs = new ArrayList<X509Certificate>(Arrays.asList(newCert));
        }
    }

    public PrivateKey getPrivateKey(char[] password) {
        return PSEUtils.pkcs5_Decrypt_pbePrivateKey(password, this.privAlgorithm, this.encryptedPrivateKey);
    }

    public EncryptedPrivateKeyInfo getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public String getEncryptedPrivateKeyAlgo() {
        return this.privAlgorithm;
    }

    public String getEncryptedPrivKey() {
        try {
            return PSEUtils.base64Encode(this.encryptedPrivateKey.getEncoded());
        }
        catch (Throwable failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Failed to process private key", failed);
            }
            throw new IllegalStateException("Failed to process private key");
        }
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String provider) {
        this.keyStoreProvider = provider;
    }

    public URI getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(URI location) {
        this.keyStoreLocation = location;
    }

    public void setEncryptedPrivateKey(String newPriv, String algorithm) {
        try {
            byte[] key_der = PSEUtils.base64Decode(new StringReader(newPriv));
            EncryptedPrivateKeyInfo newEncryptedPriv = new EncryptedPrivateKeyInfo(key_der);
            this.setEncryptedPrivateKey(newEncryptedPriv, algorithm);
        }
        catch (Throwable failed) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Failed to process private key", failed);
            }
            throw new IllegalArgumentException("Failed to process private key :" + failed.toString());
        }
    }

    public void setEncryptedPrivateKey(EncryptedPrivateKeyInfo newPriv, String algorithm) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("setPrivateKey : " + newPriv));
        }
        this.encryptedPrivateKey = newPriv;
        this.privAlgorithm = algorithm;
    }

    public void setPrivateKey(PrivateKey newPriv, char[] password) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("setPrivateKey : " + newPriv));
        }
        EncryptedPrivateKeyInfo encypted = PSEUtils.pkcs5_Encrypt_pbePrivateKey(password, newPriv, 500);
        this.setEncryptedPrivateKey(encypted, newPriv.getAlgorithm());
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (ROOT_CERT_TAG.equals(elem.getName())) {
            Enumeration elements = elem.getChildren();
            while (elements.hasMoreElements()) {
                XMLElement eachcertelem = (XMLElement)elements.nextElement();
                if (CERT_TAG.equals(eachcertelem.getName())) {
                    eachcertelem.addAttribute("type", Certificate.getMessageType());
                    Certificate certChain = new Certificate(eachcertelem);
                    this.setCertificateChain(certChain.getCertificates());
                    continue;
                }
                if (ENCRYPTED_PRIVATE_KEY_TAG.equals(eachcertelem.getName())) {
                    String value = eachcertelem.getTextValue();
                    if (null == value) {
                        throw new IllegalArgumentException("Empty Private Key element");
                    }
                    value = value.trim();
                    Attribute algo = eachcertelem.getAttribute("algorithm");
                    if (null == algo) {
                        throw new IllegalArgumentException("Private Key element must include algorithm attribute");
                    }
                    this.setEncryptedPrivateKey(value, algo.getValue());
                    continue;
                }
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("Unhandled Element: " + eachcertelem.getName()));
            }
            return true;
        }
        if (KEY_STORE_LOCATION_TAG.equals(elem.getName())) {
            try {
                this.keyStoreLocation = new URI(elem.getTextValue());
            }
            catch (URISyntaxException badURI) {
                IllegalArgumentException iae = new IllegalArgumentException("Bad key store location URI");
                iae.initCause(badURI);
                throw iae;
            }
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (adv instanceof Attributable) {
            Attributable attrDoc = (Attributable)((Object)adv);
            if (null != this.keyStoreType) {
                attrDoc.addAttribute(KEY_STORE_TYPE_ATTR, this.keyStoreType);
                if (null != this.keyStoreProvider) {
                    attrDoc.addAttribute(KEY_STORE_PROVIDER_ATTR, this.keyStoreProvider);
                }
            }
        }
        if (null != this.keyStoreLocation) {
            Element keyStoreLocationURI = adv.createElement(KEY_STORE_LOCATION_TAG, this.keyStoreLocation.toString());
            adv.appendChild(keyStoreLocationURI);
        }
        Element rootcert = adv.createElement(ROOT_CERT_TAG, null);
        adv.appendChild(rootcert);
        String encodedRoot = this.getCert();
        if (null == encodedRoot) {
            throw new IllegalStateException("Root Certificate not initialized");
        }
        Element cert = adv.createElement(CERT_TAG, encodedRoot);
        rootcert.appendChild(cert);
        String encodedPrivateKey = this.getEncryptedPrivKey();
        if (null == encodedPrivateKey) {
            throw new IllegalStateException("Private key not initialized");
        }
        Element privatekey = adv.createElement(ENCRYPTED_PRIVATE_KEY_TAG, encodedPrivateKey);
        rootcert.appendChild(privatekey);
        if (privatekey instanceof Attributable) {
            ((Attributable)((Object)privatekey)).addAttribute("algorithm", this.privAlgorithm);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PSEConfigAdv.advType;
        }

        public Advertisement newInstance() {
            return new PSEConfigAdv();
        }

        public Advertisement newInstance(Element root) {
            return new PSEConfigAdv(root);
        }
    }
}

