/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.Set;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.pipe.InputPipeImpl;
import net.jxta.impl.pipe.NonBlockingWireOutputPipe;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.impl.pipe.WireHeader;
import net.jxta.impl.pipe.WirePipe;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class WirePipeImpl
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger((String)WirePipeImpl.class.getName());
    public static final String WireName = "jxta.service.wirepipe";
    public static final String WireTagName = "JxtaWireHeader";
    public static final String WireServiceName = "PipeService.Wire";
    private PeerGroup group = null;
    private PipeResolver pipeResolver = null;
    private RendezVousService rendezvous = null;
    private final String WireParam;
    private String localPeerId = null;

    WirePipeImpl(PeerGroup group, PipeResolver pipeResolver) {
        this.group = group;
        this.pipeResolver = pipeResolver;
        this.rendezvous = group.getRendezVousService();
        if (null == this.rendezvous) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Cannot run without rendezvous service");
            }
            throw new IllegalStateException("Cannot run without rendezvous service");
        }
        this.localPeerId = group.getPeerID().toString();
        this.WireParam = group.getPeerGroupID().getUniqueValue().toString();
        group.getEndpointService().addIncomingMessageListener(this, WireServiceName, null);
    }

    public String getServiceParameter() {
        return this.WireParam;
    }

    public String getServiceName() {
        return WireServiceName;
    }

    public int startApp(String[] arg) {
        try {
            this.rendezvous.addPropagateListener(WireName, this.WireParam, this);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cannot register Propagate Listener", (Throwable)e);
            }
            throw new IllegalStateException("Cannot register Propagate Listener");
        }
        return 0;
    }

    public void stopApp() {
        this.rendezvous.removePropagateListener(WireName, this.WireParam, this);
        this.group.getEndpointService().removeIncomingMessageListener(WireServiceName, null);
    }

    InputPipe createInputPipe(PipeAdvertisement adv, PipeMsgListener listener) throws IOException {
        WirePipe wirePipe = this.getWirePipe(adv);
        return new InputPipeImpl(wirePipe, adv, listener);
    }

    NonBlockingWireOutputPipe createOutputPipe(PipeAdvertisement adv, Set peers) {
        WirePipe wirePipe = this.getWirePipe(adv);
        return new NonBlockingWireOutputPipe(this.group, wirePipe, adv, peers);
    }

    private synchronized WirePipe getWirePipe(PipeAdvertisement adv) {
        WirePipe wirePipe = (WirePipe)this.pipeResolver.findLocal((PipeID)adv.getPipeID());
        if (null != wirePipe) {
            return wirePipe;
        }
        return new WirePipe(this.group, this.pipeResolver, this, adv);
    }

    private synchronized WirePipe getWirePipe(PipeID pipeID) {
        WirePipe wirePipe = (WirePipe)this.pipeResolver.findLocal(pipeID);
        if (null != wirePipe) {
            return wirePipe;
        }
        PipeAdvertisement adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        adv.setPipeID(pipeID);
        adv.setType("JxtaPropagate");
        return new WirePipe(this.group, this.pipeResolver, this, adv);
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        WireHeader header;
        MessageElement elem = message.getMessageElement("jxta", WireTagName);
        if (null == elem) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"No JxtaWireHeader element. Discarding message.");
            }
            return;
        }
        try {
            XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(elem.getMimeType(), elem.getStream());
            header = new WireHeader(doc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"bad wire header", (Throwable)e);
            }
            return;
        }
        WirePipe wirePipe = this.getWirePipe((PipeID)header.getPipeID());
        wirePipe.processIncomingMessage(message, header, srcAddr, dstAddr);
    }
}

